/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.importers.types;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import mchorse.bbs_mod.importers.ImporterContext;
import mchorse.bbs_mod.importers.ImporterUtils;
import mchorse.bbs_mod.importers.types.IImporter;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PNGImporter
implements IImporter {
    @Override
    public IKey getName() {
        return UIKeys.IMPORTER_PNG;
    }

    @Override
    public boolean canImport(ImporterContext context) {
        return ImporterUtils.checkFileExtension(context.files, ".png");
    }

    @Override
    public void importFiles(ImporterContext context) {
        for (File file : context.files) {
            try {
                File destination = context.getDestination(this);
                Files.copy((File)file, (File)new File(destination, file.getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

