/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.l10n;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.l10n.keys.LangKey;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.utility.UILanguageEditorOverlayPanel;
import mchorse.bbs_mod.ui.utils.Label;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class L10n {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private Map<String, LangKey> strings = new HashMap<String, LangKey>();
    private Set<Function<String, List<Link>>> langFiles = new LinkedHashSet<Function<String, List<Link>>>();
    private List<Pair<String, String>> supportedLanguages;

    private static List<Pair<String, String>> read(Link link) {
        try {
            String string = IOUtils.readText(BBSMod.getProvider().getAsset(link));
            MapType mapType = DataToString.mapFromString(string);
            ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
            for (String key : mapType.keys()) {
                if (!mapType.has(key, 2)) continue;
                pairs.add(new Pair<String, String>(key, mapType.getString(key)));
            }
            return pairs;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public L10n() {
        this.reloadSupportedLanguages(L10n.read(Link.assets("extra_languages.json")));
    }

    public static IKey lang(String key) {
        return BBSModClient.getL10n().getKey(key);
    }

    public static IKey lang(String key, String content, IKey reference) {
        LangKey langKey = BBSModClient.getL10n().getKey(key, content);
        if (reference instanceof LangKey) {
            langKey.reference = (LangKey)reference;
        }
        return langKey;
    }

    public void reloadSupportedLanguages(List<Pair<String, String>> additionalLanguages) {
        this.supportedLanguages = new ArrayList<Pair<String, String>>();
        this.supportedLanguages.addAll(L10n.read(Link.assets("languages.json")));
        this.supportedLanguages.addAll(additionalLanguages);
    }

    public Map<String, LangKey> getStrings() {
        return this.strings;
    }

    public List<String> getSupportedLanguageCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (Pair<String, String> pair : this.supportedLanguages) {
            codes.add((String)pair.b);
        }
        return codes;
    }

    public List<Label<String>> getSupportedLanguageLabels() {
        ArrayList<Label<String>> labels = new ArrayList<Label<String>>();
        for (Pair<String, String> pair : this.supportedLanguages) {
            labels.add(new Label<String>(IKey.constant((String)pair.a), (String)pair.b));
        }
        return labels;
    }

    public List<Link> getAllLinks(String lang) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Function<String, List<Link>> function : this.langFiles) {
            links.addAll((Collection<Link>)function.apply(lang));
        }
        return links;
    }

    public void registerOne(Function<String, Link> function) {
        this.langFiles.add(lang -> Collections.singletonList((Link)function.apply((String)lang)));
    }

    public void register(Function<String, List<Link>> function) {
        this.langFiles.add(function);
    }

    public void reload() {
        this.reload((String)BBSSettings.language.get(), BBSMod.getProvider());
    }

    public void reload(String language, AssetProvider provider) {
        List<Link> links = this.getAllLinks(DEFAULT_LANGUAGE);
        if (!language.equals(DEFAULT_LANGUAGE)) {
            links.addAll(this.getAllLinks(language));
        }
        for (Link link : links) {
            try {
                InputStream asset = provider.getAsset(link);
                try {
                    System.out.println("Loading language file \"" + String.valueOf(link) + "\".");
                    this.load(link, asset);
                }
                finally {
                    if (asset == null) continue;
                    asset.close();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load " + String.valueOf(link) + " language file!");
                e.printStackTrace();
            }
        }
        File export = UILanguageEditorOverlayPanel.getLangEditorFolder();
        File[] files = export.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            try {
                this.overwrite(DataToString.mapFromString(IOUtils.readText(file)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void load(Link origin, InputStream stream) {
        MapType map = DataToString.mapFromString(IOUtils.readText(stream));
        for (Map.Entry<String, BaseType> entry : map) {
            if (!entry.getValue().isString()) continue;
            String string = entry.getValue().asString();
            LangKey langKey = this.strings.get(entry.getKey());
            if (langKey == null) {
                langKey = new LangKey(origin, entry.getKey(), string);
            } else {
                langKey.setOrigin(origin);
                langKey.content = string;
            }
            this.strings.put(entry.getKey(), langKey);
        }
    }

    public void overwrite(MapType strings) {
        for (Map.Entry<String, BaseType> entry : strings) {
            LangKey key = this.strings.get(entry.getKey());
            if (key == null || !entry.getValue().isString()) continue;
            key.content = entry.getValue().asString();
        }
    }

    public LangKey getKey(String key) {
        return this.getKey(key, key);
    }

    public LangKey getKey(String key, String content) {
        LangKey langKey = this.strings.computeIfAbsent(key, k -> new LangKey(null, (String)k, content));
        langKey.wasRequested = true;
        return langKey;
    }
}

