/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.mixin.client;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.utils.VideoRecorder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_9779.class_9781.class})
public class RenderTickCounterDynamicMixin {
    @Shadow
    private float field_51958;
    @Shadow
    private float field_51959;
    @Shadow
    private float field_51961;
    @Shadow
    private long field_51962;
    @Unique
    private int heldFrameCounter;

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBeginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        VideoRecorder videoRecorder = BBSModClient.getVideoRecorder();
        if (videoRecorder != null && videoRecorder.isRecording()) {
            int heldFrames = (Integer)BBSSettings.videoSettings.heldFrames.get();
            float videoFrameRate = BBSRendering.getVideoFrameRate();
            float ticksPerFrame = 20.0f / videoFrameRate;
            if (this.heldFrameCounter == 0) {
                this.field_51958 = ticksPerFrame;
                this.field_51959 += ticksPerFrame;
                int ticksToAdvance = (int)this.field_51959;
                this.field_51959 -= (float)ticksToAdvance;
                this.field_51961 = this.field_51959;
                this.field_51962 = timeMillis;
                cir.setReturnValue((Object)ticksToAdvance);
            } else {
                this.field_51958 = 0.0f;
                cir.setReturnValue((Object)0);
            }
            ++this.heldFrameCounter;
            if (this.heldFrameCounter >= heldFrames) {
                this.heldFrameCounter = 0;
            }
            return;
        }
        this.heldFrameCounter = 0;
    }

    @Inject(method={"beginRenderTick(JZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBeginRenderTickWithPause(long timeMillis, boolean paused, CallbackInfoReturnable<Integer> cir) {
        VideoRecorder videoRecorder = BBSModClient.getVideoRecorder();
        if (videoRecorder != null && videoRecorder.isRecording()) {
            this.onBeginRenderTick(timeMillis, cir);
        }
    }
}

