/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.network;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.actions.ActionManager;
import mchorse.bbs_mod.actions.ActionPlayer;
import mchorse.bbs_mod.actions.ActionRecorder;
import mchorse.bbs_mod.actions.ActionState;
import mchorse.bbs_mod.actions.PlayerType;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.entity.GunProjectileEntity;
import mchorse.bbs_mod.entity.IEntityFormProvider;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmManager;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.payloads.BBSPayloads;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.EnumUtils;
import mchorse.bbs_mod.utils.PermissionUtils;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.repos.RepositoryOperation;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork {
    public static final int STATE_TRIGGER_MORPH = 0;
    public static final int STATE_TRIGGER_MAIN_HAND_ITEM = 1;
    public static final int STATE_TRIGGER_OFF_HAND_ITEM = 2;

    public static void reset() {
    }

    public static void setup() {
        BBSPayloads.registerPayloads();
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ModelBlockFormRequestPayload.ID, ServerNetwork::handleModelBlockFormPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ModelBlockTransformsRequestPayload.ID, ServerNetwork::handleModelBlockTransformsPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.PlayerFormRequestPayload.ID, ServerNetwork::handlePlayerFormPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ManagerDataRequestPayload.ID, ServerNetwork::handleManagerDataPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ActionRecordingPayload.ID, ServerNetwork::handleActionRecording);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ToggleFilmPayload.ID, ServerNetwork::handleToggleFilm);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ActionControlPayload.ID, ServerNetwork::handleActionControl);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.FilmDataSyncPayload.ID, ServerNetwork::handleSyncData);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.PlayerTeleportPayload.ID, ServerNetwork::handleTeleportPlayer);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.AnimationStateTriggerRequestPayload.ID, ServerNetwork::handleAnimationStateTriggerPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ShareFormPayload.ID, ServerNetwork::handleSharedFormPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.ZoomPayload.ID, ServerNetwork::handleZoomPacket);
        ServerPlayNetworking.registerGlobalReceiver(BBSPayloads.PauseFilmRequestPayload.ID, ServerNetwork::handlePauseFilmPacket);
    }

    private static void handleModelBlockFormPacket(BBSPayloads.ModelBlockFormRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        class_2338 pos = payload.pos();
        byte[] bytes = payload.formData();
        try {
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> {
                class_1937 world = player.method_37908();
                class_2586 be = world.method_8321(pos);
                if (be instanceof ModelBlockEntity) {
                    ModelBlockEntity modelBlock = (ModelBlockEntity)be;
                    modelBlock.updateForm(data, world);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleModelBlockTransformsPacket(BBSPayloads.ModelBlockTransformsRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        byte[] bytes = payload.transformsData();
        try {
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> {
                class_1799 stack = player.method_6118(class_1304.field_6173).method_7972();
                player.method_5673(class_1304.field_6173, stack);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handlePlayerFormPacket(BBSPayloads.PlayerFormRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        byte[] bytes = payload.formData();
        Form form = null;
        try {
            BaseType baseType = DataStorageUtils.readFromBytes(bytes);
            if (baseType instanceof MapType) {
                MapType data = (MapType)baseType;
                form = (Form)BBSMod.getForms().fromData(data);
            }
        }
        catch (Exception data) {
            // empty catch block
        }
        Form finalForm = form;
        server.execute(() -> {
            Morph.getMorph((class_1297)player).setForm(FormUtils.copy(finalForm));
            ServerNetwork.sendMorphToTracked(player, finalForm);
        });
    }

    private static void handleManagerDataPacket(BBSPayloads.ManagerDataRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        byte[] bytes = payload.data();
        int callbackId = payload.callbackId();
        RepositoryOperation op = RepositoryOperation.values()[payload.operation()];
        MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
        FilmManager films = BBSMod.getFilms();
        if (op == RepositoryOperation.LOAD) {
            String id = data.getString("id");
            Film film = (Film)films.load(id);
            ServerNetwork.sendManagerData(player, callbackId, op, film.toData());
        } else if (op == RepositoryOperation.SAVE) {
            films.save(data.getString("id"), data.getMap("data"));
        } else if (op == RepositoryOperation.RENAME) {
            films.rename(data.getString("from"), data.getString("to"));
        } else if (op == RepositoryOperation.DELETE) {
            films.delete(data.getString("id"));
        } else if (op == RepositoryOperation.KEYS) {
            ListType list = DataStorageUtils.stringListToData(films.getKeys());
            ServerNetwork.sendManagerData(player, callbackId, op, list);
        } else if (op == RepositoryOperation.ADD_FOLDER) {
            ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.addFolder(data.getString("folder"))));
        } else if (op == RepositoryOperation.RENAME_FOLDER) {
            ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.renameFolder(data.getString("from"), data.getString("to"))));
        } else if (op == RepositoryOperation.DELETE_FOLDER) {
            ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.deleteFolder(data.getString("folder"))));
        }
    }

    private static void handleActionRecording(BBSPayloads.ActionRecordingPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = payload.filmId();
        int replayId = payload.replayId();
        int tick = payload.tick();
        int countdown = payload.countdown();
        boolean recording = payload.recording();
        server.execute(() -> {
            if (recording) {
                Film film = (Film)BBSMod.getFilms().load(filmId);
                if (film != null) {
                    BBSMod.getActions().startRecording(film, player, 0, countdown, replayId);
                }
            } else {
                ActionRecorder recorder = BBSMod.getActions().stopRecording(player);
                Clips clips = recorder.composeClips();
                ServerNetwork.sendRecordedActions(player, filmId, replayId, tick, clips);
            }
        });
    }

    private static void handleToggleFilm(BBSPayloads.ToggleFilmPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = payload.filmId();
        boolean withCamera = payload.withCamera();
        server.execute(() -> {
            ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
            if (actionPlayer != null) {
                BBSMod.getActions().stop(filmId);
                for (class_3222 otherPlayer : server.method_3760().method_14571()) {
                    ServerNetwork.sendStopFilm(otherPlayer, filmId);
                }
            } else {
                ServerNetwork.sendPlayFilm(player, player.method_51469(), filmId, withCamera);
            }
        });
    }

    private static void handleActionControl(BBSPayloads.ActionControlPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        ActionManager actions = BBSMod.getActions();
        String filmId = payload.filmId();
        ActionState state = EnumUtils.getValue(payload.state(), ActionState.values(), ActionState.STOP);
        int tick = payload.tick();
        server.execute(() -> {
            if (state == ActionState.SEEK) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                }
            } else if (state == ActionState.PLAY) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = true;
                }
            } else if (state == ActionState.PAUSE) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = false;
                }
            } else if (state == ActionState.RESTART) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer == null) {
                    Film film = (Film)BBSMod.getFilms().load(filmId);
                    if (film != null) {
                        actionPlayer = actions.play(player, player.method_51469(), film, tick, PlayerType.FILM_EDITOR);
                    }
                } else {
                    actions.stop(filmId);
                    actionPlayer = actions.play(player, player.method_51469(), actionPlayer.film, tick, PlayerType.FILM_EDITOR);
                }
                if (actionPlayer != null) {
                    actionPlayer.syncing = true;
                    actionPlayer.playing = false;
                    if (tick != 0) {
                        actionPlayer.goTo(0, tick);
                    }
                }
                ServerNetwork.sendStopFilm(player, filmId);
            } else if (state == ActionState.STOP) {
                actions.stop(filmId);
            }
        });
    }

    private static void handleSyncData(BBSPayloads.FilmDataSyncPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = payload.filmId();
        String[] pathArray = payload.path();
        byte[] bytes = payload.data();
        ArrayList<String> path = new ArrayList<String>();
        for (String s : pathArray) {
            path.add(s);
        }
        BaseType data = DataStorageUtils.readFromBytes(bytes);
        server.execute(() -> BBSMod.getActions().syncData(filmId, new DataPath(path), data));
    }

    private static void handleTeleportPlayer(BBSPayloads.PlayerTeleportPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        double x = payload.x();
        double y = payload.y();
        double z = payload.z();
        float yaw = payload.yaw();
        float bodyYaw = payload.bodyYaw();
        float pitch = payload.pitch();
        server.execute(() -> {
            player.method_5859(x, y, z);
            player.method_36456(yaw);
            player.method_5847(yaw);
            player.method_5636(bodyYaw);
            player.method_36457(pitch);
        });
    }

    private static void handleAnimationStateTriggerPacket(BBSPayloads.AnimationStateTriggerRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        String trigger = payload.trigger();
        int type = payload.type();
        BBSPayloads.AnimationStateTriggerPayload outPayload = new BBSPayloads.AnimationStateTriggerPayload(player.method_5628(), trigger, type);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)outPayload);
        }
        server.execute(() -> {});
    }

    private static void handleSharedFormPacket(BBSPayloads.ShareFormPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        UUID playerUuid = payload.targetPlayer();
        byte[] bytes = payload.formData();
        MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
        server.execute(() -> {
            class_3222 otherPlayer = server.method_3760().method_14602(playerUuid);
            if (otherPlayer != null) {
                ServerNetwork.sendSharedForm(otherPlayer, data);
            }
        });
    }

    private static void handleZoomPacket(BBSPayloads.ZoomPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        boolean zoom = payload.zooming();
        class_1799 main = player.method_6047();
        if (main.method_7909() == BBSMod.GUN_ITEM) {
            String command;
            GunProperties properties = GunProperties.get(main);
            String string = command = zoom ? properties.cmdZoomOn : properties.cmdZoomOff;
            if (!command.isEmpty()) {
                server.method_3734().method_44252(player.method_5671(), command);
            }
        }
    }

    private static void handlePauseFilmPacket(BBSPayloads.PauseFilmRequestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        String filmId = payload.filmId();
        ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
        if (actionPlayer != null) {
            actionPlayer.toggle();
        }
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            ServerNetwork.sendPauseFilm(playerEntity, filmId);
        }
    }

    public static void sendMorph(class_3222 player, int playerId, Form form) {
        byte[] formData = DataStorageUtils.writeToBytes(FormUtils.toData(form));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.PlayerFormPayload(playerId, formData));
    }

    public static void sendMorphToTracked(class_3222 player, Form form) {
        ServerNetwork.sendMorph(player, player.method_5628(), form);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerNetwork.sendMorph(otherPlayer, player.method_5628(), form);
        }
    }

    public static void sendClickedModelBlock(class_3222 player, class_2338 pos) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.ClickedModelBlockPayload(pos));
    }

    public static void sendPlayFilm(class_3222 player, class_3218 world, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, world, film, 0);
                BaseType data = film.toData();
                byte[] filmData = DataStorageUtils.writeToBytes(data);
                for (class_1657 p : world.method_18456()) {
                    if (!(p instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)p;
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new BBSPayloads.PlayFilmPayload(filmId, filmData, withCamera));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPlayFilm(class_3222 player, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, player.method_51469(), film, 0);
                byte[] filmData = DataStorageUtils.writeToBytes(film.toData());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.PlayFilmPayload(filmId, filmData, withCamera));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendStopFilm(class_3222 player, String filmId) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.StopFilmPayload(filmId));
    }

    public static void sendManagerData(class_3222 player, int callbackId, RepositoryOperation op, BaseType data) {
        byte[] bytes = DataStorageUtils.writeToBytes(data);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.ManagerDataPayload(callbackId, op.ordinal(), bytes));
    }

    public static void sendRecordedActions(class_3222 player, String filmId, int replayId, int tick, Clips clips) {
        byte[] clipsData = DataStorageUtils.writeToBytes(clips.toData());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.RecordedActionsPayload(filmId, replayId, tick, clipsData));
    }

    public static void sendHandshake(MinecraftServer server, class_3244 handler) {
        String id = "";
        if (server.method_3724()) {
            id = "";
        }
        ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new BBSPayloads.HandshakePayload(id));
    }

    public static void sendHandshake(MinecraftServer server, class_3222 player) {
        String id = "";
        if (server.method_3724()) {
            id = "";
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.HandshakePayload(id));
    }

    public static void sendCheatsPermission(class_3222 player, boolean cheats) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.CheatsPermissionPayload(cheats));
    }

    public static void sendSharedForm(class_3222 player, MapType data) {
        byte[] formData = DataStorageUtils.writeToBytes(data);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.SharedFormPayload(formData));
    }

    public static void sendEntityForm(class_3222 player, IEntityFormProvider actor) {
        byte[] formData = DataStorageUtils.writeToBytes(FormUtils.toData(actor.getForm()));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.EntityFormPayload(actor.getEntityId(), formData));
    }

    public static void sendActors(class_3222 player, String filmId, Map<String, class_1309> actors) {
        int[] entityIds = new int[actors.size()];
        String[] actorKeys = new String[actors.size()];
        int i = 0;
        for (Map.Entry<String, class_1309> entry : actors.entrySet()) {
            actorKeys[i] = entry.getKey();
            entityIds[i] = entry.getValue().method_5628();
            ++i;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.ActorsPayload(filmId, entityIds, actorKeys));
    }

    public static void sendGunProperties(class_3222 player, GunProjectileEntity projectile) {
        GunProperties properties = projectile.getProperties();
        byte[] propertiesData = DataStorageUtils.writeToBytes(properties.toData());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.GunPropertiesPayload(projectile.method_5628(), propertiesData));
    }

    public static void sendPauseFilm(class_3222 player, String filmId) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.PauseFilmPayload(filmId));
    }

    public static void sendSelectedSlot(class_3222 player, int slot) {
        player.method_31548().field_7545 = slot;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.SelectedSlotPayload(slot));
    }

    public static void sendModelBlockState(class_3222 player, class_2338 pos, String trigger) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.ModelBlockStateTriggerPayload(pos, trigger));
    }

    public static void sendReloadModelBlocks(class_3222 player, int tickRandom) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BBSPayloads.RefreshModelBlocksPayload(tickRandom));
    }
}

