/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.renderer;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.clips.ClipFactoryData;
import mchorse.bbs_mod.ui.film.UIClips;
import mchorse.bbs_mod.ui.film.clips.renderer.IUIClipRenderer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.Envelope;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

@Environment(value=EnvType.CLIENT)
public class UIClipRenderer<T extends Clip>
implements IUIClipRenderer<T> {
    private static final Color ENVELOPE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.25f);
    private static Vector2f vector = new Vector2f();
    private static Vector2f previous = new Vector2f();

    @Override
    public void renderClip(UIContext context, UIClips clips, T clip, Area area, boolean selected, boolean current) {
        int y = area.y;
        int h = area.h;
        int left = area.x;
        int right = area.ex();
        if (current) {
            int color = (Integer)BBSSettings.primaryColor.get();
            context.batcher.dropShadow(left + 2, y + 2, right - 2, y + h - 2, 8, -1157627904 + color, color);
        }
        ClipFactoryData data = clips.getFactory().getData((Clip)clip);
        int color = 0xFF000000 | data.color;
        if (((Boolean)((Clip)clip).enabled.get()).booleanValue()) {
            this.renderBackground(context, color, clip, area, selected, current);
        } else {
            context.batcher.iconArea(Icons.DISABLED, color, left, y, right - left, h);
        }
        context.batcher.outline(left, y, right, y + h, selected ? -1 : -2013265920);
        if (right - left > 10 && ((Boolean)((Clip)clip).envelope.enabled.get()).booleanValue()) {
            this.renderEnvelope(context, ((Clip)clip).envelope, (Integer)((Clip)clip).duration.get(), left + 1, y + 1, right - 1, y + 17);
        }
        FontRenderer font = context.batcher.getFont();
        String label = font.limitToWidth((String)((Clip)clip).title.get(), right - 6 - left);
        if (right - left >= 20) {
            context.batcher.icon(data.icon, Colors.mulA(Colors.mulRGB(-1, 0.75f), 0.5f), right - 2, y + h / 2, 1.0f, 0.5f);
        }
        if (!label.isEmpty()) {
            context.batcher.textShadow(label, left + 5, y + (h - font.getHeight()) / 2);
        }
    }

    protected void renderBackground(UIContext context, int color, T clip, Area area, boolean selected, boolean current) {
        context.batcher.box(area.x, area.y, area.ex(), area.ey(), color);
    }

    private void renderEnvelope(UIContext context, Envelope envelope, int duration, int x1, int y1, int x2, int y2) {
        Matrix4f matrix = context.batcher.getContext().method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        if (((Boolean)envelope.keyframes.get()).booleanValue()) {
            if (!envelope.channel.isEmpty()) {
                this.renderEnvelopesKeyframes(builder, matrix, envelope.channel, duration, x1, y1, x2, y2);
            }
        } else {
            this.renderSimpleEnvelope(builder, matrix, envelope, duration, x1, y1, x2, y2);
        }
        class_286.method_43433((class_9801)builder.method_60800());
    }

    private void renderEnvelopesKeyframes(class_287 builder, Matrix4f matrix, KeyframeChannel<Double> channel, int duration, int x1, int y1, int x2, int y2) {
        Keyframe<Double> prevKeyframe = null;
        int c = ENVELOPE_COLOR.getARGBColor();
        for (Keyframe<Double> keyframe : channel.getKeyframes()) {
            if (prevKeyframe != null) {
                Vector2f point = this.calculateEnvelopePoint(vector, (int)keyframe.getTick(), keyframe.getValue().floatValue(), duration, x1, y1, x2, y2);
                Vector2f prevPoint = this.calculateEnvelopePoint(previous, (int)prevKeyframe.getTick(), prevKeyframe.getValue().floatValue(), duration, x1, y1, x2, y2);
                builder.method_22918(matrix, prevPoint.x, (float)y2, 0.0f).method_39415(c);
                builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
                builder.method_22918(matrix, prevPoint.x, prevPoint.y, 0.0f).method_39415(c);
                builder.method_22918(matrix, point.x, (float)y2, 0.0f).method_39415(c);
                builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
                builder.method_22918(matrix, prevPoint.x, (float)y2, 0.0f).method_39415(c);
            }
            prevKeyframe = keyframe;
        }
        if (prevKeyframe != null && prevKeyframe.getTick() < (float)duration) {
            Vector2f point = this.calculateEnvelopePoint(vector, (int)prevKeyframe.getTick(), prevKeyframe.getValue().floatValue(), duration, x1, y1, x2, y2);
            builder.method_22918(matrix, point.x, (float)y2, 0.0f).method_39415(c);
            builder.method_22918(matrix, (float)x2, point.y, 0.0f).method_39415(c);
            builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
            builder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_39415(c);
            builder.method_22918(matrix, (float)x2, point.y, 0.0f).method_39415(c);
            builder.method_22918(matrix, point.x, (float)y2, 0.0f).method_39415(c);
        }
    }

    protected void renderSimpleEnvelope(class_287 builder, Matrix4f matrix, Envelope envelope, int duration, int x1, int y1, int x2, int y2) {
        int c = ENVELOPE_COLOR.getARGBColor();
        Vector2f point = this.calculateEnvelopePoint(vector, (int)envelope.getStartX(duration), 0.0f, duration, x1, y1, x2, y2);
        builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
        previous.set((Vector2fc)point);
        point = this.calculateEnvelopePoint(vector, (int)envelope.getStartDuration(duration), 1.0f, duration, x1, y1, x2, y2);
        builder.method_22918(matrix, point.x, (float)y2, 0.0f).method_39415(c);
        builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
        previous.set((Vector2fc)point);
        point = this.calculateEnvelopePoint(vector, (int)envelope.getEndDuration(duration), 1.0f, duration, x1, y1, x2, y2);
        builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
        builder.method_22918(matrix, UIClipRenderer.previous.x, (float)y2, 0.0f).method_39415(c);
        builder.method_22918(matrix, point.x, (float)y2, 0.0f).method_39415(c);
        builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
        builder.method_22918(matrix, UIClipRenderer.previous.x, UIClipRenderer.previous.y, 0.0f).method_39415(c);
        builder.method_22918(matrix, UIClipRenderer.previous.x, (float)y2, 0.0f).method_39415(c);
        previous.set((Vector2fc)point);
        point = this.calculateEnvelopePoint(vector, (int)envelope.getEndX(duration), 0.0f, duration, x1, y1, x2, y2);
        builder.method_22918(matrix, UIClipRenderer.previous.x, UIClipRenderer.previous.y, 0.0f).method_39415(c);
        builder.method_22918(matrix, UIClipRenderer.previous.x, (float)y2, 0.0f).method_39415(c);
        builder.method_22918(matrix, point.x, point.y, 0.0f).method_39415(c);
    }

    protected Vector2f calculateEnvelopePoint(Vector2f vector, int tick, float value, int duration, int x1, int y1, int x2, int y2) {
        int width = x2 - x1;
        int height = y2 - y1;
        vector.x = MathUtils.clamp((float)tick / (float)duration * (float)width + (float)x1, (float)x1, (float)x2);
        vector.y = (1.0f - MathUtils.clamp(value, 0.0f, 1.0f)) * (float)height + (float)y1;
        return vector;
    }
}

