/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import mchorse.bbs_mod.camera.data.Angle;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.values.ValueAngle;
import mchorse.bbs_mod.camera.values.ValuePoint;
import mchorse.bbs_mod.camera.values.ValuePosition;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.InterpolationUtils;
import mchorse.bbs_mod.ui.utils.context.ContextAction;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.interps.IInterp;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UICameraUtils {
    public static final IKey KEYS_CATEGORY = UIKeys.INTERPOLATIONS_KEY_CATEGORY;

    public static void interps(UIContext context, Collection<IInterp> values, IInterp current, Consumer<IInterp> consumer) {
        context.replaceContextMenu(menu -> {
            for (IInterp interpolation : values) {
                ContextAction action = menu.action(Icons.ADD, InterpolationUtils.getName(interpolation), interpolation == current, () -> consumer.accept(interpolation));
                InterpolationUtils.setupKeybind(interpolation, action, KEYS_CATEGORY);
            }
        });
    }

    public static void positionContextMenu(ContextMenuManager menu, IUIClipsDelegate editor, ValuePosition value) {
        menu.action(Icons.COPY, UIKeys.CAMERA_PANELS_CONTEXT_COPY_POSITION, 0xFF3333, () -> {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            UICameraUtils.copyPoint(map, (Point)value.getPoint().get());
            UICameraUtils.copyAngle(map, (Angle)value.getAngle().get());
            Window.setClipboard(UICameraUtils.mapToString(map));
        });
        menu.action(Icons.PASTE, UIKeys.CAMERA_PANELS_CONTEXT_PASTE_POSITION, () -> {
            Map<String, Double> map = UICameraUtils.stringToMap(Window.getClipboard());
            Position position = new Position();
            Point point = UICameraUtils.createPoint(map);
            Angle angle = UICameraUtils.createAngle(map);
            if (point != null && angle != null) {
                position.point.set(point);
                position.angle.set(angle);
                value.set(position);
                editor.fillData();
            }
        });
        UICameraUtils.pointContextMenu(menu, editor, value.getPoint());
        UICameraUtils.angleContextMenu(menu, editor, value.getAngle());
    }

    public static void pointContextMenu(ContextMenuManager menu, IUIClipsDelegate editor, ValuePoint value) {
        menu.action(Icons.COPY, UIKeys.CAMERA_PANELS_CONTEXT_COPY_POINT, 0x33FF33, () -> {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            UICameraUtils.copyPoint(map, (Point)value.get());
            Window.setClipboard(UICameraUtils.mapToString(map));
        });
        menu.action(Icons.PASTE, UIKeys.CAMERA_PANELS_CONTEXT_PASTE_POINT, () -> {
            Point point = UICameraUtils.createPoint(UICameraUtils.stringToMap(Window.getClipboard()));
            if (point != null) {
                value.set(point);
                editor.fillData();
            }
        });
    }

    private static void copyPoint(Map<String, Double> map, Point point) {
        map.put("X", point.x);
        map.put("Y", point.y);
        map.put("Z", point.z);
    }

    private static Point createPoint(Map<String, Double> map) {
        if (map.containsKey("x") && map.containsKey("y") && map.containsKey("z")) {
            Point newPoint = new Point(0.0, 0.0, 0.0);
            if (map.containsKey("x")) {
                newPoint.x = map.get("x");
            }
            if (map.containsKey("y")) {
                newPoint.y = map.get("y");
            }
            if (map.containsKey("z")) {
                newPoint.z = map.get("z");
            }
            return newPoint;
        }
        return null;
    }

    public static void angleContextMenu(ContextMenuManager menu, IUIClipsDelegate editor, ValueAngle value) {
        menu.action(Icons.COPY, UIKeys.CAMERA_PANELS_CONTEXT_COPY_ANGLE, 0xFFBB00, () -> {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            UICameraUtils.copyAngle(map, (Angle)value.get());
            Window.setClipboard(UICameraUtils.mapToString(map));
        });
        menu.action(Icons.PASTE, UIKeys.CAMERA_PANELS_CONTEXT_PASTE_ANGLE, () -> {
            Angle angle = UICameraUtils.createAngle(UICameraUtils.stringToMap(Window.getClipboard()));
            if (angle != null) {
                value.set(angle);
                editor.fillData();
            }
        });
    }

    private static void copyAngle(Map<String, Double> map, Angle angle) {
        map.put("Yaw", Double.valueOf(angle.yaw));
        map.put("Pitch", Double.valueOf(angle.pitch));
        map.put("Roll", Double.valueOf(angle.roll));
        map.put("FOV", Double.valueOf(angle.fov));
    }

    private static Angle createAngle(Map<String, Double> map) {
        if (map.containsKey("yaw") && map.containsKey("pitch")) {
            Angle newAngle = new Angle(0.0f, 0.0f);
            if (map.containsKey("yaw")) {
                newAngle.yaw = map.get("yaw").floatValue();
            }
            if (map.containsKey("pitch")) {
                newAngle.pitch = map.get("pitch").floatValue();
            }
            if (map.containsKey("roll")) {
                newAngle.roll = map.get("roll").floatValue();
            }
            if (map.containsKey("fov")) {
                newAngle.fov = map.get("fov").floatValue();
            }
            return newAngle;
        }
        return null;
    }

    private static String mapToString(Map<String, Double> data) {
        StringJoiner joiner = new StringJoiner("\n");
        for (String key : data.keySet()) {
            joiner.add(key + ": " + String.valueOf(data.get(key)));
        }
        return joiner.toString();
    }

    private static Map<String, Double> stringToMap(String string) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (String line : string.split("\n")) {
            String[] splits = line.split(":");
            if (splits.length != 2) continue;
            try {
                map.put(splits[0].trim().toLowerCase(), Double.parseDouble(splits[1].trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }
}

