/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.importers.IImportPathProvider;
import mchorse.bbs_mod.importers.ImporterContext;
import mchorse.bbs_mod.importers.Importers;
import mchorse.bbs_mod.importers.types.IImporter;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIRenderingContext;
import mchorse.bbs_mod.ui.utils.IFileDropListener;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.utils.FFMpegUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UIScreen
extends class_437
implements IFileDropListener {
    private UIBaseMenu menu;
    private UIRenderingContext context;
    private int lastGuiScale;

    public static void open(UIBaseMenu menu) {
        class_310.method_1551().method_1507((class_437)new UIScreen((class_2561)class_2561.method_43473(), menu));
    }

    public static UIBaseMenu getCurrentMenu() {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof UIScreen) {
            UIScreen uiScreen = (UIScreen)currentScreen;
            return uiScreen.menu;
        }
        return null;
    }

    public UIScreen(class_2561 title, UIBaseMenu menu) {
        super(title);
        this.menu = menu;
    }

    private void ensureContextInitialized() {
        if (this.context == null) {
            class_310 mc = class_310.method_1551();
            this.context = new UIRenderingContext(new class_332(mc, mc.method_22940().method_23000()));
            this.menu.context.setup(this.context);
        }
    }

    public UIBaseMenu getMenu() {
        return this.menu;
    }

    public void update() {
        this.menu.update();
    }

    public void renderInWorld(WorldRenderContext context) {
        this.menu.renderInWorld(context);
    }

    public void method_29638(List<Path> paths) {
        super.method_29638(paths);
        String[] filePaths = new String[paths.size()];
        int i = 0;
        for (Path path : paths) {
            filePaths[i] = path.toAbsolutePath().toString();
            ++i;
        }
        this.acceptFilePaths(filePaths);
    }

    public void method_25432() {
        class_310.method_1551().field_1690.method_42474().method_41748((Object)this.lastGuiScale);
        class_310.method_1551().method_15993();
        super.method_25432();
        this.menu.onClose(null);
        if (this.menu.canHideHUD()) {
            class_310.method_1551().field_1690.field_1842 = false;
        }
    }

    public void method_49589() {
        class_310 mc = class_310.method_1551();
        this.lastGuiScale = (Integer)mc.field_1690.method_42474().method_41753();
        mc.field_1690.method_42474().method_41748((Object)BBSModClient.getGUIScale());
        if (this.field_22787 != null) {
            super.method_49589();
            mc.method_15993();
        }
        this.menu.onOpen(null);
        if (this.menu.canHideHUD()) {
            mc.field_1690.field_1842 = true;
        }
    }

    public boolean method_25421() {
        return this.menu.canPause();
    }

    protected void method_25426() {
        super.method_25426();
        this.ensureContextInitialized();
        this.menu.resize(this.field_22789, this.field_22790);
    }

    public void method_25410(class_310 client, int width, int height) {
        if (client != null && this.field_22787 != null) {
            super.method_25410(client, width, height);
        }
        this.menu.resize(width, height);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.menu.mouseClicked((int)mouseX, (int)mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.menu.mouseScrolled((int)mouseX, (int)mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.menu.mouseReleased((int)mouseX, (int)mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.menu.handleKey(keyCode, scanCode, BBSRendering.lastAction, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.menu.handleKey(keyCode, scanCode, 0, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        this.menu.handleTextInput(chr);
        return true;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.ensureContextInitialized();
        this.menu.context.setTransition(this.field_22787.method_60646().method_60637(false));
        this.menu.renderMenu(this.context, mouseX, mouseY);
        this.menu.context.render.executeRunnables();
    }

    @Override
    public void acceptFilePaths(String[] paths) {
        if (this.menu != null) {
            if (!FFMpegUtils.checkFFMPEG()) {
                this.menu.context.notifyError(UIKeys.IMPORTER_FFMPEG_NOTIFICATION);
                return;
            }
            File directory = null;
            boolean open = true;
            for (IImportPathProvider iImportPathProvider : this.menu.getRoot().getChildren(IImportPathProvider.class)) {
                directory = iImportPathProvider.getImporterPath();
                if (directory == null) continue;
                open = false;
                break;
            }
            ArrayList<File> files = new ArrayList<File>();
            for (String path : paths) {
                File file = new File(path);
                if (!file.exists()) continue;
                files.add(file);
            }
            ImporterContext importerContext = new ImporterContext(files, directory);
            for (IImporter importer : Importers.getImporters()) {
                if (!importer.canImport(importerContext)) continue;
                importer.importFiles(importerContext);
                if (open) {
                    UIUtils.openFolder(importerContext.getDestination(importer));
                }
                this.menu.context.notifySuccess(UIKeys.IMPORTER_SUCCESS_NOTIFICATION.format(importer.getName()));
                return;
            }
        }
    }
}

