/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import mchorse.bbs_mod.ui.framework.elements.IViewport;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.utils.IViewportStack;
import mchorse.bbs_mod.ui.utils.Area;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIViewportStack
implements IViewportStack {
    private Stack<Area> viewportStack = new Stack();
    private List<Area> viewportAreas = new ArrayList<Area>();
    private int shiftX;
    private int shiftY;

    public static UIViewportStack fromElement(UIElement element) {
        UIViewportStack stack = new UIViewportStack();
        stack.applyFromElement(element);
        return stack;
    }

    public void applyFromElement(UIElement element) {
        ArrayList<IViewport> elements = new ArrayList<IViewport>();
        while (element != null) {
            if (element instanceof IViewport) {
                elements.add((IViewport)((Object)element));
            }
            element = element.getParent();
        }
        for (int i = elements.size() - 1; i >= 0; --i) {
            ((IViewport)elements.get(i)).apply(this);
        }
    }

    @Override
    public void reset() {
        this.shiftX = 0;
        this.shiftY = 0;
        this.viewportStack.clear();
    }

    @Override
    public Area getViewport() {
        return this.viewportStack.isEmpty() ? null : this.viewportStack.peek();
    }

    @Override
    public void pushViewport(Area area) {
        if (this.viewportStack.isEmpty()) {
            Area child = this.getCurrentViewportArea();
            child.copy(area);
            this.viewportStack.push(child);
        } else {
            Area current = this.viewportStack.peek();
            Area child = this.getCurrentViewportArea();
            child.copy(area);
            current.clamp(child);
            this.viewportStack.push(child);
        }
    }

    private Area getCurrentViewportArea() {
        while (this.viewportAreas.size() < this.viewportStack.size() + 1) {
            this.viewportAreas.add(new Area());
        }
        return this.viewportAreas.get(this.viewportStack.size());
    }

    @Override
    public void popViewport() {
        this.viewportStack.pop();
    }

    @Override
    public int getShiftX() {
        return this.shiftX;
    }

    @Override
    public int getShiftY() {
        return this.shiftY;
    }

    @Override
    public int globalX(int x) {
        return x - this.shiftX;
    }

    @Override
    public int globalY(int y) {
        return y - this.shiftY;
    }

    @Override
    public int localX(int x) {
        return x + this.shiftX;
    }

    @Override
    public int localY(int y) {
        return y + this.shiftY;
    }

    @Override
    public void shiftX(int x) {
        this.shiftX += x;
        if (!this.viewportStack.isEmpty()) {
            this.viewportStack.peek().x += x;
        }
    }

    @Override
    public void shiftY(int y) {
        this.shiftY += y;
        if (!this.viewportStack.isEmpty()) {
            this.viewportStack.peek().y += y;
        }
    }
}

