/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2d;

@Environment(value=EnvType.CLIENT)
public class UIChalkboard
extends UIElement {
    private UIColor picker;
    private Pixels pixels;
    private Texture texture;
    private int color = Colors.setA(0xFF3333, 1.0f);
    private boolean drawing;
    private int lastX;
    private int lastY;
    private boolean isChalkEnabled;

    public UIChalkboard() {
        this.texture = new Texture();
        this.texture.setFilter(9728);
        this.picker = new UIColor(c -> {
            this.color = c;
        }).withAlpha();
        this.picker.direction(Direction.TOP).withTarget(this).setColor(this.color);
        this.picker.relative(this).x(10).y(1.0f, -30).wh(60, 20);
        this.picker.setEnabled(false);
        this.add((IUIElement)this.picker);
        this.keys().register(Keys.DELETE, this::resize).active(() -> this.isChalkEnabled);
        this.keys().register(new KeyCombo("", UIKeys.PANELS_KEYS_TOGGLE_CHALKBOARD, 299), this::toggleChalk);
    }

    private void toggleChalk() {
        this.isChalkEnabled = !this.isChalkEnabled;
        this.picker.setEnabled(this.isChalkEnabled);
    }

    public boolean isChalkDisabled() {
        return !this.isChalkEnabled;
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        if (this.isChalkDisabled()) {
            return false;
        }
        if (context.mouseButton == 0) {
            this.drawing = true;
            this.lastX = context.mouseX;
            this.lastY = context.mouseY;
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    protected boolean subMouseScrolled(UIContext context) {
        if (this.isChalkDisabled()) {
            return false;
        }
        return super.subMouseScrolled(context);
    }

    @Override
    protected boolean subMouseReleased(UIContext context) {
        if (this.isChalkDisabled()) {
            return false;
        }
        if (context.mouseButton == 0) {
            this.drawing = false;
        }
        return super.subMouseReleased(context);
    }

    @Override
    public void resize() {
        super.resize();
        if (this.pixels != null) {
            this.pixels.delete();
        }
        int scale = (Integer)BBSSettings.userIntefaceScale.get();
        this.pixels = Pixels.fromSize(this.area.w * scale, this.area.h * scale);
        this.pixels.rewindBuffer();
        this.texture.bind();
        this.texture.updateTexture(this.pixels);
    }

    @Override
    public void render(UIContext context) {
        if (this.isChalkDisabled()) {
            return;
        }
        int scale = (Integer)BBSSettings.userIntefaceScale.get();
        int x = context.mouseX;
        int y = context.mouseY;
        if (this.pixels != null) {
            if (this.drawing) {
                double distance = new Vector2d((double)x, (double)y).distance((double)this.lastX, (double)this.lastY);
                int i = 0;
                while ((double)i < distance) {
                    int xx = (int)Lerps.lerp((double)(x * scale), (double)(this.lastX * scale), (double)i / distance);
                    int yy = (int)Lerps.lerp((double)(y * scale), (double)(this.lastY * scale), (double)i / distance);
                    this.pixels.drawRect(xx - 1, yy - 2, 2, 4, this.color);
                    this.pixels.drawRect(xx - 2, yy - 1, 1, 2, this.color);
                    this.pixels.drawRect(xx + 1, yy - 1, 1, 2, this.color);
                    ++i;
                }
                this.pixels.rewindBuffer();
                this.texture.bind();
                this.texture.updateTexture(this.pixels);
                this.lastX = x;
                this.lastY = y;
            }
            context.batcher.fullTexturedBox(this.texture, this.area.x, this.area.y, this.area.w, this.area.h);
        }
        context.batcher.box(x - 1, y - 1, x + 1, y + 1, this.color);
        super.render(context);
    }
}

