/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import java.util.Collection;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.ui.ContentType;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.renderers.InputRenderer;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDataUtils {
    public static void requestNames(ContentType type, Consumer<Collection<String>> consumer) {
        type.getRepository().requestKeys(consumer);
    }

    public static void renderRightClickHere(UIContext context, Area area) {
        int primary = (Integer)BBSSettings.primaryColor.get();
        double ticks = (double)context.getTickTransition() % 80.0;
        double factor = Math.abs(ticks / 80.0 * 2.0 - 1.0);
        factor = Interpolations.EXP_INOUT.interpolate(0.0, 1.0, factor);
        double factor2 = Lerps.envelope(ticks, 37.0, 40.0, 40.0, 43.0);
        factor2 = Interpolations.CUBIC_OUT.interpolate(0.0, 1.0, factor2);
        int offset = (int)(factor * 70.0 + factor2 * 2.0);
        context.batcher.dropCircleShadow(area.mx(), area.my() + (int)(factor * 70.0), 16, 0, 16, 0x88000000 | primary, primary);
        InputRenderer.renderMouseButtons(context.batcher, area.mx() - 6, area.my() - 8 + offset, 0, false, factor2 > 0.0, false, false);
        String label = UIKeys.GENERAL_RIGHT_CLICK.get();
        int w = (int)((float)area.w / 1.1f);
        int color = Colors.mulRGB(0x444444, 1.0f - (float)factor);
        context.batcher.wallText(label, area.mx() - w / 2, area.my() - 20, color, w, 12, 0.5f, 1.0f);
        context.batcher.gradientVBox(area.x, area.my() + 20, area.ex(), area.my() + 40, 0, -16777216);
        context.batcher.box(area.x, area.my() + 40, area.ex(), area.my() + 90, -16777216);
    }
}

