/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.keys;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.settings.SettingsBuilder;
import mchorse.bbs_mod.settings.value.ValueKeyCombo;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class KeybindSettings {
    private static final List<Class> classes = new ArrayList<Class>();

    public static void registerClasses() {
        classes.add(Keys.class);
    }

    public static void register(SettingsBuilder builder) {
        HashMap<String, List<KeyCombo>> combos = new HashMap<String, List<KeyCombo>>();
        for (Class clazz : classes) {
            KeybindSettings.readKeyCombos(combos, clazz);
        }
        ArrayList keys = new ArrayList(combos.keySet());
        keys.sort(Comparator.comparing(a -> a));
        for (String key : keys) {
            List comboList = (List)combos.get(key);
            builder.category(key);
            for (KeyCombo combo : comboList) {
                builder.register(new ValueKeyCombo(combo.id, combo));
            }
        }
    }

    private static void readKeyCombos(Map<String, List<KeyCombo>> combos, Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != KeyCombo.class) continue;
            try {
                KeyCombo combo = (KeyCombo)field.get(null);
                List comboList = combos.computeIfAbsent(combo.categoryKey, k -> new ArrayList());
                comboList.add(combo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

