/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.io.File;
import java.util.ArrayList;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.utils.OS;

public class FFMpegUtils {
    private static File findFFMPEG(String path) {
        File exe;
        boolean isWin;
        File file = new File(path);
        boolean bl = isWin = OS.CURRENT == OS.WINDOWS;
        if (file.isDirectory()) {
            String subpath = isWin ? "ffmpeg.exe" : "ffmpeg";
            File bin = new File(file, subpath);
            if (bin.isFile()) {
                return bin;
            }
            bin = new File(file, "bin" + File.separator + subpath);
            if (bin.isFile()) {
                return bin;
            }
        } else if (isWin && !file.exists() && (exe = new File(path + ".exe")).exists()) {
            return exe;
        }
        return file;
    }

    public static File getFFMPEG() {
        File encoder = new File((String)BBSSettings.videoEncoderPath.get());
        File encoderPath = FFMpegUtils.findFFMPEG((String)BBSSettings.videoEncoderPath.get());
        if (encoderPath.isFile()) {
            encoder = encoderPath;
        }
        return encoder;
    }

    public static boolean checkFFMPEG() {
        return FFMpegUtils.execute(BBSMod.getGameFolder(), "-version");
    }

    public static boolean execute(File folder, String ... arguments) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(FFMpegUtils.getFFMPEG().getAbsolutePath());
        for (String arg : arguments) {
            args.add(arg);
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        File log = BBSMod.getSettingsPath("converter.log");
        builder.directory(folder);
        builder.redirectErrorStream(true);
        builder.redirectOutput(log);
        try {
            Process start = builder.start();
            return start.waitFor() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

