/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import com.ibm.icu.impl.Assert;
import mchorse.bbs_mod.utils.MatrixUtils;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class MatrixUtilsTest {
    public static void main(String[] args) {
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.YXZ, 45.0, 45.0, 45.0, 45.0, 45.0, 45.0);
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.XYZ, -45.0, 45.0, -45.0, 45.0, -45.0, -45.0);
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.XYZ, -182.0, 45.0, 45.0, 45.0, 178.0, 45.0);
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.XYZ, 45.0, 182.0, 45.0, 182.0, 45.0, 45.0);
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.XYZ, 45.0, 182.0, -45.0, 182.0, 45.0, -45.0);
        MatrixUtilsTest.testRotationOrder(MatrixUtils.RotationOrder.YXZ, MatrixUtils.RotationOrder.XYZ, 45.0, 182.0, -245.0, 182.0, 45.0, -45.0);
    }

    public static void testRotationOrder(MatrixUtils.RotationOrder order, MatrixUtils.RotationOrder orderOrigin, double angle0, double angle1, double angle2, double expectedX, double expectedY, double expectedZ) {
        Vector3d toTest = new Vector3d(expectedX, expectedY, expectedZ);
        Matrix3d rot = orderOrigin.getRotationMatrix(Math.toRadians(angle0), Math.toRadians(angle1), Math.toRadians(angle2));
        Vector3d testDirection = rot.transform(new Vector3d(0.0, 0.0, 1.0));
        Vector3d testOrientation = rot.transform(new Vector3d(0.0, 1.0, 0.0));
        Vector3d angles = order.getEulerAngles(rot);
        Matrix3d rotNew = order.getRotationMatrixFromXYZ(angles.x, angles.y, angles.z);
        Vector3d newDirection = rotNew.transform(new Vector3d(0.0, 0.0, 1.0));
        Vector3d newOrientation = rotNew.transform(new Vector3d(0.0, 1.0, 0.0));
        if (newDirection.dot((Vector3dc)testDirection) < 0.9999 || newOrientation.dot((Vector3dc)testOrientation) < 0.9999) {
            Assert.fail((String)"Direction or orientation don't match");
        }
    }

    public static void testAxisGetAngleAround() {
        Matrix3d rot = new Matrix3d();
        rot.identity().rotateY(Math.toRadians(45.0));
        double angle = Math.toDegrees(MatrixUtils.Axis.Y.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == 45L ? 1 : 0) != 0);
        rot.identity().rotateY(Math.toRadians(-125.0));
        angle = Math.toDegrees(MatrixUtils.Axis.Y.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == -125L ? 1 : 0) != 0);
        rot.identity().rotateY(Math.toRadians(281.0));
        angle = Math.toDegrees(MatrixUtils.Axis.Y.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == -79L ? 1 : 0) != 0);
        rot.identity().rotateY(Math.toRadians(-281.0));
        angle = Math.toDegrees(MatrixUtils.Axis.Y.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == 79L ? 1 : 0) != 0);
        rot.identity().rotateX(Math.toRadians(-45.0));
        angle = Math.toDegrees(MatrixUtils.Axis.X.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == -45L ? 1 : 0) != 0);
        rot.identity().rotateX(Math.toRadians(125.0));
        angle = Math.toDegrees(MatrixUtils.Axis.X.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == 125L ? 1 : 0) != 0);
        rot.identity().rotateX(Math.toRadians(181.0));
        angle = Math.toDegrees(MatrixUtils.Axis.X.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == -179L ? 1 : 0) != 0);
        rot.identity().rotateX(Math.toRadians(-181.0));
        angle = Math.toDegrees(MatrixUtils.Axis.X.getAngleAround(MatrixUtils.Axis.Z, rot));
        Assert.assrt((Math.round(angle) == 179L ? 1 : 0) != 0);
    }
}

