/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

public class NaturalOrderComparator {
    public static int compare(boolean caseInsensitive, String a, String b) {
        int indexA = 0;
        int indexB = 0;
        int lenA = a.length();
        int lenB = b.length();
        while (indexA < lenA && indexB < lenB) {
            int result;
            String chunkA = NaturalOrderComparator.getChunk(a, lenA, indexA);
            String chunkB = NaturalOrderComparator.getChunk(b, lenB, indexB);
            char charA = a.charAt(indexA);
            char charB = b.charAt(indexB);
            indexA += chunkA.length();
            indexB += chunkB.length();
            if (NaturalOrderComparator.isDigit(charA) && NaturalOrderComparator.isDigit(charB)) {
                result = NaturalOrderComparator.compareNumericChunks(caseInsensitive, chunkA, chunkB);
            } else {
                int n = result = caseInsensitive ? chunkA.compareToIgnoreCase(chunkB) : chunkA.compareTo(chunkB);
            }
            if (result == 0) continue;
            return result;
        }
        return lenA - lenB;
    }

    private static String getChunk(String s, int length, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (NaturalOrderComparator.isDigit(c)) {
            while (marker < length && NaturalOrderComparator.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < length && !NaturalOrderComparator.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static int compareNumericChunks(boolean caseInsensitive, String num1, String num2) {
        num1 = num1.replaceFirst("^0+", "");
        num2 = num2.replaceFirst("^0+", "");
        if (num1.length() != num2.length()) {
            return num1.length() - num2.length();
        }
        return caseInsensitive ? num1.compareToIgnoreCase(num2) : num1.compareTo(num2);
    }
}

