/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.iris;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.utils.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.uniforms.custom.cached.CachedUniform;

@Environment(value=EnvType.CLIENT)
public class ShaderCurves {
    public static Map<String, ShaderVariable> variableMap = new HashMap<String, ShaderVariable>();
    private static Set<String> prohibitedVariables = new HashSet<String>();
    private static Set<String> prohibitedConstIdentifiers = new HashSet<String>();
    public static final String BRIGHTNESS = "brightness";
    public static final String SUN_ROTATION = "sun_rotation";
    public static final String WEATHER = "weather";
    public static final String UNIFORM_IDENTIFIER = "bbs_";

    public static void reset() {
        variableMap.clear();
    }

    public static void finishLoading() {
    }

    public static String processSource(String source) {
        if (!((Boolean)BBSSettings.shaderCurvesEnabled.get()).booleanValue()) {
            return source;
        }
        Map<String, ShaderVariable> variables = ShaderCurves.parseVariables(source);
        if (!variables.isEmpty()) {
            ShaderCurves.removeIrrelevantVariables(source, variables);
            source = ShaderCurves.replaceMacroReferences(source, variables);
            source = ShaderCurves.removeConstFromRelevantVariables(source);
            source = ShaderCurves.insertUniforms(source, variables);
            for (ShaderVariable value : variables.values()) {
                variableMap.putIfAbsent(value.name, value);
            }
        }
        return source;
    }

    private static void removeIrrelevantVariables(String source, Map<String, ShaderVariable> variables) {
        List<String> filter = BBSRendering.getShadersSliderOptions();
        variables.values().removeIf(v -> !filter.contains(v.name));
        for (String prohibitedVariable : prohibitedVariables) {
            variables.remove(prohibitedVariable);
        }
        int index = 0;
        while ((index = source.indexOf("#", index + 1)) != -1) {
            int iindex;
            int newLine = source.indexOf(10, index);
            if (newLine < 0) continue;
            String substr = source.substring(index, newLine);
            if (substr.startsWith("#if") || substr.startsWith("#elif")) {
                variables.values().removeIf(v -> substr.contains(v.name));
                continue;
            }
            if (!substr.startsWith("#define")) continue;
            boolean WHITESPACE = false;
            boolean CHARACTERS = true;
            boolean state = false;
            int switches = 0;
            for (iindex = 7; iindex < newLine - index; ++iindex) {
                char c = substr.charAt(iindex);
                if (!state && Character.isWhitespace(c)) {
                    state = true;
                    ++switches;
                } else if (Character.isWhitespace(c)) {
                    state = false;
                }
                if (switches == 2) break;
            }
            String subsubstr = substr.substring(iindex);
            variables.values().removeIf(v -> subsubstr.contains(v.name));
        }
    }

    private static Map<String, ShaderVariable> parseVariables(String source) {
        HashMap<String, ShaderVariable> variables = new HashMap<String, ShaderVariable>();
        Pattern definePattern = Pattern.compile("^\\s*(?!//)\\s*#define +([\\w_]+) +([\\d.]+) *// *(\\[|OptionAnnotatedSource)");
        int index = 0;
        while ((index = source.indexOf("#define", index)) != -1) {
            int lastNewLine;
            String define;
            Matcher matcher;
            int newLine = source.indexOf("\n", index);
            if (newLine == -1) {
                newLine = source.length();
            }
            if ((matcher = definePattern.matcher(define = source.substring((lastNewLine = source.lastIndexOf(10, index)) != -1 ? lastNewLine : index, newLine).trim())).find()) {
                String name = matcher.group(1);
                String defaultValue = matcher.group(2);
                boolean integer = !defaultValue.contains(".");
                ShaderVariable variable = new ShaderVariable(name, defaultValue, integer);
                variables.putIfAbsent(variable.name, variable);
            }
            index = newLine;
        }
        return variables;
    }

    private static String replaceMacroReferences(String source, Map<String, ShaderVariable> variables) {
        StringBuilder out = new StringBuilder(source.length());
        int length = source.length();
        int i = 0;
        boolean macro = false;
        while (i < length) {
            char c = source.charAt(i);
            if (c == '#') {
                macro = true;
            }
            if (c == '\n') {
                macro = false;
            }
            if (ShaderCurves.isIdentifierStart(c) && !macro) {
                int j;
                int start = i;
                for (j = i + 1; j < length && ShaderCurves.isIdentifierPart(source.charAt(j)); ++j) {
                }
                String identifier = source.substring(start, j);
                Object replacement = variables.containsKey(identifier) ? UNIFORM_IDENTIFIER + identifier : identifier;
                out.append((String)replacement);
                i = j;
                continue;
            }
            out.append(c);
            ++i;
        }
        return out.toString();
    }

    private static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static String removeConstFromRelevantVariables(String source) {
        Pair<String, Set<String>> pair = ShaderCurves.removeConst(source, s -> s.contains(UNIFORM_IDENTIFIER));
        Set deconst = (Set)pair.b;
        source = (String)pair.a;
        for (String constIdentifier : prohibitedConstIdentifiers) {
            deconst.add(constIdentifier);
        }
        while (!deconst.isEmpty()) {
            Set finalDeconst = deconst;
            pair = ShaderCurves.removeConst(source, s -> {
                for (String string : finalDeconst) {
                    if (!s.contains(string)) continue;
                    return true;
                }
                return false;
            });
            source = (String)pair.a;
            deconst = (Set)pair.b;
        }
        return source;
    }

    private static Pair<String, Set<String>> removeConst(String source, Function<String, Boolean> function) {
        HashSet<String> deconst = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int lastIndex = 0;
        while ((index = source.indexOf("const ", index + 1)) != -1) {
            String substr;
            int semicolon;
            if (index < lastIndex || (semicolon = source.indexOf(59, index)) < 0 || (substr = source.substring(index, semicolon)).indexOf(123) != -1 || !function.apply(substr).booleanValue()) continue;
            builder.append(source, lastIndex, index);
            builder.append(source, index + 6, semicolon);
            int equals = substr.indexOf(61);
            String sub = substr.substring(0, equals).trim();
            equals = sub.lastIndexOf(32);
            sub = sub.substring(equals).trim();
            deconst.add(sub);
            lastIndex = semicolon;
        }
        builder.append(source, lastIndex, source.length());
        return new Pair<String, Set<String>>(builder.toString(), deconst);
    }

    private static String insertUniforms(String source, Map<String, ShaderVariable> variables) {
        int version = source.indexOf("#version");
        int nextNewLine = source.indexOf(10, version);
        StringBuilder sb = new StringBuilder();
        for (ShaderVariable variable : variables.values()) {
            sb.append(variable.toUniformDeclaration());
            sb.append('\n');
        }
        return source.substring(0, nextNewLine + 1) + String.valueOf(sb) + source.substring(nextNewLine + 1);
    }

    public static void addUniforms(List<CachedUniform> list) {
        BBSRendering.addUniforms(list, variableMap);
    }

    static {
        prohibitedVariables.add("WATER_WAVE_ITERATIONS");
        prohibitedConstIdentifiers.add("get_luminance_from_exposure");
        prohibitedConstIdentifiers.add("get_exposure_from_luminance");
    }

    @Environment(value=EnvType.CLIENT)
    public static class ShaderVariable {
        public String name = "";
        public String uniformName = "";
        public boolean integer;
        public float defaultValue;
        public Float value;

        public ShaderVariable(String name, String defaultValue, boolean integer) {
            this.name = name;
            this.uniformName = ShaderCurves.UNIFORM_IDENTIFIER + name;
            this.defaultValue = Float.parseFloat(defaultValue);
            this.integer = integer;
        }

        public String toUniformDeclaration() {
            return "uniform " + (this.integer ? "int" : "float") + " " + this.uniformName + ";";
        }

        public float getValue() {
            if (this.value == null) {
                return this.defaultValue;
            }
            float v = this.value.floatValue();
            this.value = null;
            return v;
        }
    }
}

