/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.pose;

import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.pose.Transform;

public class PoseTransform
extends Transform {
    private static PoseTransform DEFAULT = new PoseTransform();
    public float fix;
    public final Color color = new Color().set(-1);
    public float lighting;

    @Override
    public void identity() {
        super.identity();
        this.fix = 0.0f;
        this.color.set(-1);
        this.lighting = 0.0f;
    }

    @Override
    public void lerp(Transform transform, float a) {
        if (transform instanceof PoseTransform) {
            PoseTransform pose = (PoseTransform)transform;
            this.fix = Lerps.lerp(this.fix, pose.fix, a);
            this.color.r = Lerps.lerp(this.color.r, pose.color.r, a);
            this.color.g = Lerps.lerp(this.color.g, pose.color.g, a);
            this.color.b = Lerps.lerp(this.color.b, pose.color.b, a);
            this.color.a = Lerps.lerp(this.color.a, pose.color.a, a);
            this.lighting = Lerps.lerp(this.lighting, pose.lighting, a);
        }
        super.lerp(transform, a);
    }

    @Override
    public void lerp(Transform preA, Transform a, Transform b, Transform postB, IInterp interp, float x) {
        super.lerp(preA, a, b, postB, interp, x);
        if (preA instanceof PoseTransform) {
            PoseTransform preA1 = (PoseTransform)preA;
            PoseTransform a1 = (PoseTransform)a;
            PoseTransform b1 = (PoseTransform)b;
            PoseTransform postB1 = (PoseTransform)postB;
            this.fix = (float)interp.interpolate(IInterp.context.set(preA1.fix, a1.fix, b1.fix, postB1.fix, x));
            this.color.set((float)MathUtils.clamp(interp.interpolate(IInterp.context.set(preA1.color.r, a1.color.r, b1.color.r, postB1.color.r, x)), 0.0, 1.0), (float)MathUtils.clamp(interp.interpolate(IInterp.context.set(preA1.color.g, a1.color.g, b1.color.g, postB1.color.g, x)), 0.0, 1.0), (float)MathUtils.clamp(interp.interpolate(IInterp.context.set(preA1.color.b, a1.color.b, b1.color.b, postB1.color.b, x)), 0.0, 1.0), (float)MathUtils.clamp(interp.interpolate(IInterp.context.set(preA1.color.a, a1.color.a, b1.color.a, postB1.color.a, x)), 0.0, 1.0));
            this.lighting = (float)interp.interpolate(IInterp.context.set(preA1.lighting, a1.lighting, b1.lighting, postB1.lighting, x));
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof PoseTransform) {
            PoseTransform poseTransform = (PoseTransform)obj;
            result = result && this.fix == poseTransform.fix;
            result = result && this.color.equals(poseTransform.color);
            result = result && this.lighting == poseTransform.lighting;
        }
        return result;
    }

    @Override
    public Transform copy() {
        PoseTransform transform = new PoseTransform();
        transform.copy(this);
        return transform;
    }

    @Override
    public void copy(Transform transform) {
        if (transform instanceof PoseTransform) {
            PoseTransform poseTransform = (PoseTransform)transform;
            this.fix = poseTransform.fix;
            this.color.copy(poseTransform.color);
            this.lighting = poseTransform.lighting;
        }
        super.copy(transform);
    }

    @Override
    public void toData(MapType data) {
        super.toData(data);
        data.putFloat("fix", this.fix);
        data.putInt("color", this.color.getARGBColor());
        data.putFloat("lighting", this.lighting);
    }

    @Override
    public void fromData(MapType data) {
        super.fromData(data);
        this.fix = data.getFloat("fix");
        this.color.set(data.getInt("color", -1));
        this.lighting = data.getFloat("lighting");
    }

    @Override
    public boolean isDefault() {
        return this.equals(DEFAULT);
    }
}

