/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mchorse.bbs_mod.forms.entities.IEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_6089;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class DynamicLightManager {
    private static final DynamicLightManager INSTANCE = new DynamicLightManager();
    private final Map<Integer, LightSourceData> activeLights = new ConcurrentHashMap<Integer, LightSourceData>();
    private final Map<class_2338, class_2680> originalStates = new ConcurrentHashMap<class_2338, class_2680>();
    private final Set<Integer> updatedThisFrame = new HashSet<Integer>();
    private boolean enabled = true;
    private int entityIdCounter = 0;

    public static DynamicLightManager getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled && this.enabled) {
            this.clearAllLights();
        }
        this.enabled = enabled;
    }

    public void beginFrame() {
        this.updatedThisFrame.clear();
    }

    public void endFrame() {
        if (!this.enabled) {
            return;
        }
        Iterator<Map.Entry<Integer, LightSourceData>> iter = this.activeLights.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, LightSourceData> entry = iter.next();
            if (this.updatedThisFrame.contains(entry.getKey())) continue;
            this.removeLightBlock(entry.getValue().currentPos);
            iter.remove();
        }
    }

    public void updateEntityLight(int entityId, IEntity entity, double x, double y, double z) {
        if (!this.enabled) {
            return;
        }
        int lightLevel = this.getEntityLightLevel(entity);
        this.updatedThisFrame.add(entityId);
        if (lightLevel <= 0) {
            LightSourceData existing = this.activeLights.remove(entityId);
            if (existing != null) {
                this.removeLightBlock(existing.currentPos);
            }
            return;
        }
        class_2338 newPos = class_2338.method_49637((double)x, (double)(y + 0.5), (double)z);
        LightSourceData existing = this.activeLights.get(entityId);
        if (existing != null) {
            if (!existing.currentPos.equals((Object)newPos) || existing.lightLevel != lightLevel) {
                this.removeLightBlock(existing.currentPos);
                this.placeLightBlock(newPos, lightLevel);
                existing.currentPos = newPos;
                existing.lightLevel = lightLevel;
            }
        } else {
            this.placeLightBlock(newPos, lightLevel);
            this.activeLights.put(entityId, new LightSourceData(newPos, lightLevel));
        }
    }

    public int generateEntityId() {
        return --this.entityIdCounter;
    }

    public void clearAllLights() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        for (Map.Entry<class_2338, class_2680> entry : this.originalStates.entrySet()) {
            class_2338 pos = entry.getKey();
            class_2680 original = entry.getValue();
            class_2680 current = world.method_8320(pos);
            if (current.method_26204() != class_2246.field_31037) continue;
            world.method_8652(pos, original, 19);
        }
        this.activeLights.clear();
        this.originalStates.clear();
        this.updatedThisFrame.clear();
    }

    private void placeLightBlock(class_2338 pos, int lightLevel) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2680 currentState = world.method_8320(pos);
        if (currentState.method_26225() || currentState.method_26204() == class_2246.field_10382) {
            return;
        }
        if (!this.originalStates.containsKey(pos)) {
            this.originalStates.put(pos.method_10062(), currentState);
        }
        int level = Math.max(1, Math.min(15, lightLevel));
        class_2680 lightState = (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(level));
        world.method_8652(pos, lightState, 19);
    }

    private void removeLightBlock(class_2338 pos) {
        class_2680 current;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2680 original = this.originalStates.remove(pos);
        if (original != null && (current = world.method_8320(pos)).method_26204() == class_2246.field_31037) {
            world.method_8652(pos, original, 19);
        }
    }

    public int getEntityLightLevel(IEntity entity) {
        class_1799 offHand;
        int maxLight = 0;
        class_1799 mainHand = entity.getEquipmentStack(class_1304.field_6173);
        if (mainHand != null && !mainHand.method_7960()) {
            maxLight = Math.max(maxLight, DynamicLightManager.getItemLuminance(mainHand));
        }
        if ((offHand = entity.getEquipmentStack(class_1304.field_6171)) != null && !offHand.method_7960()) {
            maxLight = Math.max(maxLight, DynamicLightManager.getItemLuminance(offHand));
        }
        return maxLight;
    }

    public static int getItemLuminance(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            return block.method_9564().method_26213();
        }
        return 0;
    }

    @Deprecated
    public void updateEntityLight(IEntity entity, double x, double y, double z) {
        int id = System.identityHashCode(entity);
        this.updateEntityLight(id, entity, x, y, z);
    }

    public void cleanup() {
    }

    public int getDynamicLightAt(class_2338 pos) {
        return 0;
    }

    public int applyDynamicLight(int originalLight, class_2338 pos) {
        return originalLight;
    }

    @Environment(value=EnvType.CLIENT)
    private static class LightSourceData {
        class_2338 currentPos;
        int lightLevel;

        LightSourceData(class_2338 pos, int lightLevel) {
            this.currentPos = pos;
            this.lightLevel = lightLevel;
        }
    }
}

