/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.actions.ActionState;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.entity.GunProjectileEntity;
import mchorse.bbs_mod.entity.IEntityFormProvider;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.Films;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.payloads.BBSPayloads;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIScreen;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockPanel;
import mchorse.bbs_mod.ui.morphing.UIMorphingPanel;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.repos.RepositoryOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ClientNetwork {
    private static int ids = 0;
    private static Map<Integer, Consumer<BaseType>> callbacks = new HashMap<Integer, Consumer<BaseType>>();
    private static boolean isBBSModOnServer;

    public static void resetHandshake() {
        isBBSModOnServer = false;
    }

    public static boolean isIsBBSModOnServer() {
        return isBBSModOnServer;
    }

    public static void setup() {
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.ClickedModelBlockPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleClientModelBlockPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.PlayerFormPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handlePlayerFormPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.PlayFilmPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handlePlayFilmPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.ManagerDataPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleManagerDataPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.StopFilmPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleStopFilmPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.HandshakePayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleHandshakePacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.RecordedActionsPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleRecordedActionsPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.AnimationStateTriggerPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleFormTriggerPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.CheatsPermissionPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleCheatsPermissionPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.SharedFormPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleShareFormPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.EntityFormPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleEntityFormPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.ActorsPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleActorsPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.GunPropertiesPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleGunPropertiesPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.PauseFilmPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handlePauseFilmPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.SelectedSlotPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleSelectedSlotPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.ModelBlockStateTriggerPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleAnimationStateModelBlockPacket(context.client(), payload)));
        ClientPlayNetworking.registerGlobalReceiver(BBSPayloads.RefreshModelBlocksPayload.ID, (payload, context) -> context.client().execute(() -> ClientNetwork.handleRefreshModelBlocksPacket(context.client(), payload)));
    }

    private static void handleClientModelBlockPacket(class_310 client, BBSPayloads.ClickedModelBlockPayload payload) {
        UIDashboard dashboard;
        class_2338 pos = payload.pos();
        class_2586 entity = client.field_1687.method_8321(pos);
        if (!(entity instanceof ModelBlockEntity)) {
            return;
        }
        UIBaseMenu menu = UIScreen.getCurrentMenu();
        if (menu != (dashboard = BBSModClient.getDashboard())) {
            UIScreen.open(dashboard);
        }
        UIModelBlockPanel panel = dashboard.getPanels().getPanel(UIModelBlockPanel.class);
        dashboard.setPanel(panel);
        panel.fill((ModelBlockEntity)entity, true);
    }

    private static void handlePlayerFormPacket(class_310 client, BBSPayloads.PlayerFormPayload payload) {
        int id = payload.playerId();
        Form form = FormUtils.fromData(DataStorageUtils.readFromBytes(payload.formData()));
        class_1297 entity = client.field_1687.method_8469(id);
        Morph morph = Morph.getMorph(entity);
        if (morph != null) {
            morph.setForm(form);
        }
    }

    private static void handlePlayFilmPacket(class_310 client, BBSPayloads.PlayFilmPayload payload) {
        String filmId = payload.filmId();
        boolean withCamera = payload.withCamera();
        Film film = new Film();
        film.setId(filmId);
        film.fromData(DataStorageUtils.readFromBytes(payload.filmData()));
        Films.playFilm(film, withCamera);
    }

    private static void handleManagerDataPacket(class_310 client, BBSPayloads.ManagerDataPayload payload) {
        int callbackId = payload.callbackId();
        RepositoryOperation op = RepositoryOperation.values()[payload.operation()];
        BaseType data = DataStorageUtils.readFromBytes(payload.data());
        Consumer<BaseType> callback = callbacks.remove(callbackId);
        if (callback != null) {
            callback.accept(data);
        }
    }

    private static void handleStopFilmPacket(class_310 client, BBSPayloads.StopFilmPayload payload) {
        Films.stopFilm(payload.filmId());
    }

    private static void handleHandshakePacket(class_310 client, BBSPayloads.HandshakePayload payload) {
        isBBSModOnServer = true;
    }

    private static void handleRecordedActionsPacket(class_310 client, BBSPayloads.RecordedActionsPayload payload) {
        String filmId = payload.filmId();
        int replayId = payload.replayId();
        int tick = payload.tick();
        BaseType data = DataStorageUtils.readFromBytes(payload.clipsData());
        BBSModClient.getDashboard().getPanels().getPanel(UIFilmPanel.class).receiveActions(filmId, replayId, tick, data);
    }

    private static void handleFormTriggerPacket(class_310 client, BBSPayloads.AnimationStateTriggerPayload payload) {
        int id = payload.entityId();
        String triggerId = payload.trigger();
        int type = payload.type();
        class_1297 entity = client.field_1687.method_8469(id);
        Morph morph = Morph.getMorph(entity);
        if (morph != null && morph.getForm() != null) {
            morph.getForm().playState(triggerId);
        }
        if (entity instanceof class_1309) {
            class_1799 stackInHand;
            ModelProperties properties;
            class_1309 livingEntity = (class_1309)entity;
            if (type > 0 && (properties = BBSModClient.getItemStackProperties(stackInHand = livingEntity.method_5998(type == 1 ? class_1268.field_5808 : class_1268.field_5810))) != null && properties.getForm() != null) {
                properties.getForm().playState(triggerId);
            }
        }
    }

    private static void handleCheatsPermissionPacket(class_310 client, BBSPayloads.CheatsPermissionPayload payload) {
        client.field_1724.method_3147(payload.allowed() ? 4 : 0);
    }

    private static void handleShareFormPacket(class_310 client, BBSPayloads.SharedFormPayload payload) {
        Form form = FormUtils.fromData(DataStorageUtils.readFromBytes(payload.formData()));
        if (form == null) {
            return;
        }
        UIBaseMenu menu = UIScreen.getCurrentMenu();
        UIDashboard dashboard = BBSModClient.getDashboard();
        if (menu == null) {
            UIScreen.open(dashboard);
        }
        dashboard.setPanel(dashboard.getPanel(UIMorphingPanel.class));
        BBSModClient.getFormCategories().getRecentForms().getCategories().get(0).addForm(form);
        dashboard.context.notifyInfo(UIKeys.FORMS_SHARED_NOTIFICATION.format(form.getDisplayName()));
    }

    private static void handleEntityFormPacket(class_310 client, BBSPayloads.EntityFormPayload payload) {
        Form form = FormUtils.fromData(DataStorageUtils.readFromBytes(payload.formData()));
        if (form == null) {
            return;
        }
        int entityId = payload.entityId();
        class_1297 entity = client.field_1687.method_8469(entityId);
        if (entity instanceof IEntityFormProvider) {
            IEntityFormProvider provider = (IEntityFormProvider)entity;
            provider.setForm(form);
        }
    }

    private static void handleActorsPacket(class_310 client, BBSPayloads.ActorsPayload payload) {
        HashMap<String, Integer> actors = new HashMap<String, Integer>();
        String filmId = payload.filmId();
        String[] keys = payload.actorKeys();
        int[] entityIds = payload.entityIds();
        for (int i = 0; i < keys.length; ++i) {
            actors.put(keys[i], entityIds[i]);
        }
        UIDashboard dashboard = BBSModClient.getDashboard();
        UIFilmPanel panel = dashboard.getPanel(UIFilmPanel.class);
        panel.updateActors(filmId, actors);
        BBSModClient.getFilms().updateActors(filmId, actors);
    }

    private static void handleGunPropertiesPacket(class_310 client, BBSPayloads.GunPropertiesPayload payload) {
        GunProperties properties = new GunProperties();
        int entityId = payload.entityId();
        properties.fromData((MapType)DataStorageUtils.readFromBytes(payload.propertiesData()));
        class_1297 entity = client.field_1687.method_8469(entityId);
        if (entity instanceof GunProjectileEntity) {
            GunProjectileEntity projectile = (GunProjectileEntity)entity;
            projectile.setProperties(properties);
            projectile.method_18382();
        }
    }

    private static void handlePauseFilmPacket(class_310 client, BBSPayloads.PauseFilmPayload payload) {
        Films.togglePauseFilm(payload.filmId());
    }

    private static void handleSelectedSlotPacket(class_310 client, BBSPayloads.SelectedSlotPayload payload) {
        client.field_1724.method_31548().field_7545 = payload.slot();
    }

    private static void handleAnimationStateModelBlockPacket(class_310 client, BBSPayloads.ModelBlockStateTriggerPayload payload) {
        ModelBlockEntity block;
        class_2338 pos = payload.pos();
        String state = payload.trigger();
        class_2586 blockEntity = client.field_1687.method_8321(pos);
        if (blockEntity instanceof ModelBlockEntity && (block = (ModelBlockEntity)blockEntity).getProperties().getForm() != null) {
            block.getProperties().getForm().playState(state);
        }
    }

    private static void handleRefreshModelBlocksPacket(class_310 client, BBSPayloads.RefreshModelBlocksPayload payload) {
        int range = payload.tickRandom();
        for (ModelBlockEntity mb : BBSRendering.capturedModelBlocks) {
            ModelProperties properties = mb.getProperties();
            properties.setForm(FormUtils.copy(properties.getForm()));
            for (int random = (int)(Math.random() * (double)range); random > 0; --random) {
                properties.update(mb.getEntity());
            }
        }
    }

    public static void sendModelBlockForm(class_2338 pos, ModelBlockEntity modelBlock) {
        byte[] formData = DataStorageUtils.writeToBytes(modelBlock.getProperties().toData());
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ModelBlockFormRequestPayload(pos, formData));
    }

    public static void sendPlayerForm(Form form) {
        MapType mapType = FormUtils.toData(form);
        byte[] formData = DataStorageUtils.writeToBytes(mapType == null ? new MapType() : mapType);
        ClientPlayNetworking.send((class_8710)new BBSPayloads.PlayerFormRequestPayload(formData));
    }

    public static void sendModelBlockTransforms(MapType data) {
        byte[] transformsData = DataStorageUtils.writeToBytes(data);
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ModelBlockTransformsRequestPayload(transformsData));
    }

    public static void sendManagerDataLoad(String id, Consumer<BaseType> consumer) {
        MapType mapType = new MapType();
        mapType.putString("id", id);
        ClientNetwork.sendManagerData(RepositoryOperation.LOAD, mapType, consumer);
    }

    public static void sendManagerData(RepositoryOperation op, BaseType data, Consumer<BaseType> consumer) {
        int id = ids++;
        callbacks.put(id, consumer);
        ClientNetwork.sendManagerData(id, op, data);
    }

    public static void sendManagerData(int callbackId, RepositoryOperation op, BaseType data) {
        byte[] dataBytes = DataStorageUtils.writeToBytes(data);
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ManagerDataRequestPayload(callbackId, op.ordinal(), dataBytes));
    }

    public static void sendActionRecording(String filmId, int replayId, int tick, int countdown, boolean state) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ActionRecordingPayload(filmId, replayId, tick, countdown, state));
    }

    public static void sendToggleFilm(String filmId, boolean withCamera) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ToggleFilmPayload(filmId, withCamera));
    }

    public static void sendActionState(String filmId, ActionState state, int tick) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ActionControlPayload(filmId, (byte)state.ordinal(), tick));
    }

    public static void sendSyncData(String filmId, BaseValue data) {
        DataPath path = data.getPath();
        String[] pathArray = path.strings.toArray(new String[0]);
        byte[] dataBytes = DataStorageUtils.writeToBytes(data.toData());
        ClientPlayNetworking.send((class_8710)new BBSPayloads.FilmDataSyncPayload(filmId, pathArray, dataBytes));
    }

    public static void sendTeleport(class_1657 entity, double x, double y, double z) {
        ClientNetwork.sendTeleport(x, y, z, entity.method_5791(), entity.method_5791(), entity.method_36455());
    }

    public static void sendTeleport(double x, double y, double z, float yaw, float bodyYaw, float pitch) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.PlayerTeleportPayload(x, y, z, yaw, bodyYaw, pitch));
    }

    public static void sendFormTrigger(String triggerId, int type) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.AnimationStateTriggerRequestPayload(triggerId, type));
    }

    public static void sendSharedForm(Form form, UUID uuid) {
        MapType mapType = FormUtils.toData(form);
        byte[] formData = DataStorageUtils.writeToBytes(mapType == null ? new MapType() : mapType);
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ShareFormPayload(uuid, formData));
    }

    public static void sendZoom(boolean zoom) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.ZoomPayload(zoom));
    }

    public static void sendPauseFilm(String filmId) {
        ClientPlayNetworking.send((class_8710)new BBSPayloads.PauseFilmRequestPayload(filmId));
    }
}

