/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.expiration;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.particles.components.IComponentParticleInitialize;
import mchorse.bbs_mod.particles.components.IComponentParticleUpdate;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ParticleComponentParticleLifetime
extends ParticleComponentBase
implements IComponentParticleInitialize,
IComponentParticleUpdate {
    public MolangExpression expression = MolangParser.ZERO;
    public boolean max;

    @Override
    protected void toData(MapType data) {
        data.put(this.max ? "max_lifetime" : "expiration_expression", this.expression.toData());
    }

    @Override
    public ParticleComponentBase fromData(BaseType elem, MolangParser parser) throws MolangException {
        if (!elem.isMap()) {
            return super.fromData(elem, parser);
        }
        MapType element = elem.asMap();
        BaseType expression = null;
        if (element.has("expiration_expression")) {
            expression = element.get("expiration_expression");
            this.max = false;
        } else if (element.has("max_lifetime")) {
            expression = element.get("max_lifetime");
            this.max = true;
        } else {
            throw new RuntimeException("No expiration_expression or max_lifetime was found in particle_lifetime_expression component");
        }
        this.expression = parser.parseDataSilently(expression, MolangParser.ONE);
        return super.fromData(element, parser);
    }

    @Override
    public void update(ParticleEmitter emitter, Particle particle) {
        if (!this.max && this.expression.get() != 0.0) {
            particle.setDead();
        }
    }

    @Override
    public void apply(ParticleEmitter emitter, Particle particle) {
        particle.lifetime = this.max ? (int)(this.expression.get() * 20.0) : -1;
    }
}

