/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import mchorse.bbs_mod.camera.clips.modifiers.TrackerClip;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.modules.UIPointModule;
import mchorse.bbs_mod.ui.film.clips.widgets.UIBitToggle;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIAnchorKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UITrackerClip
extends UIClip<TrackerClip> {
    public UIButton selector;
    public UIButton group;
    public UIPointModule point;
    public UIPointModule angle;
    public UITrackpad fov;
    public UIToggle lookAt;
    public UIToggle relative;
    public UIBitToggle active;

    public UITrackerClip(TrackerClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    public void registerUI() {
        super.registerUI();
        this.selector = new UIButton(UIKeys.CAMERA_PANELS_TARGET_TITLE, b -> {
            UIFilmPanel panel = this.getParent(UIFilmPanel.class);
            if (panel != null) {
                UIAnchorKeyframeFactory.displayActors(this.getContext(), panel.getController().getEntities(), (Integer)((TrackerClip)this.clip).selector.get(), i -> ((TrackerClip)this.clip).selector.set(i));
            }
        });
        this.selector.tooltip(UIKeys.CAMERA_PANELS_TARGET_TOOLTIP);
        this.group = new UIButton(UIKeys.GENERIC_KEYFRAMES_ANCHOR_PICK_ATTACHMENT, b -> UIAnchorKeyframeFactory.displayAttachments(this.getParent(UIFilmPanel.class), (Integer)((TrackerClip)this.clip).selector.get(), (String)((TrackerClip)this.clip).group.get(), attachment -> ((TrackerClip)this.clip).group.set(attachment)));
        this.point = new UIPointModule(this.editor, UIKeys.CAMERA_PANELS_OFFSET).contextMenu();
        this.angle = new UIPointModule(this.editor, UIKeys.CAMERA_PANELS_ANGLE).contextMenu();
        this.fov = new UITrackpad(v -> ((TrackerClip)this.clip).fov.set(Float.valueOf(v.floatValue())));
        this.fov.tooltip(UIKeys.CAMERA_PANELS_FOV);
        this.lookAt = new UIToggle(UIKeys.CAMERA_PANELS_LOOK_AT, b -> ((TrackerClip)this.clip).lookAt.set(b.getValue()));
        this.relative = new UIToggle(UIKeys.CAMERA_PANELS_RELATIVE, b -> ((TrackerClip)this.clip).relative.set(b.getValue()));
        this.active = new UIBitToggle(value -> ((TrackerClip)this.clip).active.set(value)).all();
    }

    private UIFilmPanel getPanel() {
        return this.getContext().menu.getRoot().getChildren(UIFilmPanel.class).get(0);
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_TARGET), this.selector, this.group).marginTop(12));
        this.panels.add((IUIElement)this.point.marginTop(6));
        this.panels.add((IUIElement)this.angle.marginTop(6));
        this.panels.add((IUIElement)this.fov);
        this.panels.add((IUIElement)this.lookAt);
        this.panels.add((IUIElement)this.relative);
        this.panels.add((IUIElement)this.active);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.point.fill(((TrackerClip)this.clip).offset);
        this.angle.fill(((TrackerClip)this.clip).angle);
        this.fov.setValue(((Float)((TrackerClip)this.clip).fov.get()).floatValue());
        this.lookAt.setValue((Boolean)((TrackerClip)this.clip).lookAt.get());
        this.relative.setValue((Boolean)((TrackerClip)this.clip).relative.get());
        this.active.setValue((Integer)((TrackerClip)this.clip).active.get());
    }
}

