/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.IKeyframeShapeRenderer;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class StarsKeyframeShapeRenderer
implements IKeyframeShapeRenderer {
    private final int numBranches;
    private final Icon icon;
    private final IKey label;

    public StarsKeyframeShapeRenderer(int numBranches, Icon icon, IKey label) {
        this.numBranches = numBranches;
        this.icon = icon;
        this.label = label;
    }

    @Override
    public IKey getLabel() {
        return this.label;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void renderKeyframe(UIContext uiContext, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        float fOffset = (float)offset * 2.0f;
        float baseWidth = fOffset * 0.5f;
        float tipWidth = fOffset * 0.16f;
        for (int i = 0; i < this.numBranches; ++i) {
            float angle = -90.0f + 360.0f / (float)this.numBranches * (float)i;
            float angle1 = (float)Math.toRadians(angle);
            float cos = (float)Math.cos(angle1);
            float sin = (float)Math.sin(angle1);
            float baseLeft_x = (float)x + 0.0f * cos - baseWidth * sin;
            float baseLeft_y = (float)y + 0.0f * sin + baseWidth * cos;
            float baseRight_x = (float)x + 0.0f * cos + baseWidth * sin;
            float baseRight_y = (float)y + 0.0f * sin - baseWidth * cos;
            float tipLeft_x = (float)x + fOffset * cos - tipWidth * sin;
            float tipLeft_y = (float)y + fOffset * sin + tipWidth * cos;
            float tipRight_x = (float)x + fOffset * cos + tipWidth * sin;
            float tipRight_y = (float)y + fOffset * sin - tipWidth * cos;
            builder.method_22918(matrix, baseLeft_x, baseLeft_y, 0.0f).method_39415(c);
            builder.method_22918(matrix, tipLeft_x, tipLeft_y, 0.0f).method_39415(c);
            builder.method_22918(matrix, tipRight_x, tipRight_y, 0.0f).method_39415(c);
            builder.method_22918(matrix, baseRight_x, baseRight_y, 0.0f).method_39415(c);
        }
    }

    @Override
    public void renderKeyframeBackground(UIContext uiContext, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        float centerSize = (float)offset * 0.2f;
        float half = centerSize * 1.25f;
        builder.method_22918(matrix, (float)x - half, (float)y - half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x - half, (float)y + half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x + half, (float)y + half, 0.0f).method_39415(c);
        builder.method_22918(matrix, (float)x + half, (float)y - half, 0.0f).method_39415(c);
    }
}

