/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.interps;

import java.util.LinkedHashMap;
import java.util.Map;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.InterpContext;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.interps.easings.Easings;
import mchorse.bbs_mod.utils.interps.types.BaseInterp;
import mchorse.bbs_mod.utils.interps.types.EasingInterp;

public class Interpolations {
    public static final Map<String, IInterp> MAP = new LinkedHashMap<String, IInterp>();
    public static final IInterp LINEAR = new EasingInterp("linear", 76, Easings.LINEAR);
    public static final IInterp CONST = new EasingInterp("constant", 84, Easings.CONST);
    public static final IInterp STEP = new BaseInterp("step", 80){

        @Override
        public double interpolate(InterpContext context) {
            double steps = Math.floor(Math.max(1.0, context.args.v1));
            if (steps <= 1.0) {
                return context.a;
            }
            double x = context.x;
            double easing = MathUtils.clamp(context.args.v2, -1.0, 1.0);
            double function = context.args.v3;
            if (easing > 0.0) {
                x = Lerps.lerp(x, Easings.EXP.calculate(null, x), easing);
            }
            if (easing < 0.0) {
                x = Lerps.lerp(x, 1.0 - Easings.EXP.calculate(null, 1.0 - x), -easing);
            }
            x = function > 0.0 ? Math.ceil(x * steps) / steps : (function < 0.0 ? (double)Math.round(x * steps) / steps : Math.floor(x * steps) / steps);
            return Lerps.lerp(context.a, context.b, x);
        }
    };
    public static final IInterp SINE_IN = new EasingInterp("sine_in", 73, Easings.SINE);
    public static final IInterp SINE_OUT = new EasingInterp("sine_out", 73, Easings.out(Easings.SINE));
    public static final IInterp SINE_INOUT = new EasingInterp("sine_inout", 73, Easings.inOut(Easings.SINE));
    public static final IInterp CIRCLE_IN = new EasingInterp("circle_in", 82, Easings.CIRCLE);
    public static final IInterp CIRCLE_OUT = new EasingInterp("circle_out", 82, Easings.out(Easings.CIRCLE));
    public static final IInterp CIRCLE_INOUT = new EasingInterp("circle_inout", 82, Easings.inOut(Easings.CIRCLE));
    public static final IInterp QUAD_IN = new EasingInterp("quad_in", 81, Easings.QUADRATIC);
    public static final IInterp QUAD_OUT = new EasingInterp("quad_out", 81, Easings.out(Easings.QUADRATIC));
    public static final IInterp QUAD_INOUT = new EasingInterp("quad_inout", 81, Easings.inOut(Easings.QUADRATIC));
    public static final IInterp CUBIC_IN = new EasingInterp("cubic_in", 67, Easings.CUBIC);
    public static final IInterp CUBIC_OUT = new EasingInterp("cubic_out", 67, Easings.out(Easings.CUBIC));
    public static final IInterp CUBIC_INOUT = new EasingInterp("cubic_inout", 67, Easings.inOut(Easings.CUBIC));
    public static final IInterp QUART_IN = new EasingInterp("quart_in", 85, Easings.QUARTIC);
    public static final IInterp QUART_OUT = new EasingInterp("quart_out", 85, Easings.out(Easings.QUARTIC));
    public static final IInterp QUART_INOUT = new EasingInterp("quart_inout", 85, Easings.inOut(Easings.QUARTIC));
    public static final IInterp QUINT_IN = new EasingInterp("quint_in", 78, Easings.QUINTIC);
    public static final IInterp QUINT_OUT = new EasingInterp("quint_out", 78, Easings.out(Easings.QUINTIC));
    public static final IInterp QUINT_INOUT = new EasingInterp("quint_inout", 78, Easings.inOut(Easings.QUINTIC));
    public static final IInterp EXP_IN = new EasingInterp("exp_in", 69, Easings.EXP);
    public static final IInterp EXP_OUT = new EasingInterp("exp_out", 69, Easings.out(Easings.EXP));
    public static final IInterp EXP_INOUT = new EasingInterp("exp_inout", 69, Easings.inOut(Easings.EXP));
    public static final IInterp BACK_IN = new EasingInterp("back_in", 66, Easings.BACK);
    public static final IInterp BACK_OUT = new EasingInterp("back_out", 66, Easings.out(Easings.BACK));
    public static final IInterp BACK_INOUT = new EasingInterp("back_inout", 66, Easings.inOut(Easings.BACK));
    public static final IInterp ELASTIC_IN = new EasingInterp("elastic_in", 83, Easings.ELASTIC);
    public static final IInterp ELASTIC_OUT = new EasingInterp("elastic_out", 83, Easings.out(Easings.ELASTIC));
    public static final IInterp ELASTIC_INOUT = new EasingInterp("elastic_inout", 83, Easings.inOut(Easings.ELASTIC));
    public static final IInterp BOUNCE_IN = new EasingInterp("bounce_in", 79, Easings.BOUNCE);
    public static final IInterp BOUNCE_OUT = new EasingInterp("bounce_out", 79, Easings.out(Easings.BOUNCE));
    public static final IInterp BOUNCE_INOUT = new EasingInterp("bounce_inout", 79, Easings.inOut(Easings.BOUNCE));
    public static final IInterp CUBIC = new BaseInterp("cubic", 75){

        @Override
        public double interpolate(InterpContext context) {
            return Lerps.cubic(context.a0 + context.args.v1, context.a, context.b, context.b0 + context.args.v2, context.x);
        }
    };
    public static final IInterp HERMITE = new BaseInterp("hermite", 72){

        @Override
        public double interpolate(InterpContext context) {
            return Lerps.cubicHermite(context.a0, context.a, context.b, context.b0, context.x);
        }
    };
    public static final IInterp BEZIER = new BaseInterp("bezier", 90){

        @Override
        public double interpolate(InterpContext context) {
            return Lerps.cubicHermite(context.a0, context.a, context.b, context.b0, context.x);
        }
    };

    public static IInterp get(String name) {
        return MAP.getOrDefault(name, LINEAR);
    }

    static {
        MAP.put(LINEAR.getKey(), LINEAR);
        MAP.put(CONST.getKey(), CONST);
        MAP.put(STEP.getKey(), STEP);
        MAP.put(SINE_IN.getKey(), SINE_IN);
        MAP.put(SINE_OUT.getKey(), SINE_OUT);
        MAP.put(SINE_INOUT.getKey(), SINE_INOUT);
        MAP.put(CIRCLE_IN.getKey(), CIRCLE_IN);
        MAP.put(CIRCLE_OUT.getKey(), CIRCLE_OUT);
        MAP.put(CIRCLE_INOUT.getKey(), CIRCLE_INOUT);
        MAP.put(QUAD_IN.getKey(), QUAD_IN);
        MAP.put(QUAD_OUT.getKey(), QUAD_OUT);
        MAP.put(QUAD_INOUT.getKey(), QUAD_INOUT);
        MAP.put(CUBIC_IN.getKey(), CUBIC_IN);
        MAP.put(CUBIC_OUT.getKey(), CUBIC_OUT);
        MAP.put(CUBIC_INOUT.getKey(), CUBIC_INOUT);
        MAP.put(QUART_IN.getKey(), QUART_IN);
        MAP.put(QUART_OUT.getKey(), QUART_OUT);
        MAP.put(QUART_INOUT.getKey(), QUART_INOUT);
        MAP.put(QUINT_IN.getKey(), QUINT_IN);
        MAP.put(QUINT_OUT.getKey(), QUINT_OUT);
        MAP.put(QUINT_INOUT.getKey(), QUINT_INOUT);
        MAP.put(EXP_IN.getKey(), EXP_IN);
        MAP.put(EXP_OUT.getKey(), EXP_OUT);
        MAP.put(EXP_INOUT.getKey(), EXP_INOUT);
        MAP.put(BACK_IN.getKey(), BACK_IN);
        MAP.put(BACK_OUT.getKey(), BACK_OUT);
        MAP.put(BACK_INOUT.getKey(), BACK_INOUT);
        MAP.put(ELASTIC_IN.getKey(), ELASTIC_IN);
        MAP.put(ELASTIC_OUT.getKey(), ELASTIC_OUT);
        MAP.put(ELASTIC_INOUT.getKey(), ELASTIC_INOUT);
        MAP.put(BOUNCE_IN.getKey(), BOUNCE_IN);
        MAP.put(BOUNCE_OUT.getKey(), BOUNCE_OUT);
        MAP.put(BOUNCE_INOUT.getKey(), BOUNCE_INOUT);
        MAP.put(CUBIC.getKey(), CUBIC);
        MAP.put(HERMITE.getKey(), HERMITE);
        MAP.put(BEZIER.getKey(), BEZIER);
    }
}

