/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.bobj;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.bobj.BOBJAction;
import mchorse.bbs_mod.bobj.BOBJArmature;
import mchorse.bbs_mod.bobj.BOBJBone;
import mchorse.bbs_mod.bobj.BOBJChannel;
import mchorse.bbs_mod.bobj.BOBJGroup;
import mchorse.bbs_mod.bobj.BOBJKeyframe;
import mchorse.bbs_mod.utils.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector3f;

public class BOBJLoader {
    public static void merge(BOBJData to, BOBJData from) {
        int vertSize = to.vertices.size();
        int normSize = to.normals.size();
        int textSize = to.textures.size();
        to.vertices.addAll(from.vertices);
        to.normals.addAll(from.normals);
        to.textures.addAll(from.textures);
        to.armatures.putAll(from.armatures);
        for (BOBJMesh mesh : from.meshes) {
            BOBJMesh newMesh = mesh.add(vertSize, normSize, textSize);
            newMesh.armature = to.armatures.get(newMesh.armatureName);
            to.meshes.add(newMesh);
        }
    }

    public static BOBJData readData(InputStream stream) throws Exception {
        List<String> lines = IOUtils.readLines(stream);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Vector2d> textures = new ArrayList<Vector2d>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        ArrayList<BOBJMesh> objects = new ArrayList<BOBJMesh>();
        HashMap<String, BOBJAction> actions = new HashMap<String, BOBJAction>();
        HashMap<String, BOBJArmature> armatures = new HashMap<String, BOBJArmature>();
        BOBJMesh mesh = null;
        BOBJAction action = null;
        BOBJGroup group = null;
        BOBJChannel channel = null;
        BOBJArmature armature = null;
        BOBJBone bone = null;
        Vertex vertex = null;
        int i = 0;
        for (String line : lines) {
            String[] tokens = line.split("\\s");
            String first = tokens[0];
            if (first.equals("o")) {
                mesh = new BOBJMesh(tokens[1]);
                objects.add(mesh);
                armature = null;
                vertex = null;
                continue;
            }
            if (first.equals("o_arm")) {
                mesh.armatureName = tokens[1];
                continue;
            }
            if (first.equals("v")) {
                if (vertex != null) {
                    vertex.eliminateTinyWeights();
                }
                vertex = new Vertex(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]));
                vertices.add(vertex);
                continue;
            }
            if (first.equals("vw")) {
                float weight = Float.parseFloat(tokens[2]);
                if (weight == 0.0f) continue;
                vertex.weights.add(new Weight(tokens[1], weight));
                continue;
            }
            if (first.equals("vt")) {
                textures.add(new Vector2d(Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])));
                continue;
            }
            if (first.equals("vn")) {
                normals.add(new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3])));
                continue;
            }
            if (first.equals("f")) {
                mesh.faces.add(new Face(tokens[1], tokens[2], tokens[3]));
                continue;
            }
            if (first.equals("arm_name")) {
                i = 0;
                bone = null;
                armature = new BOBJArmature(tokens[1]);
                armatures.put(armature.name, armature);
                continue;
            }
            if (first.equals("arm_bone")) {
                Vector3f tail = new Vector3f(Float.parseFloat(tokens[3]), Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5]));
                Matrix4f boneMat = new Matrix4f();
                float[] mat = new float[16];
                for (int j = 6; j < 22; ++j) {
                    mat[j - 6] = Float.parseFloat(tokens[j]);
                }
                boneMat.set(mat);
                boneMat.transpose();
                bone = new BOBJBone(i++, tokens[1], tokens[2], boneMat);
                armature.addBone(bone);
                continue;
            }
            if (first.equals("an")) {
                action = new BOBJAction(tokens[1]);
                actions.put(tokens[1], action);
                continue;
            }
            if (first.equals("ao")) {
                group = new BOBJGroup(tokens[1]);
                action.groups.put(tokens[1], group);
                continue;
            }
            if (first.equals("ag")) {
                channel = new BOBJChannel(tokens[1], Integer.parseInt(tokens[2]));
                group.channels.add(channel);
                continue;
            }
            if (!first.equals("kf")) continue;
            channel.keyframes.add(BOBJKeyframe.parse(tokens));
        }
        if (vertex != null) {
            vertex.eliminateTinyWeights();
        }
        return new BOBJData(vertices, textures, normals, objects, actions, armatures);
    }

    public static Map<String, CompiledData> loadMeshes(BOBJData data) {
        HashMap<String, CompiledData> meshes = new HashMap<String, CompiledData>();
        for (BOBJMesh mesh : data.meshes) {
            meshes.put(mesh.name, BOBJLoader.compileMesh(data, mesh));
        }
        return meshes;
    }

    public static CompiledData compileMesh(BOBJData data, BOBJMesh mesh) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        List<Face> facesList = mesh.faces;
        int[] boneIndicesArr = new int[facesList.size() * 3 * 4];
        float[] weightsArr = new float[facesList.size() * 3 * 4];
        float[] posArr = new float[facesList.size() * 3 * 3];
        float[] textCoordArr = new float[facesList.size() * 3 * 2];
        float[] normArr = new float[facesList.size() * 3 * 3];
        Arrays.fill(boneIndicesArr, -1);
        Arrays.fill(weightsArr, -1.0f);
        int i = 0;
        for (Face face : facesList) {
            for (IndexGroup indValue : face.idxGroups) {
                BOBJLoader.processFaceVertex(i, indValue, mesh, data, indices, posArr, textCoordArr, normArr, weightsArr, boneIndicesArr);
                ++i;
            }
        }
        Integer[] integerArray = indices.toArray(new Integer[0]);
        int[] indicesArr = ArrayUtils.toPrimitive((Integer[])integerArray);
        return new CompiledData(posArr, textCoordArr, normArr, weightsArr, boneIndicesArr, indicesArr, mesh);
    }

    public static CompiledData loadMesh(BOBJData data) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Face> facesList = new ArrayList<Face>();
        for (BOBJMesh mesh : data.meshes) {
            facesList.addAll(mesh.faces);
        }
        float[] posArr = new float[facesList.size() * 3 * 3];
        float[] textCoordArr = new float[facesList.size() * 3 * 2];
        float[] normArr = new float[facesList.size() * 3 * 3];
        int i = 0;
        for (Face face : facesList) {
            for (IndexGroup indValue : face.idxGroups) {
                BOBJLoader.processFaceVertex(i, indValue, null, data, indices, posArr, textCoordArr, normArr, null, null);
                ++i;
            }
        }
        Integer[] integerArray = indices.toArray(new Integer[0]);
        int[] indicesArr = ArrayUtils.toPrimitive((Integer[])integerArray);
        return new CompiledData(posArr, textCoordArr, normArr, null, null, indicesArr, null);
    }

    private static void processFaceVertex(int index, IndexGroup indices, BOBJMesh mesh, BOBJData data, List<Integer> indicesList, float[] posArr, float[] texCoordArr, float[] normArr, float[] weightsArr, int[] boneIndicesArr) {
        indicesList.add(index);
        if (indices.idxPos >= 0) {
            Vertex vec = data.vertices.get(indices.idxPos);
            posArr[index * 3] = vec.x;
            posArr[index * 3 + 1] = vec.y;
            posArr[index * 3 + 2] = vec.z;
            if (mesh != null) {
                int c = Math.min(vec.weights.size(), 4);
                for (int i = 0; i < c; ++i) {
                    Weight weight = vec.weights.get(i);
                    BOBJBone bone = mesh.armature.bones.get(weight.name);
                    weightsArr[index * 4 + i] = bone == null ? 0.0f : weight.factor;
                    boneIndicesArr[index * 4 + i] = bone == null ? -1 : bone.index;
                }
            }
        }
        if (indices.idxTextCoord >= 0) {
            Vector2d textCoord = data.textures.get(indices.idxTextCoord);
            texCoordArr[index * 2] = (float)textCoord.x;
            texCoordArr[index * 2 + 1] = (float)(1.0 - textCoord.y);
        }
        if (indices.idxVecNormal >= 0) {
            Vector3f vecNorm = data.normals.get(indices.idxVecNormal);
            normArr[index * 3] = vecNorm.x;
            normArr[index * 3 + 1] = vecNorm.y;
            normArr[index * 3 + 2] = vecNorm.z;
        }
    }

    public static class BOBJData {
        public List<Vertex> vertices;
        public List<Vector2d> textures;
        public List<Vector3f> normals;
        public List<BOBJMesh> meshes;
        public Map<String, BOBJAction> actions;
        public Map<String, BOBJArmature> armatures;

        public BOBJData(List<Vertex> vertices, List<Vector2d> textures, List<Vector3f> normals, List<BOBJMesh> meshes, Map<String, BOBJAction> actions, Map<String, BOBJArmature> armatures) {
            this.vertices = vertices;
            this.textures = textures;
            this.normals = normals;
            this.meshes = meshes;
            this.actions = actions;
            this.armatures = armatures;
            for (BOBJMesh mesh : meshes) {
                mesh.armature = armatures.get(mesh.armatureName);
            }
        }

        public boolean hasGeometry() {
            return !this.meshes.isEmpty();
        }

        public void dispose() {
            this.vertices.clear();
            this.textures.clear();
            this.normals.clear();
            this.meshes.clear();
        }

        public void initiateArmatures() {
            for (BOBJArmature armature : this.armatures.values()) {
                armature.initArmature();
            }
        }
    }

    public static class BOBJMesh {
        public String name;
        public List<Face> faces = new ArrayList<Face>();
        public String armatureName;
        public BOBJArmature armature;

        public BOBJMesh(String name) {
            this.name = name;
        }

        public BOBJMesh add(int vertices, int normals, int textures) {
            BOBJMesh mesh = new BOBJMesh(this.name);
            mesh.armatureName = this.armatureName;
            mesh.armature = this.armature;
            for (Face face : this.faces) {
                mesh.faces.add(face.add(vertices, normals, textures));
            }
            return mesh;
        }
    }

    public static class Vertex {
        public float x;
        public float y;
        public float z;
        public List<Weight> weights = new ArrayList<Weight>();

        public Vertex(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void eliminateTinyWeights() {
            this.weights.removeIf(w -> (double)w.factor < 0.01);
            if (this.weights.isEmpty()) {
                return;
            }
            float weight = 0.0f;
            for (Weight w2 : this.weights) {
                weight += w2.factor;
            }
            if (weight != 1.0f) {
                for (Weight w2 : this.weights) {
                    w2.factor /= weight;
                }
            }
        }
    }

    public static class Weight {
        public String name;
        public float factor;

        public Weight(String name, float factor) {
            this.name = name;
            this.factor = factor;
        }
    }

    public static class Face {
        public IndexGroup[] idxGroups = new IndexGroup[3];

        public Face(String v1, String v2, String v3) {
            this.idxGroups[0] = this.parseLine(v1);
            this.idxGroups[1] = this.parseLine(v2);
            this.idxGroups[2] = this.parseLine(v3);
        }

        public Face() {
        }

        private IndexGroup parseLine(String line) {
            IndexGroup idxGroup = new IndexGroup();
            String[] lineTokens = line.split("/");
            int length = lineTokens.length;
            idxGroup.idxPos = Integer.parseInt(lineTokens[0]) - 1;
            if (length > 1) {
                String textCoord = lineTokens[1];
                if (!textCoord.isEmpty()) {
                    idxGroup.idxTextCoord = Integer.parseInt(textCoord) - 1;
                }
                if (length > 2) {
                    idxGroup.idxVecNormal = Integer.parseInt(lineTokens[2]) - 1;
                }
            }
            return idxGroup;
        }

        public Face add(int v, int n, int t) {
            Face face = new Face();
            for (int i = 0; i < face.idxGroups.length; ++i) {
                IndexGroup group = this.idxGroups[i];
                face.idxGroups[i] = new IndexGroup(group.idxPos + v, group.idxTextCoord + t, group.idxVecNormal + n);
            }
            return face;
        }
    }

    public static class CompiledData {
        public float[] posData;
        public float[] texData;
        public float[] normData;
        public float[] weightData;
        public int[] boneIndexData;
        public int[] indexData;
        public BOBJMesh mesh;

        public CompiledData(float[] posData, float[] texData, float[] normData, float[] weightData, int[] boneIndexData, int[] indexData, BOBJMesh mesh) {
            this.posData = posData;
            this.texData = texData;
            this.normData = normData;
            this.weightData = weightData;
            this.boneIndexData = boneIndexData;
            this.indexData = indexData;
            this.mesh = mesh;
        }
    }

    public static class IndexGroup {
        public static final int NO_VALUE = -1;
        public int idxPos = -1;
        public int idxTextCoord = -1;
        public int idxVecNormal = -1;

        public IndexGroup(int v, int t, int n) {
            this.idxPos = v;
            this.idxTextCoord = t;
            this.idxVecNormal = n;
        }

        public IndexGroup() {
        }
    }
}

