/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render.vanilla;

import com.google.common.collect.Maps;
import java.util.Map;
import mchorse.bbs_mod.cubic.model.ArmorType;
import mchorse.bbs_mod.forms.entities.IEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class ArmorRenderer {
    private static final Map<String, class_2960> ARMOR_TEXTURE_CACHE = Maps.newHashMap();
    private final class_572 innerModel;
    private final class_572 outerModel;
    private final class_1059 armorTrimsAtlas;

    public ArmorRenderer(class_572 innerModel, class_572 outerModel, class_1092 bakery) {
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.armorTrimsAtlas = bakery.method_24153(class_4722.field_42071);
    }

    public void renderArmorSlot(class_4587 matrices, class_4597 vertexConsumers, IEntity entity, class_1304 armorSlot, ArmorType type, int light) {
        class_1738 armorItem;
        class_1799 itemStack = entity.getEquipmentStack(armorSlot);
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1738 && (armorItem = (class_1738)item).method_7685() == armorSlot) {
            boolean innerModel = this.usesInnerModel(armorSlot);
            class_572 bipedModel = this.getModel(armorSlot);
            class_630 part = this.getPart(bipedModel, type);
            bipedModel.method_2805(true);
            part.field_3655 = 0.0f;
            part.field_3656 = 0.0f;
            part.field_3657 = 0.0f;
            part.field_3674 = 0.0f;
            part.field_3675 = 0.0f;
            part.field_3654 = 0.0f;
            part.field_37940 = 1.0f;
            part.field_37939 = 1.0f;
            part.field_37938 = 1.0f;
            class_9282 dyedColor = (class_9282)itemStack.method_57824(class_9334.field_49644);
            if (dyedColor != null) {
                int color = dyedColor.comp_2384();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                this.renderArmorParts(part, matrices, vertexConsumers, light, armorItem, innerModel, r, g, b, null);
                this.renderArmorParts(part, matrices, vertexConsumers, light, armorItem, innerModel, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderArmorParts(part, matrices, vertexConsumers, light, armorItem, innerModel, 1.0f, 1.0f, 1.0f, null);
            }
            if (itemStack.method_7958()) {
                this.renderGlint(part, matrices, vertexConsumers, light);
            }
        }
    }

    private class_630 getPart(class_572 bipedModel, ArmorType type) {
        switch (type) {
            case HELMET: {
                return bipedModel.field_3398;
            }
            case CHEST: 
            case LEGGINGS: {
                return bipedModel.field_3391;
            }
            case LEFT_ARM: {
                return bipedModel.field_27433;
            }
            case RIGHT_ARM: {
                return bipedModel.field_3401;
            }
            case LEFT_LEG: 
            case LEFT_BOOT: {
                return bipedModel.field_3397;
            }
            case RIGHT_LEG: 
            case RIGHT_BOOT: {
                return bipedModel.field_3392;
            }
        }
        return bipedModel.field_3398;
    }

    private void renderArmorParts(class_630 part, class_4587 matrices, class_4597 vertexConsumers, int light, class_1738 item, boolean secondTextureLayer, float red, float green, float blue, String overlay) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getArmorTexture(item, secondTextureLayer, overlay)));
        if (red != 1.0f || green != 1.0f || blue != 1.0f) {
            vertexConsumer = new ColoredVertexConsumer(vertexConsumer, red, green, blue);
        }
        part.method_22698(matrices, vertexConsumer, light, class_4608.field_21444);
    }

    private void renderTrim(class_630 part, class_6880<class_1741> material, class_4587 matrices, class_4597 vertexConsumers, int light, class_8053 trim, boolean leggings) {
    }

    private void renderGlint(class_630 part, class_4587 matrices, class_4597 vertexConsumers, int light) {
        part.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_27949()), light, class_4608.field_21444);
    }

    private class_572 getModel(class_1304 slot) {
        return this.usesInnerModel(slot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(class_1304 slot) {
        return slot == class_1304.field_6172;
    }

    private class_2960 getArmorTexture(class_1738 item, boolean secondLayer, String overlay) {
        class_6880 material = item.method_7686();
        String materialName = material.method_40230().map(key -> key.method_29177().method_12832()).orElse("unknown");
        String id = "textures/models/armor/" + materialName + "_layer_" + (secondLayer ? 2 : 1) + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(id, s -> class_2960.method_12829((String)s));
    }

    @Environment(value=EnvType.CLIENT)
    private static class ColoredVertexConsumer
    implements class_4588 {
        private final class_4588 delegate;
        private final float red;
        private final float green;
        private final float blue;

        public ColoredVertexConsumer(class_4588 delegate, float red, float green, float blue) {
            this.delegate = delegate;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public class_4588 method_22912(float x, float y, float z) {
            this.delegate.method_22912(x, y, z);
            return this;
        }

        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            int r = (int)((float)red * this.red);
            int g = (int)((float)green * this.green);
            int b = (int)((float)blue * this.blue);
            this.delegate.method_1336(r, g, b, alpha);
            return this;
        }

        public class_4588 method_22913(float u, float v) {
            this.delegate.method_22913(u, v);
            return this;
        }

        public class_4588 method_60796(int u, int v) {
            this.delegate.method_60796(u, v);
            return this;
        }

        public class_4588 method_22921(int u, int v) {
            this.delegate.method_22921(u, v);
            return this;
        }

        public class_4588 method_22914(float x, float y, float z) {
            this.delegate.method_22914(x, y, z);
            return this;
        }
    }
}

