/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.BodyPartManager;
import mchorse.bbs_mod.forms.forms.IStateFoundCallback;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.forms.states.AnimationStates;
import mchorse.bbs_mod.forms.states.StatePlayer;
import mchorse.bbs_mod.forms.values.ValueAnchor;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.core.ValueTransform;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.pose.Transform;
import net.minecraft.class_1309;
import net.minecraft.class_5134;

public abstract class Form
extends ValueGroup {
    public final ValueBoolean visible = new ValueBoolean("visible", true);
    public final ValueBoolean animatable = new ValueBoolean("animatable", true);
    public final ValueString trackName = new ValueString("track_name", "");
    public final ValueFloat lighting = new ValueFloat("lighting", Float.valueOf(1.0f));
    public final ValueString name = new ValueString("name", "");
    public final ValueTransform transform = new ValueTransform("transform", new Transform());
    public final ValueTransform transformOverlay = new ValueTransform("transform_overlay", new Transform());
    public final ValueFloat uiScale = new ValueFloat("uiScale", Float.valueOf(1.0f));
    public final ValueAnchor anchor = new ValueAnchor("anchor", new Anchor());
    public final ValueBoolean shaderShadow = new ValueBoolean("shaderShadow", true);
    public final List<ValueTransform> additionalTransforms = new ArrayList<ValueTransform>();
    public final ValueBoolean hitbox = new ValueBoolean("hitbox", false);
    public final ValueFloat hitboxWidth = new ValueFloat("hitboxWidth", Float.valueOf(0.5f));
    public final ValueFloat hitboxHeight = new ValueFloat("hitboxHeight", Float.valueOf(1.8f));
    public final ValueFloat hitboxSneakMultiplier = new ValueFloat("hitboxSneakMultiplier", Float.valueOf(0.9f));
    public final ValueFloat hitboxEyeHeight = new ValueFloat("hitboxEyeHeight", Float.valueOf(0.9f));
    public final ValueFloat hp = new ValueFloat("hp", Float.valueOf(20.0f));
    public final ValueFloat speed = new ValueFloat("movement_speed", Float.valueOf(0.1f));
    public final ValueFloat stepHeight = new ValueFloat("step_height", Float.valueOf(0.5f));
    public final ValueInt hotkey = new ValueInt("keybind", 0);
    public final BodyPartManager parts = new BodyPartManager("parts");
    public final AnimationStates states = new AnimationStates("states");
    protected Object renderer;
    protected String cachedID;
    private final List<StatePlayer> statePlayers = new ArrayList<StatePlayer>();

    public Form() {
        super("");
        this.animatable.invisible();
        this.trackName.invisible();
        this.name.invisible();
        this.uiScale.invisible();
        this.shaderShadow.invisible();
        this.add(this.visible);
        this.add(this.animatable);
        this.add(this.trackName);
        this.add(this.lighting);
        this.add(this.name);
        this.add(this.transform);
        this.add(this.transformOverlay);
        for (int i = 0; i < (Integer)BBSSettings.recordingPoseTransformOverlays.get(); ++i) {
            ValueTransform valueTransform = new ValueTransform("transform_overlay" + i, new Transform());
            this.additionalTransforms.add(valueTransform);
            this.add(valueTransform);
        }
        this.add(this.uiScale);
        this.add(this.anchor);
        this.add(this.shaderShadow);
        this.hitbox.invisible();
        this.hitboxWidth.invisible();
        this.hitboxHeight.invisible();
        this.hitboxSneakMultiplier.invisible();
        this.hitboxEyeHeight.invisible();
        this.add(this.hitbox);
        this.add(this.hitboxWidth);
        this.add(this.hitboxHeight);
        this.add(this.hitboxSneakMultiplier);
        this.add(this.hitboxEyeHeight);
        this.hp.invisible();
        this.speed.invisible();
        this.stepHeight.invisible();
        this.add(this.hp);
        this.add(this.speed);
        this.add(this.stepHeight);
        this.hotkey.invisible();
        this.add(this.hotkey);
        this.add(this.parts);
        this.add(this.states);
    }

    public Object getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Object renderer) {
        this.renderer = renderer;
    }

    public Form getParentForm() {
        for (BaseValue parentValue = this.getParent(); parentValue != null; parentValue = parentValue.getParent()) {
            if (!(parentValue instanceof Form)) continue;
            Form form = (Form)parentValue;
            return form;
        }
        return null;
    }

    public boolean findState(int hotkey, IStateFoundCallback callback) {
        if (callback == null) {
            return false;
        }
        for (AnimationState state : this.states.getAllTyped()) {
            if ((Integer)state.keybind.get() != hotkey) continue;
            callback.acceptState(this, state);
            return true;
        }
        return false;
    }

    public void clearStatePlayers() {
        this.statePlayers.clear();
    }

    public void playState(AnimationState state) {
        if (state != null) {
            if (((Boolean)state.looping.get()).booleanValue()) {
                for (StatePlayer statePlayer : this.statePlayers) {
                    if (statePlayer.getState() != state) continue;
                    statePlayer.expire();
                    return;
                }
            }
            this.statePlayers.add(new StatePlayer(state));
        }
    }

    public void playState(String stateId) {
        this.playState(this.states.getById(stateId));
    }

    public void playMain() {
        this.clearStatePlayers();
        this.playState(this.states.getMainRandom());
    }

    public void applyStates(float transition) {
        for (StatePlayer statePlayer : this.statePlayers) {
            statePlayer.assignValues(this, transition);
        }
    }

    public void unapplyStates() {
        for (StatePlayer statePlayer : this.statePlayers) {
            statePlayer.resetValues(this);
        }
    }

    public void onMorph(class_1309 entity) {
        float hp = ((Float)this.hp.get()).floatValue();
        float speed = ((Float)this.speed.get()).floatValue();
        float stepHeight = ((Float)this.stepHeight.get()).floatValue();
        if (hp != 20.0f) {
            entity.method_5996(class_5134.field_23716).method_6192((double)hp);
            entity.method_6033(hp);
        }
        if (speed != 0.1f) {
            entity.method_5996(class_5134.field_23719).method_6192((double)speed);
        }
        if (stepHeight != 0.6f) {
            entity.method_5996(class_5134.field_47761).method_6192((double)stepHeight);
        }
    }

    public void onDemorph(class_1309 entity) {
        entity.method_5996(class_5134.field_23716).method_6192(20.0);
        entity.method_6033(20.0f);
        entity.method_5996(class_5134.field_23719).method_6192((double)0.1f);
        entity.method_5996(class_5134.field_47761).method_6192((double)0.6f);
    }

    public String getFormId() {
        if (this.cachedID == null) {
            this.cachedID = BBSMod.getForms().getType(this).toString();
        }
        return this.cachedID;
    }

    public String getFormIdOrName() {
        String name = (String)this.name.get();
        return name.isEmpty() ? this.getFormId() : name;
    }

    public final String getDisplayName() {
        String name = (String)this.name.get();
        if (!name.isEmpty()) {
            return name;
        }
        return this.getDefaultDisplayName();
    }

    protected String getDefaultDisplayName() {
        return this.getFormId();
    }

    public String getTrackName(String property) {
        String s = (String)this.trackName.get();
        if (!s.isEmpty()) {
            if (property.isEmpty()) {
                return s;
            }
            int slash = property.lastIndexOf(47);
            String last = slash == -1 ? property : property.substring(slash + 1);
            return s + (String)(StringUtils.isInteger(last) ? "" : "/" + last);
        }
        return property;
    }

    public void update(IEntity entity) {
        this.parts.update(entity);
        if (this.renderer instanceof ITickable) {
            ((ITickable)this.renderer).tick(entity);
        }
        Iterator<StatePlayer> it = this.statePlayers.iterator();
        while (it.hasNext()) {
            StatePlayer next = it.next();
            next.update();
            if (!next.canBeRemoved()) continue;
            it.remove();
        }
    }

    @Override
    public void fromData(BaseType data) {
        MapType bodyParts;
        MapType map;
        if (data instanceof MapType && (map = (MapType)data).has("bodyParts") && (bodyParts = map.getMap("bodyParts")).has("parts")) {
            map.remove("bodyParts");
            map.put("parts", bodyParts.getList("parts"));
        }
        super.fromData(data);
        if (data instanceof MapType) {
            map = (MapType)data;
            FormUtils.readOldStateTriggers(this, map);
        }
    }

    @Override
    public BaseType toData() {
        BaseType data = super.toData();
        if (data instanceof MapType) {
            MapType map = (MapType)data;
            BBSMod.getForms().appendId(this, map);
        }
        return data;
    }
}

