/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.TrailForm;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class TrailFormRenderer
extends FormRenderer<TrailForm>
implements ITickable {
    private int tick;
    private final Map<FormRenderType, ArrayDeque<Trail>> record = new HashMap<FormRenderType, ArrayDeque<Trail>>();

    public TrailFormRenderer(TrailForm form) {
        super(form);
    }

    @Override
    protected void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        Texture texture = context.render.getTextures().getTexture((Link)((TrailForm)this.form).texture.get());
        float min = Math.min(texture.width, texture.height);
        int ow = x2 - x1 - 4;
        int oh = y2 - y1 - 4;
        int w = (int)((float)texture.width / min * (float)ow);
        int h = (int)((float)texture.height / min * (float)ow);
        int x = x1 + (ow - w) / 2 + 2;
        int y = y1 + (oh - h) / 2 + 2;
        context.batcher.fullTexturedBox(texture, x, y, w, h);
    }

    @Override
    protected void render3D(FormRenderingContext context) {
        super.render3D(context);
        if (BBSRendering.isIrisShadowPass() || context.type == FormRenderType.ITEM_INVENTORY) {
            return;
        }
        if (context.modelRenderer || context.ui) {
            class_4587 stack = context.stack;
            float scale = ((Float)BBSSettings.axesScale.get()).floatValue();
            float axisSize = 1.0f;
            float axisOffset = 0.01f;
            float outlineSize = 1.01f;
            float outlineOffset = 0.02f;
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
            Draw.fillBox(builder, stack, -(outlineOffset *= scale), -outlineSize, -outlineOffset, outlineOffset, outlineSize, outlineOffset, 0.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -(axisOffset *= scale), -axisSize, -axisOffset, axisOffset, axisSize, axisOffset, 0.0f, 1.0f, 0.0f);
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableDepthTest();
            class_286.method_43433((class_9801)builder.method_60800());
            return;
        }
        if (!BBSRendering.isRenderingWorld()) {
            return;
        }
        class_4587 stack = context.stack;
        Camera camera = context.camera;
        Matrix4f camInverse = MatrixStackUtils.getInverseViewRotationMatrix(camera);
        double baseX = camera.position.x;
        double baseY = camera.position.y;
        double baseZ = camera.position.z;
        float current = (float)this.tick + context.transition;
        ArrayDeque trails = this.record.computeIfAbsent(context.type, k -> new ArrayDeque());
        if (!((Boolean)((TrailForm)this.form).paused.get()).booleanValue()) {
            Matrix4f modelView = stack.method_23760().method_23761();
            Vector4f top = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            Vector4f bottom = new Vector4f(0.0f, -1.0f, 0.0f, 1.0f);
            modelView.transform(top);
            modelView.transform(bottom);
            camInverse.transform(top);
            camInverse.transform(bottom);
            top.mul(1.0f / top.w);
            bottom.mul(1.0f / bottom.w);
            Trail record = new Trail();
            record.tick = current;
            record.top = new Vector3d((double)top.x + baseX, (double)top.y + baseY, (double)top.z + baseZ);
            record.bottom = new Vector3d((double)bottom.x + baseX, (double)bottom.y + baseY, (double)bottom.z + baseZ);
            record.stop = (double)new Vector3f(top.x - bottom.x, top.y - bottom.y, top.z - bottom.z).lengthSquared() < 1.0E-4;
            trails.addLast(record);
        }
        boolean loop = (Boolean)((TrailForm)this.form).loop.get();
        float length = ((Float)((TrailForm)this.form).length.get()).floatValue();
        float end = current - length;
        Iterator it = trails.iterator();
        boolean render = false;
        boolean lastStop = true;
        while (it.hasNext()) {
            Trail trail = (Trail)it.next();
            if (trail.tick < end) {
                it.remove();
                continue;
            }
            render |= !trail.stop && !lastStop;
            lastStop = trail.stop;
        }
        if (!render || trails.size() <= 1 || !((double)length > 0.001)) {
            return;
        }
        BBSModClient.getTextures().bindTexture((Link)((TrailForm)this.form).texture.get());
        stack.method_22903();
        Trail last = null;
        Matrix4f m = stack.method_23760().method_23761();
        m.set((Matrix4fc)camInverse);
        m.invert();
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        for (Trail trail : trails) {
            if (last != null && !last.stop && !trail.stop) {
                double x1 = trail.top.x - baseX;
                double x2 = trail.bottom.x - baseX;
                double x3 = last.bottom.x - baseX;
                double x4 = last.top.x - baseX;
                double y1 = trail.top.y - baseY;
                double y2 = trail.bottom.y - baseY;
                double y3 = last.bottom.y - baseY;
                double y4 = last.top.y - baseY;
                double z1 = trail.top.z - baseZ;
                double z2 = trail.bottom.z - baseZ;
                double z3 = last.bottom.z - baseZ;
                double z4 = last.top.z - baseZ;
                if (loop) {
                    u1 = trail.tick / length;
                    u2 = last.tick / length;
                    builder.method_22918(m, (float)x1, (float)y1, (float)z1).method_22913(u1, 0.0f);
                    builder.method_22918(m, (float)x2, (float)y2, (float)z2).method_22913(u1, 1.0f);
                    builder.method_22918(m, (float)x3, (float)y3, (float)z3).method_22913(u2, 1.0f);
                    builder.method_22918(m, (float)x4, (float)y4, (float)z4).method_22913(u2, 0.0f);
                    builder.method_22918(m, (float)x4, (float)y4, (float)z4).method_22913(u2, 0.0f);
                    builder.method_22918(m, (float)x3, (float)y3, (float)z3).method_22913(u2, 1.0f);
                    builder.method_22918(m, (float)x2, (float)y2, (float)z2).method_22913(u1, 1.0f);
                    builder.method_22918(m, (float)x1, (float)y1, (float)z1).method_22913(u1, 0.0f);
                } else {
                    u1 = (current - trail.tick) / length;
                    u2 = (current - last.tick) / length;
                    builder.method_22918(m, (float)x1, (float)y1, (float)z1).method_22913(u1, 0.0f);
                    builder.method_22918(m, (float)x2, (float)y2, (float)z2).method_22913(u1, 1.0f);
                    builder.method_22918(m, (float)x3, (float)y3, (float)z3).method_22913(u2, 1.0f);
                    builder.method_22918(m, (float)x4, (float)y4, (float)z4).method_22913(u2, 0.0f);
                    builder.method_22918(m, (float)x4, (float)y4, (float)z4).method_22913(u2, 0.0f);
                    builder.method_22918(m, (float)x3, (float)y3, (float)z3).method_22913(u2, 1.0f);
                    builder.method_22918(m, (float)x2, (float)y2, (float)z2).method_22913(u1, 1.0f);
                    builder.method_22918(m, (float)x1, (float)y1, (float)z1).method_22913(u1, 0.0f);
                }
            } else {
                length = current - trail.tick;
            }
            last = trail;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.enableDepthTest();
        stack.method_22909();
    }

    @Override
    public void tick(IEntity entity) {
        ++this.tick;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Trail {
        public float tick;
        public Vector3d top;
        public Vector3d bottom;
        public boolean stop;
    }
}

