/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.math.molang;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.IExpression;
import mchorse.bbs_mod.math.MathBuilder;
import mchorse.bbs_mod.math.Variable;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.expressions.MolangAssignment;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.math.molang.expressions.MolangMultiStatement;
import mchorse.bbs_mod.math.molang.expressions.MolangValue;
import mchorse.bbs_mod.math.molang.functions.AcosDegrees;
import mchorse.bbs_mod.math.molang.functions.AsinDegrees;
import mchorse.bbs_mod.math.molang.functions.Atan2Degrees;
import mchorse.bbs_mod.math.molang.functions.AtanDegrees;
import mchorse.bbs_mod.math.molang.functions.CosDegrees;
import mchorse.bbs_mod.math.molang.functions.SinDegrees;

public class MolangParser
extends MathBuilder {
    public static final MolangExpression ZERO = new MolangValue(null, new Constant(0.0));
    public static final MolangExpression ONE = new MolangValue(null, new Constant(1.0));
    public static final String RETURN = "return ";
    private MolangMultiStatement currentStatement;
    private boolean registerAsGlobals;

    public MolangParser() {
        this.functions.put("cos", CosDegrees.class);
        this.functions.put("sin", SinDegrees.class);
        this.functions.put("acos", AcosDegrees.class);
        this.functions.put("asin", AsinDegrees.class);
        this.functions.put("atan", AtanDegrees.class);
        this.functions.put("atan2", Atan2Degrees.class);
        this.remap("abs", "math.abs");
        this.remap("ceil", "math.ceil");
        this.remap("clamp", "math.clamp");
        this.remap("cos", "math.cos");
        this.remap("exp", "math.exp");
        this.remap("floor", "math.floor");
        this.remap("lerp", "math.lerp");
        this.remap("lerprotate", "math.lerprotate");
        this.remap("ln", "math.ln");
        this.remap("max", "math.max");
        this.remap("min", "math.min");
        this.remap("mod", "math.mod");
        this.remap("pow", "math.pow");
        this.remap("random", "math.random");
        this.remap("round", "math.round");
        this.remap("sin", "math.sin");
        this.remap("sqrt", "math.sqrt");
        this.remap("trunc", "math.trunc");
        this.remap("acos", "math.acos");
        this.remap("asin", "math.asin");
        this.remap("atan", "math.atan");
        this.remap("atan2", "math.atan2");
        this.remap("randomi", "math.random_integer");
        this.remap("roll", "math.die_roll");
        this.remap("rolli", "math.die_roll_integer");
        this.remap("hermite", "math.hermite_blend");
        this.remapVar("PI", "math.pi");
    }

    public void remap(String old, String newName) {
        this.functions.put(newName, (Class)this.functions.remove(old));
    }

    public void remapVar(String old, String newName) {
        this.variables.put(newName, (Variable)this.variables.remove(old));
    }

    public void setValue(String name, double value) {
        Variable variable = this.getVariable(name);
        if (variable != null) {
            variable.set(value);
        }
    }

    @Override
    protected Variable getVariable(String name) {
        MolangMultiStatement currentStatement;
        Variable variable;
        if (((String)name).charAt(1) == '.') {
            if (((String)name).charAt(0) == 'q') {
                name = "query." + ((String)name).substring(2);
            } else if (((String)name).charAt(0) == 'v') {
                name = "variable." + ((String)name).substring(2);
            }
        }
        Variable variable2 = variable = (currentStatement = this.currentStatement) == null ? null : currentStatement.locals.get(name);
        if (variable == null) {
            variable = super.getVariable((String)name);
        }
        if (variable == null) {
            variable = new Variable((String)name, 0.0);
            this.register(variable);
        }
        return variable;
    }

    public Variable getOrCreateVariable(String key) {
        Variable variable = (Variable)this.variables.get(key);
        if (variable == null) {
            variable = new Variable(key, 0.0);
            this.register(variable);
        }
        return variable;
    }

    public MolangExpression parseDataSilently(BaseType data) {
        return this.parseDataSilently(data, ZERO);
    }

    public MolangExpression parseDataSilently(BaseType data, MolangExpression defaultExpression) {
        try {
            return this.parseData(data);
        }
        catch (Exception e) {
            System.err.println("Failed to parse MoLang: " + String.valueOf(data));
            e.printStackTrace();
            return defaultExpression;
        }
    }

    public MolangExpression parseData(BaseType data) throws MolangException {
        if (BaseType.isPrimitive(data)) {
            if (BaseType.isString(data)) {
                String string = data.asString();
                try {
                    return new MolangValue(this, new Constant(Double.parseDouble(string)));
                }
                catch (Exception exception) {
                    return this.parseExpression(string);
                }
            }
            return new MolangValue(this, new Constant(data.asNumeric().doubleValue()));
        }
        return ZERO;
    }

    public MolangExpression parseGlobalData(BaseType data) {
        this.registerAsGlobals = true;
        MolangExpression expression = this.parseDataSilently(data);
        this.registerAsGlobals = false;
        return expression;
    }

    public MolangExpression parseExpression(String expression) throws MolangException {
        MolangMultiStatement result;
        ArrayList<String> lines = new ArrayList<String>();
        for (String split : expression.toLowerCase().trim().split(";")) {
            if (split.trim().isEmpty()) continue;
            lines.add(split);
        }
        if (lines.isEmpty()) {
            throw new MolangException("Molang expression cannot be blank!");
        }
        this.currentStatement = result = new MolangMultiStatement(this);
        try {
            for (String line : lines) {
                result.expressions.add(this.parseOneLine(line));
            }
        }
        catch (Exception e) {
            this.currentStatement = null;
            throw e;
        }
        this.currentStatement = null;
        return result;
    }

    protected MolangExpression parseOneLine(String expression) throws MolangException {
        if ((expression = expression.trim()).startsWith(RETURN)) {
            try {
                return new MolangValue(this, this.parse(expression.substring(RETURN.length()))).addReturn();
            }
            catch (Exception e) {
                throw new MolangException("Couldn't parse return '" + expression + "' expression!");
            }
        }
        try {
            List<Object> symbols = this.breakdownChars(this.breakdown(expression));
            if (symbols.size() >= 3 && symbols.get(0) instanceof String && this.isVariable(symbols.get(0)) && symbols.get(1).equals("=")) {
                String name = (String)symbols.get(0);
                symbols = symbols.subList(2, symbols.size());
                Variable variable = null;
                if (!(this.registerAsGlobals || this.variables.containsKey(name) || this.currentStatement.locals.containsKey(name))) {
                    variable = new Variable(name, 0.0);
                    this.currentStatement.locals.put(name, variable);
                } else {
                    variable = this.getVariable(name);
                }
                return new MolangAssignment(this, variable, this.parseSymbolsMolang(symbols));
            }
            return new MolangValue(this, this.parseSymbolsMolang(symbols));
        }
        catch (Exception e) {
            throw new MolangException("Couldn't parse '" + expression + "' expression!");
        }
    }

    private IExpression parseSymbolsMolang(List<Object> symbols) throws MolangException {
        try {
            return this.parseSymbols(symbols);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MolangException("Couldn't parse an expression!");
        }
    }

    @Override
    protected boolean isOperator(String s) {
        return super.isOperator(s) || s.equals("=");
    }
}

