/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.AudioRenderer;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.controller.RunnerCameraController;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.Films;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.settings.ui.UIVideoSettingsOverlayPanel;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanels;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.controller.UIOnionSkinContextMenu;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIMessageFolderOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIMessageOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.utils.EventPropagation;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyCodes;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.FFMpegUtils;
import mchorse.bbs_mod.utils.ScreenshotRecorder;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class UIFilmPreview
extends UIElement {
    private List<AudioClip> clips = new ArrayList<AudioClip>();
    private UIFilmPanel panel;
    public UIElement icons;
    public UIIcon replays;
    public UIIcon onionSkin;
    public UIIcon plause;
    public UIIcon teleport;
    public UIIcon flight;
    public UIIcon control;
    public UIIcon perspective;
    public UIIcon recordReplay;
    public UIIcon recordVideo;

    public UIFilmPreview(UIFilmPanel filmPanel) {
        this.panel = filmPanel;
        this.icons = UI.row(0, 0, new UIElement[0]);
        this.icons.row().resize();
        this.icons.relative(this).x(0.5f).y(1.0f).anchor(0.5f, 1.0f);
        this.replays = new UIIcon(Icons.EDITOR, b -> this.openReplays());
        this.replays.tooltip(UIKeys.FILM_REPLAY_TITLE);
        this.onionSkin = new UIIcon(Icons.ONION_SKIN, b -> this.openOnionSkin());
        this.onionSkin.tooltip(UIKeys.FILM_CONTROLLER_ONION_SKIN_TITLE);
        this.plause = new UIIcon(() -> this.panel.isRunning() ? Icons.PAUSE : Icons.PLAY, b -> this.panel.togglePlayback());
        this.plause.tooltip(UIKeys.CAMERA_EDITOR_KEYS_EDITOR_PLAUSE);
        this.plause.context((ContextMenuManager menu) -> {
            menu.action(Icons.PLAY, UIKeys.CAMERA_EDITOR_KEYS_EDITOR_PLAY_FILM, () -> {
                if (!this.panel.checkShowNoCamera()) {
                    this.panel.dashboard.closeThisMenu();
                    Films.playFilm(((Film)this.panel.getData()).getId(), true);
                }
            });
            menu.action(Icons.PAUSE, UIKeys.CAMERA_EDITOR_KEYS_EDITOR_FREEZE_PAUSED, !this.panel.getController().isPaused(), () -> this.panel.getController().setPaused(!this.panel.getController().isPaused()));
        });
        this.teleport = new UIIcon(Icons.MOVE_TO, b -> this.panel.teleportToCamera());
        this.teleport.tooltip(UIKeys.FILM_TELEPORT_TITLE);
        this.teleport.context((ContextMenuManager menu) -> {
            menu.action(Icons.MOVE_TO, UIKeys.FILM_TELEPORT_CONTEXT_PLAYER, this.panel.playerToCamera, () -> {
                this.panel.playerToCamera = !this.panel.playerToCamera;
            });
            menu.action(Icons.COPY, UIKeys.CAMERA_PANELS_CONTEXT_COPY_POSITION, () -> {
                Position current = new Position(this.panel.getCamera());
                Window.setClipboard(current.toData(), "_CopyCameraPosition");
            });
            MapType map = Window.getClipboardMap("_CopyCameraPosition");
            if (map != null) {
                menu.action(Icons.PASTE, UIKeys.CAMERA_PANELS_CONTEXT_PASTE_POSITION, () -> {
                    Position current = new Position();
                    current.fromData(map);
                    this.panel.cameraEditor.editClip(current);
                });
            }
        });
        this.flight = new UIIcon(Icons.PLANE, b -> this.panel.toggleFlight());
        this.flight.tooltip(UIKeys.CAMERA_EDITOR_KEYS_MODES_FLIGHT);
        this.control = new UIIcon(Icons.POSE, b -> this.panel.getController().toggleControl());
        this.control.tooltip(UIKeys.FILM_CONTROLLER_KEYS_TOGGLE_CONTROL);
        this.perspective = new UIIcon(this.panel.getController()::getOrbitModeIcon, b -> this.panel.getController().toggleOrbitMode());
        this.perspective.tooltip(UIKeys.FILM_CONTROLLER_KEYS_CHANGE_CAMERA_MODE);
        this.recordReplay = new UIIcon(Icons.SPHERE, b -> this.panel.getController().pickRecording());
        this.recordReplay.tooltip(UIKeys.FILM_REPLAY_RECORD);
        this.recordReplay.context((ContextMenuManager menu) -> menu.action(Icons.DOWNLOAD, UIKeys.FILM_CONTROLLER_KEYS_TOGGLE_INSTANT_KEYFRAMES, this.panel.getController().isInstantKeyframes(), () -> this.panel.getController().toggleInstantKeyframes()));
        this.recordVideo = new UIIcon(Icons.VIDEO_CAMERA, b -> {
            if (this.panel.checkShowNoCamera()) {
                return;
            }
            if (!FFMpegUtils.checkFFMPEG()) {
                UIMessageOverlayPanel panel = new UIMessageOverlayPanel(UIKeys.GENERAL_WARNING, UIKeys.GENERAL_FFMPEG_ERROR_DESCRIPTION);
                UIIcon guide = new UIIcon(Icons.HELP, bb -> UIUtils.openWebLink(UIKeys.GENERAL_FFMPEG_ERROR_GUIDE_LINK.get()));
                guide.tooltip(UIKeys.GENERAL_FFMPEG_ERROR_GUIDE, Direction.LEFT);
                panel.icons.add((IUIElement)guide);
                UIOverlay.addOverlay(this.getContext(), panel);
                return;
            }
            this.panel.recorder.startRecording(((Film)this.panel.getData()).camera.calculateDuration(), BBSRendering.getTexture());
        });
        this.recordVideo.tooltip(UIKeys.CAMERA_TOOLTIPS_RECORD);
        this.recordVideo.context((ContextMenuManager menu) -> {
            menu.action(Icons.CAMERA, UIKeys.FILM_SCREENSHOT, () -> {
                ScreenshotRecorder recorder = BBSModClient.getScreenshotRecorder();
                Texture texture = BBSRendering.getTexture();
                recorder.takeScreenshot(Window.isAltPressed() ? null : recorder.getScreenshotFile(), texture.id, texture.width, texture.height);
                UIMessageFolderOverlayPanel overlayPanel = new UIMessageFolderOverlayPanel(UIKeys.FILM_SCREENSHOT_TITLE, UIKeys.FILM_SCREENSHOT_DESCRIPTION, recorder.getScreenshots());
                UIOverlay.addOverlay(this.getContext(), overlayPanel);
            });
            menu.action(Icons.FILM, UIKeys.CAMERA_TOOLTIPS_OPEN_VIDEOS, () -> this.panel.recorder.openMovies());
            menu.action(Icons.GEAR, UIKeys.CAMERA_TOOLTIPS_OPEN_VIDEO_SETTINGS, () -> UIOverlay.addOverlay(this.getContext(), new UIVideoSettingsOverlayPanel(BBSSettings.videoSettings)));
            menu.action(Icons.SOUND, UIKeys.FILM_RENDER_AUDIO, this::renderAudio);
            menu.action(Icons.REFRESH, UIKeys.FILM_RESET_REPLAYS, this.panel.recorder.resetReplays, () -> {
                this.panel.recorder.resetReplays = !this.panel.recorder.resetReplays;
            });
        });
        this.icons.add(this.replays, this.onionSkin, this.plause, this.teleport, this.flight, this.control, this.perspective, this.recordReplay, this.recordVideo);
        this.add((IUIElement)this.icons);
    }

    public void openReplays() {
        UIOverlay overlay = UIOverlay.addOverlayLeft(this.getContext(), this.panel.replayEditor.replays, 360);
        overlay.eventPropagataion(EventPropagation.PASS);
    }

    public void openOnionSkin() {
        this.getContext().replaceContextMenu(new UIOnionSkinContextMenu(this.panel, this.panel.getController().getOnionSkin()));
    }

    private void renderAudio() {
        Clips camera = ((Film)this.panel.getData()).camera;
        List<AudioClip> audioClips = camera.getClips(AudioClip.class);
        String name = StringUtils.createTimestampFilename() + ".wav";
        File videos = BBSRendering.getVideoFolder();
        UIContext context = this.getContext();
        if (AudioRenderer.renderAudio(new File(videos, name), audioClips, camera.calculateDuration(), 48000)) {
            UIOverlay.addOverlay(context, new UIMessageFolderOverlayPanel(UIKeys.GENERAL_SUCCESS, UIKeys.FILM_RENDER_AUDIO_SUCCESS, videos));
        } else {
            UIOverlay.addOverlay(context, new UIMessageOverlayPanel(UIKeys.GENERAL_ERROR, UIKeys.FILM_RENDER_AUDIO_ERROR));
        }
    }

    public Area getViewport() {
        int width = BBSRendering.getVideoWidth();
        int height = BBSRendering.getVideoHeight();
        int w = this.area.w;
        int h = this.area.h;
        Camera camera = new Camera();
        camera.copy(this.panel.getWorldCamera());
        camera.updatePerspectiveProjection(width, height);
        Vector2i size = Vectors.resize((float)width / (float)height, w, h);
        Area area = new Area();
        area.setSize(size.x, size.y);
        area.setPos(this.area.mx() - area.w / 2, this.area.my() - area.h / 2);
        return area;
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        Area area = this.getViewport();
        if (area.isInside(context)) {
            return this.panel.replayEditor.clickViewport(context, area);
        }
        return super.subMouseClicked(context);
    }

    @Override
    public void render(UIContext context) {
        int guidesColor;
        Texture texture = BBSRendering.getTexture();
        Area area = this.getViewport();
        Camera camera = this.panel.getCamera();
        camera.copy(this.panel.getWorldCamera());
        camera.view.set((Matrix4fc)this.panel.lastView);
        camera.projection.set((Matrix4fc)this.panel.lastProjection);
        context.batcher.flush();
        if (texture != null) {
            context.batcher.texturedBox(texture.id, -1, (float)area.x, (float)area.y, (float)area.w, (float)area.h, 0.0f, (float)texture.height, (float)texture.width, 0.0f, texture.width, texture.height);
        }
        this.renderCursor(context);
        if (((Boolean)BBSSettings.editorRuleOfThirds.get()).booleanValue()) {
            guidesColor = (Integer)BBSSettings.editorGuidesColor.get();
            context.batcher.box(area.x + area.w / 3 - 1, area.y, area.x + area.w / 3, area.y + area.h, guidesColor);
            context.batcher.box(area.x + area.w - area.w / 3, area.y, area.x + area.w - area.w / 3 + 1, area.y + area.h, guidesColor);
            context.batcher.box(area.x, area.y + area.h / 3 - 1, area.x + area.w, area.y + area.h / 3, guidesColor);
            context.batcher.box(area.x, area.y + area.h - area.h / 3, area.x + area.w, area.y + area.h - area.h / 3 + 1, guidesColor);
        }
        if (((Boolean)BBSSettings.editorCenterLines.get()).booleanValue()) {
            guidesColor = (Integer)BBSSettings.editorGuidesColor.get();
            int x = area.mx();
            int y = area.my();
            context.batcher.box(area.x, y, area.ex(), y + 1, guidesColor);
            context.batcher.box(x, area.y, x + 1, area.ey(), guidesColor);
        }
        if (((Boolean)BBSSettings.editorCrosshair.get()).booleanValue()) {
            int x = area.mx() + 1;
            int y = area.my() + 1;
            context.batcher.box(x - 4, y - 1, x + 3, y, Colors.setA(-1, 0.5f));
            context.batcher.box(x - 1, y - 4, x, y + 3, Colors.setA(-1, 0.5f));
        }
        this.panel.getController().renderHUD(context, area);
        if (this.panel.replayEditor.isVisible()) {
            RunnerCameraController runner = this.panel.getRunner();
            int w = (int)((float)area.w * ((Float)BBSSettings.audioWaveformWidth.get()).floatValue());
            int x = area.x(0.5f, w);
            float tick = (float)this.panel.getCursor() + (runner.isRunning() ? context.getTransition() : 0.0f);
            this.clips.clear();
            for (Clip clip : ((Film)this.panel.getData()).camera.get()) {
                if (!(clip instanceof AudioClip)) continue;
                this.clips.add((AudioClip)clip);
            }
            AudioRenderer.renderAll(context.batcher, this.clips, tick, x, area.y + 10, w, (Integer)BBSSettings.audioWaveformHeight.get(), context.menu.width, context.menu.height);
        }
        Area a = this.icons.area;
        context.batcher.gradientVBox(a.x, a.y, a.ex(), a.ey(), 0, -2013265920);
        if (this.panel.isFlying()) {
            UIDashboardPanels.renderHighlight(context.batcher, this.flight.area);
        }
        if (this.panel.getController().isControlling()) {
            UIDashboardPanels.renderHighlight(context.batcher, this.control.area);
        }
        if (this.panel.getController().isRecording()) {
            UIDashboardPanels.renderHighlight(context.batcher, this.recordReplay.area);
        }
        if (this.panel.recorder.isRecording()) {
            UIDashboardPanels.renderHighlight(context.batcher, this.recordVideo.area);
        }
        if (((Boolean)this.panel.getController().getOnionSkin().enabled.get()).booleanValue()) {
            UIDashboardPanels.renderHighlight(context.batcher, this.onionSkin.area);
        }
        if (this.panel.getController().isControlling()) {
            String s = UIKeys.FILM_CONTROLLER_CONTROL_MODE_TOOLTIP.format(KeyCodes.getName(Keys.FILM_CONTROLLER_TOGGLE_CONTROL.getMainKey())).get();
            int w = context.batcher.getFont().getWidth(s);
            int height = context.batcher.getFont().getHeight();
            context.batcher.textCard(s, a.mx(w), a.y - height - 5);
        }
        context.batcher.clip(this.area, context);
        super.render(context);
        context.batcher.unclip(context);
    }

    private void renderCursor(UIContext context) {
        class_4184 mcCamera = class_310.method_1551().field_1773.method_19418();
        Matrix4fStack modelView = RenderSystem.getModelViewStack();
        modelView.pushMatrix();
        modelView.mul((Matrix4fc)context.batcher.getContext().method_51448().method_23760().method_23761());
        modelView.translate((float)(this.area.x + 16), (float)(this.area.ey() - 12), 0.0f);
        modelView.rotateX((float)Math.toRadians(-mcCamera.method_19329()));
        modelView.rotateY((float)Math.toRadians(mcCamera.method_19330()));
        modelView.scale(-1.0f, -1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.renderCrosshair((int)10);
        modelView.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }
}

