/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.controller;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.collection.IntObjectMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.actions.ActionState;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.controller.RunnerCameraController;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmControllerContext;
import mchorse.bbs_mod.film.Recorder;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.MCEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.ui.ValueOnionSkin;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.controller.FilmEditorController;
import mchorse.bbs_mod.ui.film.controller.OrbitFilmCameraController;
import mchorse.bbs_mod.ui.film.replays.UIRecordOverlayPanel;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeEditor;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.StencilFormFramebuffer;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyAction;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.PlayerUtils;
import mchorse.bbs_mod.utils.RayTracing;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class UIFilmController
extends UIElement {
    public static final int CAMERA_MODE_CAMERA = 0;
    public static final int CAMERA_MODE_FREE = 1;
    public static final int CAMERA_MODE_ORBIT = 2;
    public static final int CAMERA_MODE_FIRST_PERSON = 3;
    public static final int CAMERA_MODE_THIRD_PERSON_BACK = 4;
    public static final int CAMERA_MODE_THIRD_PERSON_FRONT = 5;
    public final UIFilmPanel panel;
    public FilmEditorController editorController;
    private Map<String, Integer> actors;
    private IEntity controlled;
    private final Vector2i lastMouse = new Vector2i();
    private int mouseMode;
    private final Vector2f mouseStick = new Vector2f();
    private IEntity previousEntity;
    private Form playerForm;
    private int recordingTick;
    private boolean recording;
    private int recordingCountdown;
    private List<String> recordingGroups;
    private BaseType recordingOld;
    private boolean instantKeyframes;
    private IEntity hoveredEntity;
    private StencilFormFramebuffer stencil = new StencilFormFramebuffer();
    private StencilMap stencilMap = new StencilMap();
    public final OrbitFilmCameraController orbit = new OrbitFilmCameraController(this);
    private int pov;
    private boolean paused;
    private WorldRenderContext worldRenderContext;

    public UIFilmController(UIFilmPanel panel) {
        this.panel = panel;
        IKey category = UIKeys.FILM_CONTROLLER_KEYS_CATEGORY;
        Supplier<Boolean> hasActor = () -> this.getCurrentEntity() != null;
        Supplier<Boolean> hasTwoOrMoreReplays = () -> this.panel.getData() != null && ((Film)this.panel.getData()).replays.getList().size() >= 2;
        this.keys().register(Keys.FILM_CONTROLLER_START_RECORDING, this::pickRecording).active(hasActor).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_INSERT_FRAME, () -> {
            this.insertFrame();
            UIUtils.playClick();
        }).active(hasActor).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_TOGGLE_CONTROL, this::toggleControl).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_TOGGLE_ORBIT_MODE, this::toggleOrbitMode).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_MOVE_REPLAY_TO_CURSOR, () -> {
            Area area = this.panel.preview.getViewport();
            UIContext context = this.getContext();
            class_638 world = class_310.method_1551().field_1687;
            Camera camera = this.panel.getCamera();
            class_3965 result = RayTracing.rayTrace((class_1937)world, RayTracing.fromVector3d(camera.position), RayTracing.fromVector3f(camera.getMouseDirection(context.mouseX, context.mouseY, area.x, area.y, area.w, area.h)), 512.0);
            if (result.method_17783() == class_239.class_240.field_1332) {
                this.panel.replayEditor.moveReplay(result.method_17784().field_1352, result.method_17784().field_1351, result.method_17784().field_1350);
            }
        }).active(hasActor).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_RESTART_ACTIONS, () -> {
            this.panel.notifyServer(ActionState.RESTART);
            this.createEntities();
        }).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_TOGGLE_ONION_SKIN, () -> {
            this.getOnionSkin().enabled.toggle();
            UIUtils.playClick();
        }).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_OPEN_REPLAYS, () -> this.panel.preview.openReplays()).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_PREV_REPLAY, () -> this.switchReplay(-1)).active(hasTwoOrMoreReplays).category(category);
        this.keys().register(Keys.FILM_CONTROLLER_NEXT_REPLAY, () -> this.switchReplay(1)).active(hasTwoOrMoreReplays).category(category);
        this.noCulling();
    }

    private void switchReplay(int direction) {
        List list = ((Film)this.panel.getData()).replays.getList();
        int index = list.indexOf(this.getReplay());
        int newIndex = MathUtils.cycler(index + direction, list);
        Replay replay = (Replay)list.get(newIndex);
        this.panel.replayEditor.setReplay(replay);
        UIUtils.playClick();
    }

    public boolean isInstantKeyframes() {
        return this.instantKeyframes;
    }

    public void toggleInstantKeyframes() {
        this.instantKeyframes = !this.instantKeyframes;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private void toggleMousePointer(boolean disable) {
        class_1041 window = class_310.method_1551().method_22683();
        if (disable) {
            GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212995);
        } else {
            GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212993);
        }
    }

    public ValueOnionSkin getOnionSkin() {
        return BBSSettings.editorOnionSkin;
    }

    private int getTick() {
        return this.panel.getCursor();
    }

    private Replay getReplay() {
        return (Replay)this.panel.replayEditor.replays.replays.getCurrentFirst();
    }

    public StencilFormFramebuffer getStencil() {
        return this.stencil;
    }

    public IEntity getCurrentEntity() {
        return (IEntity)this.getEntities().get(this.panel.replayEditor.replays.replays.getIndex());
    }

    public int getPovMode() {
        return this.pov % 6;
    }

    public void setPov(int pov) {
        this.pov = pov;
        this.orbit.enabled = this.getPovMode() > 1;
    }

    private int getMouseMode() {
        return this.mouseMode % 6;
    }

    private void setMouseMode(int mode) {
        int index;
        if (!ClientNetwork.isIsBBSModOnServer() && mode == 0) {
            mode = 1;
            this.getContext().notifyError(UIKeys.FILM_CONTROLLER_SERVER_WARNING);
        }
        this.mouseMode = mode;
        if (this.controlled != null && (index = this.getMouseMode() - 1) >= 0) {
            float[] variables = this.controlled.getExtraVariables();
            this.mouseStick.set(variables[index * 2 + 1], variables[index * 2]);
        }
    }

    private boolean isMouseLookMode() {
        return this.getMouseMode() == 0;
    }

    public void createEntities() {
        this.stopRecording();
        if (this.controlled != null) {
            this.toggleControl();
        }
        this.editorController = new FilmEditorController((Film)this.panel.getData(), this);
        this.editorController.createEntities();
        IntObjectMap<IEntity> entities = this.panel.getRunner().getContext().entities;
        entities.clear();
        entities.putAll(this.editorController.getEntities());
    }

    public IntObjectMap<IEntity> getEntities() {
        return this.editorController == null ? new IntObjectMap<IEntity>() : this.editorController.getEntities();
    }

    public Map<String, Integer> getActors() {
        return this.actors;
    }

    public void updateActors(Map<String, Integer> actors) {
        this.actors = actors;
    }

    public IEntity getControlled() {
        return this.controlled;
    }

    public boolean isControlling() {
        return this.controlled != null;
    }

    public void toggleControl() {
        this.getContext().unfocus();
        boolean replacePlayer = ClientNetwork.isIsBBSModOnServer();
        IntObjectMap<IEntity> entities = this.getEntities();
        if (this.controlled != null) {
            if (replacePlayer && this.previousEntity != null) {
                this.controlled.setForm(this.playerForm);
                entities.put((Object)((Integer)CollectionUtils.getKey(entities, this.controlled)), (Object)this.previousEntity);
                this.previousEntity = null;
            }
            this.controlled = null;
        } else if (this.panel.replayEditor.replays.replays.isSelected()) {
            this.controlled = this.getCurrentEntity();
            if (replacePlayer && this.controlled != null) {
                MCEntity player = Morph.getMorph((class_1297)class_310.method_1551().field_1724).entity;
                this.playerForm = player.getForm();
                this.previousEntity = this.controlled;
                player.copy(this.controlled);
                PlayerUtils.teleport(this.controlled.getX(), this.controlled.getY(), this.controlled.getZ(), this.controlled.getHeadYaw(), this.controlled.getBodyYaw(), this.controlled.getPitch());
                entities.put((Object)((Integer)CollectionUtils.getKey(entities, this.controlled)), (Object)player);
                this.controlled = player;
            }
        }
        this.setMouseMode(this.mouseMode);
        this.toggleMousePointer(this.controlled != null);
        if (this.controlled == null && this.recording) {
            this.stopRecording();
        }
    }

    private boolean canControl() {
        UIContext context = this.getContext();
        return this.controlled != null && context != null && !UIOverlay.has(context);
    }

    public boolean isPlaying() {
        boolean playing;
        boolean bl = playing = !UIOverlay.has(this.getContext()) && this.panel.isRunning();
        if (this.isPaused()) {
            playing = true;
        }
        return playing;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public int getRecordingCountdown() {
        return this.recordingCountdown;
    }

    public List<String> getRecordingGroups() {
        return this.recordingGroups;
    }

    public void startRecording(List<String> groups) {
        if (groups != null && groups.contains("outside")) {
            class_310.method_1551().method_1507(null);
            Replay replay = this.panel.replayEditor.getReplay();
            int index = ((Film)this.panel.getData()).replays.getList().indexOf(replay);
            if (index >= 0) {
                BBSModClient.getFilms().startRecording((Film)this.panel.getData(), index, this.panel.getCursor());
            }
            return;
        }
        this.recordingTick = this.getTick();
        this.recording = true;
        this.recordingCountdown = 30;
        this.recordingGroups = groups;
        this.recordingOld = this.getReplay().keyframes.toData();
        if (groups != null) {
            if (groups.contains("lstick")) {
                this.setMouseMode(1);
            } else if (groups.contains("rstick")) {
                this.setMouseMode(2);
            } else if (groups.contains("triggers")) {
                this.setMouseMode(3);
            } else if (groups.contains("extra1")) {
                this.setMouseMode(4);
            } else if (groups.contains("extra2")) {
                this.setMouseMode(5);
            } else {
                this.setMouseMode(0);
            }
        }
        if (this.controlled == null) {
            this.toggleControl();
        }
        this.toggleMousePointer(this.controlled != null);
    }

    public void stopRecording() {
        if (!this.recording) {
            return;
        }
        this.recording = false;
        this.recordingGroups = null;
        if (this.controlled != null) {
            this.toggleControl();
        }
        this.panel.setCursor(this.recordingTick);
        if (this.panel.getRunner().isRunning()) {
            this.panel.togglePlayback();
        }
        if (this.recordingCountdown > 0) {
            return;
        }
        Replay replay = this.getReplay();
        if (replay != null && this.recordingOld != null) {
            for (KeyframeChannel<?> channel : replay.keyframes.getChannels()) {
                channel.simplify();
            }
            BaseType newData = replay.keyframes.toData();
            replay.keyframes.fromData(this.recordingOld);
            replay.keyframes.preNotify();
            replay.keyframes.fromData(newData);
            replay.keyframes.postNotify();
            this.recordingOld = null;
        }
        this.setMouseMode(ClientNetwork.isIsBBSModOnServer() ? 0 : 1);
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        if (this.canControl()) {
            return true;
        }
        if (context.mouseButton == 0 && this.hoveredEntity != null) {
            this.pickEntity(this.hoveredEntity);
            return true;
        }
        return super.subMouseClicked(context);
    }

    private void pickEntity(IEntity entity) {
        int index = (Integer)CollectionUtils.getKey(this.getEntities(), entity);
        this.panel.replayEditor.setReplay((Replay)((Film)this.panel.getData()).replays.getList().get(index));
        if (!this.panel.replayEditor.isVisible()) {
            this.panel.showPanel(this.panel.replayEditor);
        }
    }

    @Override
    protected boolean subMouseReleased(UIContext context) {
        if (this.canControl()) {
            return true;
        }
        this.orbit.stop();
        return super.subMouseReleased(context);
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        if (this.canControl()) {
            if (this.isControlling() && context.isPressed(256)) {
                this.toggleControl();
                UIUtils.playClick();
                return true;
            }
            if (context.getKeyAction() == KeyAction.PRESSED && context.getKeyCode() >= 49 && context.getKeyCode() <= 54) {
                this.setMouseMode(context.getKeyCode() - 49);
                return true;
            }
            class_3675.class_306 utilKey = class_3675.method_15985((int)context.getKeyCode(), (int)context.getScanCode());
            if (this.canControlWithKeyboard(utilKey)) {
                return true;
            }
        }
        return super.subKeyPressed(context);
    }

    private boolean canControlWithKeyboard(class_3675.class_306 utilKey) {
        if (!ClientNetwork.isIsBBSModOnServer()) {
            return false;
        }
        class_315 options = class_310.method_1551().field_1690;
        return options.field_1894.method_1429() == utilKey || options.field_1881.method_1429() == utilKey || options.field_1913.method_1429() == utilKey || options.field_1849.method_1429() == utilKey || options.field_1832.method_1429() == utilKey || options.field_1867.method_1429() == utilKey || options.field_1903.method_1429() == utilKey;
    }

    public void pickRecording() {
        if (this.panel.replayEditor.getReplay() == null) {
            return;
        }
        if (this.recording) {
            this.stopRecording();
            return;
        }
        this.toggleMousePointer(false);
        UIRecordOverlayPanel panel = new UIRecordOverlayPanel(UIKeys.FILM_CONTROLLER_RECORD_TITLE, UIKeys.FILM_CONTROLLER_RECORD_DESCRIPTION, this::startRecording);
        UIIcon icon = new UIIcon(Icons.UPLOAD, b -> panel.submit(Arrays.asList("outside")));
        icon.tooltip(UIKeys.FILM_GROUPS_OUTSIDE);
        panel.bar.add((IUIElement)icon);
        panel.keys().register(Keys.RECORDING_GROUP_OUTSIDE, icon::clickItself);
        UIOverlay.addOverlay(this.getContext(), panel);
    }

    public Icon getOrbitModeIcon() {
        return this.getOrbitModeIcon(this.getPovMode());
    }

    public Icon getOrbitModeIcon(int povMode) {
        if (povMode == 1) {
            return Icons.REFRESH;
        }
        if (povMode == 2) {
            return Icons.ORBIT;
        }
        if (povMode == 3) {
            return Icons.VISIBLE;
        }
        if (povMode == 4) {
            return Icons.ARROW_UP;
        }
        if (povMode == 5) {
            return Icons.ARROW_DOWN;
        }
        return Icons.CAMERA;
    }

    public void toggleOrbitMode() {
        if (this.controlled != null) {
            this.setPov(this.pov + (Window.isShiftPressed() ? -1 : 1));
            return;
        }
        this.getContext().replaceContextMenu(menu -> {
            menu.autoKeys();
            menu.action(this.getOrbitModeIcon(0), UIKeys.FILM_REPLAY_ORBIT_CAMERA, this.pov == 0, () -> this.setPov(0));
            menu.action(this.getOrbitModeIcon(1), UIKeys.FILM_REPLAY_ORBIT_FREE, this.pov == 1, () -> this.setPov(1));
            menu.action(this.getOrbitModeIcon(2), UIKeys.FILM_REPLAY_ORBIT_ORBIT, this.pov == 2, () -> this.setPov(2));
            menu.action(this.getOrbitModeIcon(3), UIKeys.FILM_REPLAY_ORBIT_FIRST_PERSON, this.pov == 3, () -> this.setPov(3));
            menu.action(this.getOrbitModeIcon(4), UIKeys.FILM_REPLAY_ORBIT_THIRD_PERSON_BACK, this.pov == 4, () -> this.setPov(4));
            menu.action(this.getOrbitModeIcon(5), UIKeys.FILM_REPLAY_ORBIT_THIRD_PERSON_FRONT, this.pov == 5, () -> this.setPov(5));
        });
    }

    public void handleCamera(Camera camera, float transition) {
        if (this.orbit.enabled) {
            int mode = this.getPovMode();
            if (mode == 2) {
                this.orbit.setup(camera, transition);
                camera.fov = BBSSettings.getFov();
            } else if (mode != 1) {
                this.handleFirstThirdPerson(camera, transition, mode);
            }
        }
    }

    private void handleFirstThirdPerson(Camera camera, float transition, int mode) {
        IEntity controller = this.getCurrentEntity();
        if (controller == null) {
            return;
        }
        Vector3d position = new Vector3d();
        Vector3f rotation = new Vector3f();
        float distance = 5.0f;
        position.set(controller.getPrevX(), controller.getPrevY(), controller.getPrevZ());
        position.lerp((Vector3dc)new Vector3d(controller.getX(), controller.getY(), controller.getZ()), (double)transition);
        position.y += controller.getEyeHeight();
        rotation.set(controller.getPrevPitch(), controller.getPrevHeadYaw(), 0.0f);
        rotation.lerp((Vector3fc)new Vector3f(controller.getPitch(), controller.getHeadYaw(), 0.0f), transition);
        rotation.x = MathUtils.toRad(rotation.x);
        rotation.y = MathUtils.toRad(rotation.y);
        if (mode == 3) {
            camera.position.set((Vector3dc)position);
            camera.rotation.set(rotation.x, rotation.y + (float)Math.PI, 0.0f);
            camera.fov = BBSSettings.getFov();
            return;
        }
        boolean back = mode == 4;
        Vector3f rotate = Matrices.rotation(rotation.x * (float)(back ? 1 : -1), (back ? 0.0f : (float)Math.PI) - rotation.y);
        class_638 world = class_310.method_1551().field_1687;
        class_239 result = RayTracing.rayTraceEntity((class_1937)world, RayTracing.fromVector3d(position), RayTracing.fromVector3f(rotate), distance);
        if (result.method_17783() == class_239.class_240.field_1332) {
            distance = (float)position.distance(result.method_17784().field_1352, result.method_17784().field_1351, result.method_17784().field_1350) - 0.1f;
        }
        rotate.mul(distance);
        position.add((Vector3fc)rotate);
        camera.position.set((Vector3dc)position);
        camera.rotation.set(rotation.x * (float)(back ? -1 : 1), rotation.y + (back ? 0.0f : (float)Math.PI), 0.0f);
        camera.fov = BBSSettings.getFov();
    }

    public void insertFrame() {
        Replay replay = this.getReplay();
        if (replay == null) {
            return;
        }
        if (Window.isCtrlPressed()) {
            this.toggleMousePointer(false);
            UIRecordOverlayPanel panel = new UIRecordOverlayPanel(UIKeys.FILM_CONTROLLER_INSERT_FRAME_TITLE, UIKeys.FILM_CONTROLLER_INSERT_FRAME_DESCRIPTION, groups -> BaseValue.edit(replay.keyframes, keyframes -> keyframes.record(this.getTick(), this.getCurrentEntity(), (List<String>)groups)));
            panel.onClose(event -> this.toggleMousePointer(this.controlled != null));
            UIOverlay.addOverlay(this.getContext(), panel);
        } else {
            List<String> chosenGroups = Arrays.asList("position", "rotation");
            if (this.mouseMode == 1) {
                chosenGroups = Collections.singletonList("lstick");
            } else if (this.mouseMode == 2) {
                chosenGroups = Collections.singletonList("rstick");
            } else if (this.mouseMode == 3) {
                chosenGroups = Collections.singletonList("triggers");
            } else if (this.mouseMode == 4) {
                chosenGroups = Collections.singletonList("extra1");
            } else if (this.mouseMode == 5) {
                chosenGroups = Collections.singletonList("extra2");
            }
            List<String> groups2 = chosenGroups;
            BaseValue.edit(replay.keyframes, keyframes -> keyframes.record(this.getTick(), this.getCurrentEntity(), groups2));
        }
    }

    public void update() {
        Film film = (Film)this.panel.getData();
        if (film == null) {
            return;
        }
        RunnerCameraController runner = this.panel.getRunner();
        this.handleRecording(runner);
        if (this.editorController != null) {
            this.editorController.update();
        }
        if (this.canControl()) {
            this.updateControls();
        }
    }

    private void handleRecording(RunnerCameraController runner) {
        if (this.recording) {
            if (this.recordingCountdown > 0) {
                --this.recordingCountdown;
                if (this.recordingCountdown <= 0) {
                    this.panel.togglePlayback();
                }
            }
            if (this.recordingCountdown <= 0) {
                boolean stopped;
                boolean bl = stopped = !runner.isRunning();
                if (((Boolean)BBSSettings.editorLoop.get()).booleanValue()) {
                    Vector2i loop = this.panel.getLoopingRange();
                    int min = loop.x;
                    int max = loop.y;
                    int ticks = this.panel.getCursor();
                    if (min >= 0 && max >= 0 && min < max && (ticks >= max - 1 || ticks < min) || stopped) {
                        this.stopRecording();
                    }
                } else if (stopped) {
                    this.stopRecording();
                }
            }
        }
    }

    private void updateControls() {
        IEntity controller = this.controlled;
        if (!this.isMouseLookMode()) {
            int index = this.getMouseMode() - 1;
            float[] extraVariables = controller.getExtraVariables();
            extraVariables[index * 2] = this.mouseStick.y;
            extraVariables[index * 2 + 1] = this.mouseStick.x;
        }
        if (this.instantKeyframes) {
            this.insertFrame();
        }
    }

    public void renderHUD(UIContext context, Area area) {
        Replay replay;
        int y;
        FontRenderer font = context.batcher.getFont();
        int mode = this.getMouseMode();
        if (this.controlled != null) {
            if (mode > 0) {
                int ww;
                String label = UIKeys.FILM_GROUPS_LEFT_STICK.get();
                if (mode == 2) {
                    label = UIKeys.FILM_GROUPS_RIGHT_STICK.get();
                } else if (mode == 3) {
                    label = UIKeys.FILM_GROUPS_TRIGGERS.get();
                } else if (mode == 4) {
                    label = UIKeys.FILM_GROUPS_EXTRA_1.get();
                } else if (mode == 5) {
                    label = UIKeys.FILM_GROUPS_EXTRA_2.get();
                }
                context.batcher.textCard(label, area.x + 5, area.ey() - 5 - font.getHeight(), -1, BBSSettings.primaryColor(-16777216));
                int hh = ww = (int)((float)Math.min(area.w, area.h) * 0.75f);
                int x = area.x + (area.w - ww) / 2;
                int y2 = area.y + (area.h - hh) / 2;
                int color = Colors.setA(-1, 0.5f);
                context.batcher.outline(x, y2, x + ww, y2 + hh, color);
                int bx = area.x + area.w / 2 + (int)(this.mouseStick.y * (float)ww / 2.0f);
                int by = area.y + area.h / 2 + (int)(this.mouseStick.x * (float)hh / 2.0f);
                context.batcher.box(bx - 4, by - 4, bx + 4, by + 4, color);
            }
            if (this.recording) {
                int x = area.x + 5 + 16;
                y = area.y + 5;
                context.batcher.icon(Icons.SPHERE, -52429, x, y, 1.0f, 0.0f);
                if (this.recordingCountdown <= 0) {
                    context.batcher.textCard(UIKeys.FILM_CONTROLLER_TICKS.format(this.getTick()).get(), x + 3, y + 4, -1, -2013265920);
                } else {
                    context.batcher.textCard(String.valueOf((float)this.recordingCountdown / 20.0f), x + 3, y + 4, -1, -2013265920);
                }
            }
        }
        int x = area.ex() - 4;
        y = area.y + 5;
        if (this.panel.isFlying()) {
            String label = UIKeys.FILM_CONTROLLER_SPEED.format(this.panel.dashboard.orbit.speed.getValue()).get();
            int w = font.getWidth(label);
            context.batcher.textCard(label, x - w, y, -1, -2013265920);
            y += font.getHeight() + 7;
        }
        if ((replay = this.panel.replayEditor.getReplay()) != null) {
            String label = replay.getName();
            int w = font.getWidth(label);
            context.batcher.textCard(label, x - w, y, -1, -2013265920);
            Form form = (Form)replay.form.get();
            if (form != null) {
                context.batcher.clip(x -= w + 35, (y -= 5) - 10, 40, 40, context);
                FormUtilsClient.renderUI(form, context, x, y -= 10, x + 40, y + 40);
                context.batcher.unclip(context);
            }
        }
        this.renderPickingPreview(context, area);
        this.orbit.handleOrbiting(context);
    }

    private void renderPickingPreview(UIContext context, Area area) {
        if (this.panel.isFlying() || this.worldRenderContext == null) {
            return;
        }
        boolean altPressed = Window.isAltPressed();
        RenderSystem.depthFunc((int)513);
        MatrixStackUtils.cacheMatrices();
        RenderSystem.setProjectionMatrix((Matrix4f)this.panel.lastProjection, (class_8251)class_8251.field_43361);
        class_4587 worldStack = this.worldRenderContext.matrixStack();
        worldStack.method_22903();
        worldStack.method_34426();
        MatrixStackUtils.multiply(worldStack, this.panel.lastView);
        this.renderStencil(this.worldRenderContext, this.getContext(), altPressed);
        worldStack.method_22909();
        MatrixStackUtils.restoreMatrices();
        RenderSystem.depthFunc((int)519);
        this.hoveredEntity = null;
        if (!this.stencil.hasPicked()) {
            return;
        }
        int index = this.stencil.getIndex();
        Texture texture = this.stencil.getFramebuffer().getMainTexture();
        Pair<Form, String> pair = this.stencil.getPicked();
        int w = texture.width;
        int h = texture.height;
        class_5944 previewProgram = BBSShaders.getPickerPreviewProgram();
        Supplier<class_5944> getPickerPreviewProgram = BBSShaders::getPickerPreviewProgram;
        class_284 target = previewProgram.method_34582("Target");
        if (target != null) {
            target.method_35649(index);
        }
        RenderSystem.enableBlend();
        context.batcher.texturedBox(getPickerPreviewProgram, texture.id, -1, area.x, area.y, area.w, area.h, 0.0f, h, w, 0.0f, w, h);
        if (altPressed) {
            int stencilIndex = this.stencil.getIndex() - 1;
            this.hoveredEntity = (IEntity)this.getEntities().get(stencilIndex);
            if (this.hoveredEntity != null) {
                String label = ((Replay)((Film)this.panel.getData()).replays.getList().get(stencilIndex)).getName();
                context.batcher.textCard(label, context.mouseX + 12, context.mouseY + 8);
            }
        } else if (pair != null) {
            Object label = ((Form)pair.a).getFormIdOrName();
            if (!((String)pair.b).isEmpty()) {
                label = (String)label + " - " + (String)pair.b;
            }
            context.batcher.textCard((String)label, context.mouseX + 12, context.mouseY + 8);
        }
    }

    public void startRenderFrame(float tickDelta) {
        if (this.editorController != null) {
            this.editorController.startRenderFrame(tickDelta);
        }
    }

    public void renderFrame(WorldRenderContext context) {
        this.worldRenderContext = context;
        RenderSystem.enableDepthTest();
        if (this.editorController != null) {
            this.editorController.render(context);
            int povMode = this.panel.getController().getPovMode();
            if (povMode != 0) {
                Recorder.renderCameraPreview(this.panel.getRunner().getPosition(), context.camera(), context.matrixStack());
            }
        }
        class_312 mouse = class_310.method_1551().field_1729;
        int x = (int)mouse.method_1603();
        int y = (int)mouse.method_1604();
        if (this.canControl()) {
            if (this.isMouseLookMode() && ClientNetwork.isIsBBSModOnServer()) {
                float cursorDeltaX = (float)(x - this.lastMouse.x) / 2.0f;
                float cursorDeltaY = (float)(y - this.lastMouse.y) / 2.0f;
                class_310.method_1551().field_1724.method_5872((double)cursorDeltaX, (double)cursorDeltaY);
            } else {
                float sensitivity = 100.0f;
                float xx = (float)(y - this.lastMouse.y) / sensitivity;
                float yy = (float)(x - this.lastMouse.x) / sensitivity;
                this.mouseStick.add(xx, yy);
                this.mouseStick.x = MathUtils.clamp(this.mouseStick.x, -1.0f, 1.0f);
                this.mouseStick.y = MathUtils.clamp(this.mouseStick.y, -1.0f, 1.0f);
            }
        }
        this.lastMouse.set(x, y);
        RenderSystem.disableDepthTest();
    }

    public Pair<String, Boolean> getBone() {
        UIKeyframeEditor keyframeEditor = this.panel.replayEditor.keyframeEditor;
        return keyframeEditor != null ? keyframeEditor.getBone() : null;
    }

    private void renderStencil(WorldRenderContext renderContext, UIContext context, boolean altPressed) {
        Area viewport = this.panel.preview.getViewport();
        if (!viewport.isInside(context) || this.controlled != null) {
            this.stencil.clearPicking();
            return;
        }
        IEntity entity = this.getCurrentEntity();
        if (entity == null || this.pov == 3 && entity == this.getCurrentEntity()) {
            return;
        }
        this.ensureStencilFramebuffer();
        boolean isPlaying = this.isPlaying();
        Texture mainTexture = this.stencil.getFramebuffer().getMainTexture();
        this.stencilMap.setup();
        this.stencilMap.setIncrement(!altPressed);
        this.stencil.apply();
        if (altPressed) {
            for (Map.Entry entry : this.getEntities().entrySet()) {
                this.stencilMap.objectIndex = (Integer)entry.getKey() + 1;
                Replay replay = (Replay)CollectionUtils.getSafe(((Film)this.panel.getData()).replays.getList(), (Integer)entry.getKey());
                BaseFilmController.renderEntity(FilmControllerContext.instance.setup(this.getEntities(), (IEntity)entry.getValue(), replay, renderContext).transition(isPlaying ? class_310.method_1551().method_60646().method_60637(true) : 0.0f).stencil(this.stencilMap).relative((Boolean)replay.relative.get()));
            }
        } else {
            Replay replay = (Replay)CollectionUtils.getSafe(((Film)this.panel.getData()).replays.getList(), this.panel.replayEditor.replays.replays.getIndex());
            BaseFilmController.renderEntity(FilmControllerContext.instance.setup(this.getEntities(), entity, replay, renderContext).transition(isPlaying ? class_310.method_1551().method_60646().method_60637(true) : 0.0f).stencil(this.stencilMap).relative((Boolean)replay.relative.get()));
        }
        int x = (int)((float)(context.mouseX - viewport.x) / (float)viewport.w * (float)mainTexture.width);
        int y = (int)((1.0f - (float)(context.mouseY - viewport.y) / (float)viewport.h) * (float)mainTexture.height);
        this.stencil.pick(x, y);
        this.stencil.unbind(this.stencilMap);
        class_310.method_1551().method_1522().method_1235(true);
    }

    private void ensureStencilFramebuffer() {
        this.stencil.setup(Link.bbs("stencil_film"));
        Texture mainTexture = this.stencil.getFramebuffer().getMainTexture();
        int w = BBSRendering.getVideoWidth();
        int h = BBSRendering.getVideoHeight();
        if (mainTexture.width != w || mainTexture.height != h) {
            this.stencil.resizeGUI(w, h);
        }
    }
}

