/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.elements.events.UIEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class EventManager {
    protected Map<Class, List<Consumer>> events = new HashMap<Class, List<Consumer>>();

    public <T extends UIEvent> void register(Class<T> event, Consumer<T> callback) {
        if (callback == null) {
            return;
        }
        List events = this.events.computeIfAbsent(event, k -> new ArrayList());
        events.add(callback);
    }

    public void emit(UIEvent event) {
        List<Consumer> events = this.events.get(event.getClass());
        if (events != null) {
            for (Consumer callback : events) {
                callback.accept(event);
            }
        }
    }

    public void remove(Class event) {
        this.events.remove(event);
    }
}

