/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.graphics.line.LineBuilder;
import mchorse.bbs_mod.graphics.line.SolidColorLineRenderer;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.IUIKeyframeGraph;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.KeyframeType;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.Scale;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class UIKeyframeGraph
implements IUIKeyframeGraph {
    private UIKeyframes keyframes;
    private UIKeyframeSheet sheet;
    private final Scale yAxis;

    public UIKeyframeGraph(UIKeyframes keyframes, UIKeyframeSheet sheet) {
        this.keyframes = keyframes;
        this.sheet = sheet;
        this.yAxis = new Scale(this.keyframes.area, ScrollDirection.VERTICAL).inverse();
    }

    public int toGraphY(double value) {
        return (int)this.yAxis.to(value);
    }

    public double fromGraphY(int mouseY) {
        return this.yAxis.from(mouseY);
    }

    private boolean isNear(double x, double y, int mouseX, int mouseY) {
        return Math.pow((double)mouseX - x, 2.0) + Math.pow((double)mouseY - y, 2.0) < 25.0;
    }

    public void resetViewY(UIKeyframeSheet current) {
        this.yAxis.set(0.0, 2.0);
        KeyframeChannel channel = current.channel;
        List keyframes = channel.getKeyframes();
        int c = keyframes.size();
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        if (c > 1) {
            for (int i = 0; i < c; ++i) {
                Keyframe frame = keyframes.get(i);
                minY = Math.min(minY, frame.getY(i));
                maxY = Math.max(maxY, frame.getY(i));
            }
        } else {
            minY = -10.0;
            maxY = 10.0;
            if (c == 1) {
                minY = maxY = channel.get(0).getY(0);
            }
        }
        if (Math.abs(maxY - minY) < (double)0.01f) {
            this.yAxis.setShift(minY);
            this.yAxis.anchor(0.5f);
        } else {
            this.yAxis.viewOffset(minY, maxY, this.keyframes.area.h, 30.0);
        }
    }

    @Override
    public void resetView() {
        this.keyframes.resetViewX();
        this.resetViewY(this.sheet);
    }

    @Override
    public List<UIKeyframeSheet> getSheets() {
        return Collections.singletonList(this.sheet);
    }

    @Override
    public void selectByX(int mouseX) {
        List keyframes = this.sheet.channel.getKeyframes();
        for (int i = 0; i < keyframes.size(); ++i) {
            int y;
            Keyframe keyframe = keyframes.get(i);
            int x = this.keyframes.toGraphX(keyframe.getTick());
            if (!this.isNear(x, y = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue())), mouseX, 0)) continue;
            this.sheet.selection.add(i);
        }
        this.pickSelected();
    }

    @Override
    public void selectInArea(Area area) {
        List keyframes = this.sheet.channel.getKeyframes();
        for (int i = 0; i < keyframes.size(); ++i) {
            int y;
            Keyframe keyframe = keyframes.get(i);
            int x = this.keyframes.toGraphX(keyframe.getTick());
            if (!area.isInside(x, y = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue())))) continue;
            this.sheet.selection.add(i);
        }
        this.pickSelected();
    }

    @Override
    public UIKeyframeSheet getSheet(int mouseY) {
        return this.sheet;
    }

    @Override
    public boolean addKeyframe(int mouseX, int mouseY) {
        float tick = (float)this.keyframes.fromGraphX(mouseX);
        UIKeyframeSheet sheet = this.sheet;
        if (!Window.isShiftPressed()) {
            tick = Math.round(tick);
        }
        if (sheet != null) {
            this.addKeyframe(sheet, tick, sheet.channel.getFactory().yToValue(this.fromGraphY(mouseY)));
        }
        return sheet != null;
    }

    @Override
    public Pair<Keyframe, KeyframeType> findKeyframe(int mouseX, int mouseY) {
        List keyframes = this.sheet.channel.getKeyframes();
        for (int i = 0; i < keyframes.size(); ++i) {
            int ry;
            int ly;
            int y;
            Keyframe keyframe = keyframes.get(i);
            int x = this.keyframes.toGraphX(keyframe.getTick());
            if (this.isNear(x, y = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue())), mouseX, mouseY)) {
                return new Pair<Keyframe, KeyframeType>(keyframe, KeyframeType.REGULAR);
            }
            int lx = this.keyframes.toGraphX(keyframe.getTick() - keyframe.lx);
            if (this.isNear(lx, ly = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue()) + (double)keyframe.ly), mouseX, mouseY)) {
                return new Pair<Keyframe, KeyframeType>(keyframe, KeyframeType.LEFT_HANDLE);
            }
            int rx = this.keyframes.toGraphX(keyframe.getTick() + keyframe.rx);
            if (!this.isNear(rx, ry = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue()) + (double)keyframe.ry), mouseX, mouseY)) continue;
            return new Pair<Keyframe, KeyframeType>(keyframe, KeyframeType.RIGHT_HANDLE);
        }
        return null;
    }

    @Override
    public void pickKeyframe(Keyframe keyframe) {
        this.keyframes.pickKeyframe(keyframe);
    }

    @Override
    public void selectKeyframe(Keyframe keyframe) {
        this.clearSelection();
        UIKeyframeSheet sheet = this.getSheet(keyframe);
        if (sheet != null) {
            sheet.selection.add(keyframe);
            this.pickKeyframe(keyframe);
            double x = keyframe.getTick();
            int y = this.toGraphY(keyframe.getFactory().getY(keyframe.getValue()));
            this.keyframes.getXAxis().shiftIntoMiddle(x);
            this.yAxis.shiftIntoMiddle(y);
        }
    }

    @Override
    public void resize() {
    }

    @Override
    public boolean mouseClicked(UIContext context) {
        return false;
    }

    @Override
    public void mouseReleased(UIContext context) {
    }

    @Override
    public void mouseScrolled(UIContext context) {
        if (context.mouseWheelHorizontal != 0.0) {
            double offsetX = (double)(25.0f * ((Float)BBSSettings.scrollingSensitivityHorizontal.get()).floatValue()) * context.mouseWheelHorizontal / this.keyframes.getXAxis().getZoom();
            this.keyframes.getXAxis().setShift(this.keyframes.getXAxis().getShift() - offsetX);
        } else {
            boolean none;
            boolean x = Window.isShiftPressed();
            boolean y = Window.isCtrlPressed();
            boolean bl = none = !x && !y;
            if ((x && !y || none) && context.mouseWheel != 0.0) {
                this.keyframes.getXAxis().zoomAnchor(Scale.getAnchorX(context, this.keyframes.area), Math.copySign(this.keyframes.getXAxis().getZoomFactor(), context.mouseWheel));
            }
            if ((y && !x || none) && context.mouseWheel != 0.0) {
                this.yAxis.zoomAnchor(Scale.getAnchorY(context, this.keyframes.area), Math.copySign(this.yAxis.getZoomFactor(), context.mouseWheel));
            }
        }
    }

    @Override
    public void handleMouse(UIContext context, int lastX, int lastY) {
        if (this.keyframes.isNavigating()) {
            int mouseX = context.mouseX;
            int mouseY = context.mouseY;
            double offsetX = (double)(mouseX - lastX) / this.keyframes.getXAxis().getZoom();
            double offsetY = (double)(-(mouseY - lastY)) / this.yAxis.getZoom();
            this.keyframes.getXAxis().setShift(this.keyframes.getXAxis().getShift() - offsetX);
            this.yAxis.setShift(this.yAxis.getShift() - offsetY);
        }
    }

    @Override
    public void dragKeyframes(UIContext context, Pair<Keyframe, KeyframeType> type, int originalX, int originalY, float originalT, Object originalV) {
        if (type == null) {
            return;
        }
        IKeyframeFactory<Object> factory = this.sheet.channel.getFactory();
        Keyframe keyframe = (Keyframe)type.a;
        if (type.b == KeyframeType.REGULAR) {
            float offsetX = (float)this.keyframes.fromGraphX(originalX) - originalT;
            double offsetY = this.fromGraphY(originalY) - factory.getY(originalV);
            float fx = (float)this.keyframes.fromGraphX(context.mouseX) - offsetX;
            Object fy = factory.yToValue(this.fromGraphY(context.mouseY) - offsetY);
            if (!Window.isShiftPressed()) {
                fx = Math.round(this.keyframes.fromGraphX(context.mouseX) - (double)offsetX);
            }
            this.setTick(fx, false);
            this.setValue(fy, false);
        } else if (type.b == KeyframeType.LEFT_HANDLE) {
            keyframe.lx = -((float)(this.keyframes.fromGraphX(context.mouseX) - (double)keyframe.getTick()));
            keyframe.ly = (float)(this.fromGraphY(context.mouseY) - factory.getY(originalV));
            if (!Window.isShiftPressed()) {
                keyframe.rx = keyframe.lx;
                keyframe.ry = -keyframe.ly;
            }
        } else if (type.b == KeyframeType.RIGHT_HANDLE) {
            keyframe.rx = (float)(this.keyframes.fromGraphX(context.mouseX) - (double)keyframe.getTick());
            keyframe.ry = (float)(this.fromGraphY(context.mouseY) - factory.getY(originalV));
            if (!Window.isShiftPressed()) {
                keyframe.lx = keyframe.rx;
                keyframe.ly = -keyframe.ry;
            }
        }
        this.keyframes.triggerChange();
    }

    @Override
    public void render(UIContext context) {
        this.renderGrid(context);
        this.renderGraph(context);
    }

    protected void renderGrid(UIContext context) {
        block10: {
            float currentTick;
            block11: {
                block9: {
                    int x;
                    Area area = this.keyframes.area;
                    int mult = this.keyframes.getXAxis().getMult();
                    int hx = this.keyframes.getDuration() / mult;
                    int ht = (int)this.keyframes.fromGraphX(area.x);
                    for (int j = Math.max(ht / mult, 0); j <= hx && (x = this.keyframes.toGraphX(j * mult)) < area.ex(); ++j) {
                        String label = this.keyframes.getConverter() == null ? String.valueOf(j * mult) : this.keyframes.getConverter().format(j * mult);
                        context.batcher.box(x, area.y, x + 1, area.ey(), Colors.setA(-1, 0.25f));
                        context.batcher.text(label, x + 4, area.y + 4);
                    }
                    int ty = (int)this.fromGraphY(area.ey());
                    int by = (int)this.fromGraphY(area.y - 12);
                    int min = Math.min(ty, by) - 1;
                    int max = Math.max(ty, by) + 1;
                    mult = this.yAxis.getMult();
                    min -= min % mult + mult;
                    max -= max % mult - mult;
                    int c = (max - min) / mult;
                    for (int j = 0; j < c; ++j) {
                        int y = this.toGraphY(min + j * mult);
                        if (y > area.ey()) continue;
                        context.batcher.box(area.x, y, area.ex(), y + 1, Colors.setA(-1, 0.25f));
                        context.batcher.text(String.valueOf(min + j * mult), area.x + 4, y + 4);
                    }
                    if (!area.isInside(context)) {
                        return;
                    }
                    currentTick = (float)this.keyframes.fromGraphX(context.mouseX);
                    if (!this.keyframes.isStacking()) break block9;
                    UIKeyframeSheet current = this.sheet;
                    List<Keyframe> selected = current.selection.getSelected();
                    IKeyframeFactory factory = current.channel.getFactory();
                    float mMin = 2.1474836E9f;
                    float mMax = -2.1474836E9f;
                    for (Keyframe keyframe : selected) {
                        mMin = Math.min(keyframe.getTick(), mMin);
                        mMax = Math.max(keyframe.getTick(), mMax);
                    }
                    float length = mMax - mMin + this.keyframes.getStackOffset();
                    int times = (int)Math.max(1.0, Math.ceil((currentTick - mMax) / length));
                    float x2 = 0.0f;
                    for (int i = 0; i < times; ++i) {
                        for (Keyframe keyframe : selected) {
                            int y = (int)this.yAxis.to(factory.getY(keyframe.getValue()));
                            float tick = mMax + this.keyframes.getStackOffset() + (keyframe.getTick() - mMin) + x2;
                            this.renderPreviewKeyframe(context, current, tick, y, 0xFFFF33);
                        }
                        x2 += length;
                    }
                    break block10;
                }
                if (!Window.isCtrlPressed()) break block11;
                UIKeyframeSheet sheet = this.getSheet(context.mouseY);
                if (sheet == null) break block10;
                float tick = currentTick;
                if (!Window.isShiftPressed()) {
                    tick = Math.round(tick);
                }
                this.renderPreviewKeyframe(context, sheet, tick, context.mouseY, -1);
                break block10;
            }
            if (Window.isAltPressed()) {
                UIKeyframeSheet current = this.sheet;
                List<Keyframe> selected = current.selection.getSelected();
                IKeyframeFactory factory = current.channel.getFactory();
                for (int i = 0; i < selected.size(); ++i) {
                    Keyframe first = selected.get(0);
                    Keyframe keyframe = selected.get(i);
                    int y = (int)this.yAxis.to(factory.getY(keyframe.getValue()));
                    this.renderPreviewKeyframe(context, current, currentTick + (keyframe.getTick() - first.getTick()), y, 0xFFFF33);
                }
            }
        }
    }

    private void renderPreviewKeyframe(UIContext context, UIKeyframeSheet sheet, double tick, int y, int color) {
        int x = this.keyframes.toGraphX(tick);
        float a = (float)Math.sin((double)context.getTickTransition() / 2.0) * 0.1f + 0.5f;
        context.batcher.box(x - 3, y - 3, x + 3, y + 3, Colors.setA(color, a));
    }

    protected void renderGraph(UIContext context) {
        Matrix4f matrix = context.batcher.getContext().method_51448().method_23760().method_23761();
        UIKeyframeSheet sheet = this.sheet;
        List keyframes = sheet.channel.getKeyframes();
        KeyframeSegment segment = new KeyframeSegment();
        LineBuilder lineBuilder = new LineBuilder(0.7f);
        for (int i = 0; i < keyframes.size(); ++i) {
            Keyframe frame = keyframes.get(i);
            Keyframe prev = i > 0 ? keyframes.get(i - 1) : null;
            int x = this.keyframes.toGraphX(frame.getTick());
            int y = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()));
            if (i == 0 && x > this.keyframes.area.x) {
                lineBuilder.add(this.keyframes.area.x, y);
            }
            if (prev != null) {
                IInterp interp = prev.getInterpolation().getInterp();
                int px = this.keyframes.toGraphX(prev.getTick());
                int py = this.toGraphY(sheet.channel.getFactory().getY(prev.getValue()));
                if (interp == Interpolations.CONST) {
                    lineBuilder.add(x, py);
                    lineBuilder.push();
                } else if (interp != Interpolations.LINEAR) {
                    float steps = 50.0f;
                    int j = 1;
                    while ((float)j <= steps) {
                        float a = (float)j / steps;
                        segment.setup(prev, frame, prev.getTick() + a * (frame.getTick() - prev.getTick()));
                        float interpolate = this.toGraphY((float)frame.getFactory().getY(segment.createInterpolated()));
                        lineBuilder.add(Lerps.lerp(px, x, a), interpolate);
                        ++j;
                    }
                }
            }
            lineBuilder.add(x, y);
            if (i == keyframes.size() - 1 && x < this.keyframes.area.ex()) {
                lineBuilder.add(this.keyframes.area.ex(), y);
            }
            boolean add = false;
            if (frame.getInterpolation().getInterp() == Interpolations.BEZIER) {
                int rx = this.keyframes.toGraphX(frame.getTick() + frame.rx);
                int ry = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ry);
                lineBuilder.push();
                lineBuilder.add(x, y);
                lineBuilder.add(rx, ry);
                add = true;
            }
            if (prev != null && prev.getInterpolation().getInterp() == Interpolations.BEZIER) {
                int lx = this.keyframes.toGraphX(frame.getTick() - frame.lx);
                int ly = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ly);
                lineBuilder.push();
                lineBuilder.add(x, y);
                lineBuilder.add(lx, ly);
                add = true;
            }
            if (!add) continue;
            lineBuilder.push();
            lineBuilder.add(x, y);
        }
        lineBuilder.render(context.batcher, SolidColorLineRenderer.get(Colors.COLOR.set(Colors.setA(sheet.color, 1.0f))));
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        int forcedIndex = 0;
        for (int i = 0; i < keyframes.size(); ++i) {
            boolean toRemove;
            Keyframe frame = keyframes.get(i);
            Keyframe prev = i > 0 ? keyframes.get(i - 1) : null;
            float tick = frame.getTick();
            int x1 = this.keyframes.toGraphX(tick);
            int x2 = this.keyframes.toGraphX(tick + frame.getDuration());
            int y = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()));
            if (x1 != x2) {
                int y1 = y - 8 + (forcedIndex % 2 == 1 ? -4 : 0);
                int color = sheet.selection.has(i) ? -1 : Colors.setA(Colors.mulRGB(sheet.color, 0.9f), 0.75f);
                context.batcher.fillRect(builder, matrix, x1, y1 - 2, 1.0f, 5.0f, color, color, color, color);
                context.batcher.fillRect(builder, matrix, x2, y1 - 2, 1.0f, 5.0f, color, color, color, color);
                context.batcher.fillRect(builder, matrix, x1 + 1, y1, x2 - x1, 1.0f, color, color, color, color);
                ++forcedIndex;
            }
            boolean isPointHover = this.isNear(this.keyframes.toGraphX(frame.getTick()), y, context.mouseX, context.mouseY);
            boolean bl = toRemove = Window.isCtrlPressed() && isPointHover;
            if (this.keyframes.isSelecting()) {
                isPointHover = isPointHover || this.keyframes.getGrabbingArea(context).isInside(x1, y);
            }
            int c = (sheet.selection.has(i) || isPointHover ? -1 : sheet.color) | 0xFF000000;
            if (toRemove) {
                c = -52429;
            }
            this.renderSquare(context, builder, matrix, x1, y, toRemove ? 4 : 3, c);
            if (frame.getInterpolation().getInterp() == Interpolations.BEZIER) {
                int rx = this.keyframes.toGraphX(frame.getTick() + frame.rx);
                int ry = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ry);
                this.renderSquare(context, builder, matrix, rx, ry, 3, c);
            }
            if (prev == null || prev.getInterpolation().getInterp() != Interpolations.BEZIER) continue;
            int lx = this.keyframes.toGraphX(frame.getTick() - frame.lx);
            int ly = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ly);
            this.renderSquare(context, builder, matrix, lx, ly, 3, c);
        }
        for (int j = 0; j < keyframes.size(); ++j) {
            Keyframe frame = keyframes.get(j);
            Keyframe prev = j > 0 ? keyframes.get(j - 1) : null;
            int y = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()));
            Color keyframeColor = frame.getColor();
            int kc = keyframeColor != null ? keyframeColor.getRGBColor() : 0;
            int c = sheet.selection.has(j) ? 35071 : 0;
            this.renderSquare(context, builder, matrix, this.keyframes.toGraphX(frame.getTick()), y, 2, kc | c | 0xFF000000);
            if (frame.getInterpolation().getInterp() == Interpolations.BEZIER) {
                int rx = this.keyframes.toGraphX(frame.getTick() + frame.rx);
                int ry = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ry);
                this.renderSquare(context, builder, matrix, rx, ry, 2, c | 0xFF000000);
            }
            if (prev == null || prev.getInterpolation().getInterp() != Interpolations.BEZIER) continue;
            int lx = this.keyframes.toGraphX(frame.getTick() - frame.lx);
            int ly = this.toGraphY(sheet.channel.getFactory().getY(frame.getValue()) + (double)frame.ly);
            this.renderSquare(context, builder, matrix, lx, ly, 2, c | 0xFF000000);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    protected void renderSquare(UIContext context, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        context.batcher.fillRect(builder, matrix, x - offset, y - offset, offset * 2, offset * 2, c, c, c, c);
    }

    @Override
    public void postRender(UIContext context) {
    }

    @Override
    public void saveState(MapType extra) {
        extra.putDouble("y_min", this.yAxis.getMinValue());
        extra.putDouble("y_max", this.yAxis.getMaxValue());
    }

    @Override
    public void restoreState(MapType extra) {
        this.yAxis.view(extra.getDouble("y_min"), extra.getDouble("y_max"));
    }
}

