/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.overlay;

import java.util.Collection;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.input.list.UILabelList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UISearchList;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.Label;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UILabelOverlayPanel<T>
extends UIOverlayPanel {
    public UISearchList<Label<T>> labels;
    private Consumer<Label<T>> callback;

    public UILabelOverlayPanel(IKey title, Collection<Label<T>> keys, Consumer<Label<T>> callback) {
        super(title);
        this.callback = callback;
        this.labels = new UISearchList(new UILabelList(list -> this.accept((Label)list.get(0))));
        this.labels.label(UIKeys.GENERAL_SEARCH);
        this.labels.full(this.content).x(6).w(1.0f, -12);
        for (Label<T> location : keys) {
            this.labels.list.add(location);
        }
        this.labels.list.sort();
        this.labels.list.update();
        this.labels.list.scroll.scrollSpeed *= 3;
        this.content.add((IUIElement)this.labels);
    }

    public UILabelOverlayPanel<T> set(T value) {
        this.labels.filter("", true);
        for (Label label : this.labels.list.getList()) {
            if (!label.value.equals(value)) continue;
            this.labels.list.setCurrentScroll(label);
            break;
        }
        return this;
    }

    private void accept(Label<T> label) {
        if (this.callback != null) {
            this.callback.accept(label);
        }
    }
}

