/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.utils;

import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.utils.Scale;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UICanvas
extends UIElement {
    public Scale scaleX;
    public Scale scaleY;
    public boolean dragging;
    public int mouse;
    protected int lastX;
    protected int lastY;
    protected double lastT;
    protected double lastV;

    public UICanvas() {
        this.scaleX = new Scale(this.area);
        this.scaleX.anchor(0.5f);
        this.scaleY = new Scale(this.area, ScrollDirection.VERTICAL);
        this.scaleY.anchor(0.5f);
    }

    public int toX(double x) {
        return (int)Math.round(this.scaleX.to(x));
    }

    public double fromX(int mouseX) {
        return this.scaleX.from(mouseX);
    }

    public int toY(double y) {
        return (int)Math.round(this.scaleY.to(y));
    }

    public double fromY(int mouseY) {
        return this.scaleY.from(mouseY);
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context) && this.isMouseButtonAllowed(context.mouseButton)) {
            this.dragging = true;
            this.mouse = context.mouseButton;
            this.lastX = context.mouseX;
            this.lastY = context.mouseY;
            if (this.mouse == 0 && Window.isCtrlPressed()) {
                this.mouse = 2;
            }
            this.startDragging(context);
            return true;
        }
        return super.subMouseClicked(context);
    }

    protected boolean isMouseButtonAllowed(int mouseButton) {
        return mouseButton == 0 || mouseButton == 2;
    }

    protected void startDragging(UIContext context) {
        this.lastT = this.scaleX.getShift();
        this.lastV = this.scaleY.getShift();
    }

    @Override
    public boolean subMouseScrolled(UIContext context) {
        if (this.area.isInside(context.mouseX, context.mouseY) && !this.dragging) {
            this.zoom(context, (int)context.mouseWheel);
        }
        return super.subMouseScrolled(context);
    }

    protected void zoom(UIContext context, int scroll) {
        if ((double)scroll != 0.0) {
            this.scaleX.zoomAnchor(Scale.getAnchorX(context, this.area), Math.copySign(this.scaleX.getZoomFactor(), (double)scroll));
            this.scaleY.zoomAnchor(Scale.getAnchorY(context, this.area), Math.copySign(this.scaleY.getZoomFactor(), (double)scroll));
        }
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        this.dragging = false;
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        this.dragging(context);
        context.batcher.clip(this.area, context);
        this.renderCanvas(context);
        context.batcher.unclip(context);
        super.render(context);
    }

    protected void dragging(UIContext context) {
        if (this.dragging && this.mouse == 2) {
            float y = this.scaleY.inverse ? 1.0f : -1.0f;
            this.scaleX.setShift((double)(-(context.mouseX - this.lastX)) / this.scaleX.getZoom() + this.lastT);
            this.scaleY.setShift((double)(y * (float)(context.mouseY - this.lastY)) / this.scaleY.getZoom() + this.lastV);
        }
    }

    protected void renderCanvas(UIContext context) {
    }
}

