/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.notifications;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Notification {
    public static final int TOTAL_LENGTH = 80;
    public IKey message;
    public int background;
    public int color;
    public int tick;

    public Notification(IKey message, int background, int color) {
        this.message = message;
        this.background = background | 0xFF000000;
        this.color = color | 0xFF000000;
        this.tick = 80;
    }

    public boolean isExpired() {
        return this.tick <= 0;
    }

    public float getFactor(float transition) {
        float envelope = Lerps.envelope((float)this.tick - transition, 0.0f, 20.0f, 70.0f, 80.0f);
        return Interpolations.QUAD_INOUT.interpolate(0.0f, 1.0f, envelope);
    }

    public void update() {
        --this.tick;
    }
}

