/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.Scroll;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public enum ScrollDirection {
    VERTICAL{

        @Override
        public int getPosition(Area area, float x) {
            return area.y(x);
        }

        @Override
        public int getSide(Area area) {
            return area.h;
        }

        @Override
        public int getScroll(Area area, Scroll scroll, int x, int y) {
            return y - area.y + (int)scroll.getScroll();
        }

        @Override
        public float getMouse(int x, int y) {
            return y;
        }
    }
    ,
    HORIZONTAL{

        @Override
        public int getPosition(Area area, float x) {
            return area.x(x);
        }

        @Override
        public int getSide(Area area) {
            return area.w;
        }

        @Override
        public int getScroll(Area area, Scroll scroll, int x, int y) {
            return x - area.x + (int)scroll.getScroll();
        }

        @Override
        public float getMouse(int x, int y) {
            return x;
        }
    };


    public abstract int getPosition(Area var1, float var2);

    public abstract int getSide(Area var1);

    public abstract int getScroll(Area var1, Scroll var2, int var3, int var4);

    public abstract float getMouse(int var1, int var2);
}

