/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.renderers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyCodes;
import mchorse.bbs_mod.utils.interps.Interpolations;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public class InputRenderer {
    private static boolean disabledForFrame = false;
    private List<PressedKey> pressedKeys = new ArrayList<PressedKey>();
    private float lastQX = 1.0f;
    private float lastQY = 0.0f;
    private float currentQX = 0.0f;
    private float currentQY = 1.0f;
    private long lastDWheelTime;
    private int lastDWheelScroll;

    public static void disable() {
        disabledForFrame = true;
    }

    public static void renderMouseButtons(Batcher2D batcher, int x, int y, int scroll, boolean left, boolean right, boolean middle, boolean isScrolling) {
        batcher.icon(Icons.MOUSE_BODY, x - 1, y);
        if (left) {
            batcher.icon(Icons.MOUSE_LMB, x, y + 1);
        }
        if (right) {
            batcher.icon(Icons.MOUSE_RMB, x + 6, y + 1);
        }
        if (middle || isScrolling) {
            int offset = 0;
            ++y;
            if (isScrolling) {
                offset = scroll < 0 ? 1 : -1;
            }
            batcher.box(x + 4, y, x + 8, y + 6, 0x20000000);
            batcher.box(x + 5, y + 1 + offset, x + 7, y + 5 + offset, -12303292);
            batcher.box(x + 5, y + 4 + offset, x + 7, y + 5 + offset, -13421773);
        }
    }

    public static void renderMouseWheel(Batcher2D batcher, int x, int y, int scroll, long current) {
        int color = (Integer)BBSSettings.primaryColor.get();
        batcher.dropShadow(x, y, x + 4, y + 16, 2, 0x88000000 | color, color);
        batcher.box(x, y, x + 4, y + 16, -15658735);
        batcher.box(x + 1, y, x + 3, y + 15, -14013910);
        int offset = (int)(current % 1000L / 50L % 4L);
        if (scroll >= 0) {
            offset = 3 - offset;
        }
        for (int i = 0; i < 4; ++i) {
            batcher.box(x, y + offset, x + 4, y + offset + 1, -2007673515);
            y += 4;
        }
    }

    public void render(UIBaseMenu menu, int mouseX, int mouseY) {
        if (disabledForFrame) {
            disabledForFrame = false;
            return;
        }
        this.renderMouse(menu.context.batcher, mouseX, mouseY);
        if (((Boolean)BBSSettings.enableKeystrokeRendering.get()).booleanValue()) {
            this.renderKeys(menu, mouseX, mouseY);
        }
    }

    private void renderMouse(Batcher2D batcher, int x, int y) {
        if (((Boolean)BBSSettings.enableCursorRendering.get()).booleanValue()) {
            batcher.icon(Icons.CURSOR, x, y);
        }
        if (((Boolean)BBSSettings.enableMouseButtonRendering.get()).booleanValue()) {
            boolean isScrolling;
            boolean left = Window.isMouseButtonPressed(0);
            boolean right = Window.isMouseButtonPressed(1);
            boolean middle = Window.isMouseButtonPressed(2);
            int scroll = Window.getVerticalScroll();
            long current = System.currentTimeMillis();
            boolean bl = isScrolling = scroll != 0 || current - this.lastDWheelTime < 500L;
            if (scroll != 0) {
                this.lastDWheelTime = current;
                this.lastDWheelScroll = scroll;
            }
            if (scroll == 0 && isScrolling) {
                scroll = this.lastDWheelScroll;
            }
            x += 16;
            y += 2;
            if (left || right || middle || isScrolling) {
                InputRenderer.renderMouseButtons(batcher, x, y, scroll, left, right, middle, isScrolling);
            }
            if (isScrolling) {
                InputRenderer.renderMouseWheel(batcher, x += 16, y, scroll, current);
            }
        }
    }

    private void renderKeys(UIBaseMenu menu, int mouseX, int mouseY) {
        float lqx = Math.round((float)mouseX / (float)menu.width);
        float lqy = Math.round((float)mouseY / (float)menu.height);
        int mode = (Integer)BBSSettings.keystrokeMode.get();
        if (lqx == this.currentQX && lqy == this.currentQY) {
            this.currentQX = this.lastQX;
            this.currentQY = this.lastQY;
        }
        if (mode == 1) {
            this.currentQX = 0.0f;
            this.currentQY = 1.0f;
        } else if (mode == 2) {
            this.currentQX = 1.0f;
            this.currentQY = 1.0f;
        } else if (mode == 3) {
            this.currentQX = 1.0f;
            this.currentQY = 0.0f;
        } else if (mode == 4) {
            this.currentQX = 0.0f;
            this.currentQY = 0.0f;
        }
        float qx = this.currentQX;
        float qy = this.currentQY;
        int fy = qy > 0.5f ? 1 : -1;
        int offset = (Integer)BBSSettings.keystrokeOffset.get();
        int mx = offset + (int)(qx * (float)(menu.width - offset * 2));
        int my = offset + (int)(qy * (float)(menu.height - 20 - offset * 2));
        Iterator<PressedKey> it = this.pressedKeys.iterator();
        while (it.hasNext()) {
            PressedKey key = it.next();
            if (key.hasExpired()) {
                it.remove();
                continue;
            }
            int x = mx + (qx < 0.5f ? key.x : -(key.x + key.width + 16));
            int y = my + (int)(Interpolations.EXP_INOUT.interpolate(0.0f, 1.0f, key.getFactor()) * 50.0f * (float)fy);
            int fw = 16 + key.width;
            Batcher2D batcher = menu.context.batcher;
            batcher.icon(Icons.KEY_CAP_LEFT, x, y);
            batcher.iconArea(Icons.KEY_CAP_REPEATABLE, x + 4, y, fw - 8, 20.0f);
            batcher.icon(Icons.KEY_CAP_RIGHT, x + fw, y, 1.0f, 0.0f);
            batcher.text(key.getLabel(), x + 8, y + 5, -16777216);
        }
        this.lastQX = lqx;
        this.lastQY = lqy;
    }

    public void keyPressed(UIContext context, int key) {
        boolean inputUnfocused;
        if (key < 0 || context == null) {
            return;
        }
        boolean bl = inputUnfocused = context.activeElement == null;
        if (inputUnfocused) {
            PressedKey last = null;
            int offset = -1000;
            for (PressedKey pressed : this.pressedKeys) {
                if (pressed.key == key) {
                    offset = pressed.increment(Batcher2D.getDefaultTextRenderer());
                } else if (offset != -1000) {
                    pressed.x += offset;
                }
                last = pressed;
            }
            if (offset != -1000) {
                return;
            }
            offset = (Integer)BBSSettings.keystrokeOffset.get();
            int x = last == null ? 0 : last.x + last.width + 18;
            PressedKey newKey = new PressedKey(key, x);
            newKey.setupName(class_310.method_1551().field_1772);
            if (newKey.x + newKey.width + offset > context.menu.width - offset * 2) {
                newKey.x = 0;
            }
            this.pressedKeys.add(newKey);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PressedKey {
        public static int INDEX = 0;
        public int key;
        public long time;
        public int x;
        public String name;
        public int width;
        public int i;
        public int times = 1;

        public PressedKey(int key, int x) {
            this.key = key;
            this.time = System.currentTimeMillis();
            this.x = x;
            this.i = INDEX++;
        }

        public void setupName(class_327 font) {
            this.name = KeyCodes.getName(this.key);
            this.width = font.method_1727(this.name) - 1;
        }

        public float getFactor() {
            return (float)(System.currentTimeMillis() - this.time - 500L) / 1000.0f;
        }

        public boolean hasExpired() {
            if (Window.isKeyPressed(this.key)) {
                this.time = System.currentTimeMillis();
            }
            return System.currentTimeMillis() - this.time > 1500L;
        }

        public String getLabel() {
            if (this.times > 1) {
                return this.name + " (" + this.times + ")";
            }
            return this.name;
        }

        public int increment(FontRenderer font) {
            int lastWidth = this.width;
            ++this.times;
            this.width = font.getWidth(this.getLabel());
            return this.width - lastWidth;
        }
    }
}

