/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.resources.FilteredLink;
import mchorse.bbs_mod.utils.resources.IWritableLink;
import mchorse.bbs_mod.utils.resources.LinkUtils;
import mchorse.bbs_mod.utils.resources.MultiLinkManager;

public class MultiLink
extends Link
implements IWritableLink {
    public List<FilteredLink> children = new ArrayList<FilteredLink>();

    public static MultiLink from(BaseType data) {
        ListType list;
        ListType listType = list = BaseType.isList(data) ? (ListType)data : null;
        if (list == null || list.size() == 0) {
            return null;
        }
        MultiLink multi = new MultiLink();
        try {
            multi.fromData(data);
            return multi;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public MultiLink(String resourceName) {
        this();
        this.children.add(new FilteredLink(LinkUtils.create(resourceName)));
    }

    public MultiLink(String resourceDomainIn, String resourcePathIn) {
        this();
        this.children.add(new FilteredLink(LinkUtils.create(resourceDomainIn, resourcePathIn)));
    }

    public MultiLink() {
        super("multi", "texture");
    }

    public void recalculateId() {
        this.hash = MultiLinkManager.getId(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiLink) {
            MultiLink multi = (MultiLink)obj;
            return Objects.equals(this.children, multi.children);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            this.recalculateId();
        }
        return super.hashCode();
    }

    @Override
    public BaseType toData() {
        ListType list = new ListType();
        for (FilteredLink child : this.children) {
            BaseType element = child.toData();
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    public void fromData(BaseType element) {
        ListType array = (ListType)element;
        for (int i = 0; i < array.size(); ++i) {
            FilteredLink location = FilteredLink.from(array.get(i));
            if (location == null) continue;
            this.children.add(location);
        }
    }

    @Override
    public Link copy() {
        MultiLink newMulti = new MultiLink();
        for (FilteredLink child : this.children) {
            newMulti.children.add(child.copyFiltered());
        }
        return newMulti;
    }
}

