/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.healthregenerationoverhaul.mixin.entity;

import com.github.theredbrain.healthregenerationoverhaul.HealthRegenerationOverhaul;
import com.github.theredbrain.healthregenerationoverhaul.entity.HealthRegeneratingEntity;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements HealthRegeneratingEntity {
    @Unique
    private int healthTickTimer = 0;
    @Unique
    private int healthRegenerationDelayTimer = 0;
    @Unique
    private Float oldHealth = null;
    @Unique
    private boolean applyOldHealth = true;
    @Unique
    private boolean applyMaxHealth = false;

    @Shadow
    public abstract float method_6063();

    @Shadow
    public abstract void method_6033(float var1);

    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract void method_6025(float var1);

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void healthregenerationoverhaul$createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(HealthRegenerationOverhaul.HEALTH_REGENERATION).method_26867(HealthRegenerationOverhaul.HEALTH_TICK_THRESHOLD).method_26867(HealthRegenerationOverhaul.HEALTH_REGENERATION_DELAY_THRESHOLD).method_26867(HealthRegenerationOverhaul.RESERVED_HEALTH);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void healthregenerationoverhaul$readCustomDataFromNbt_head(class_2487 nbt, CallbackInfo ci) {
        float health = nbt.method_10573("Health", 99) ? nbt.method_10583("Health") : Float.MIN_VALUE;
        if (health != Float.MIN_VALUE) {
            this.oldHealth = Float.valueOf(health);
        }
    }

    @Inject(method={"heal"}, at={@At(value="RETURN")})
    public void healthregenerationoverhaul$heal(float amount, CallbackInfo ci) {
        if (amount < 0.0f) {
            this.healthregenerationoverhaul$resetTickCounters();
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V", shift=At.Shift.AFTER)})
    protected void healthregenerationoverhaul$applyDamage(class_1282 source, float amount, CallbackInfo ci) {
        this.healthregenerationoverhaul$resetTickCounters();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void healthregenerationoverhaul$tick(CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            ++this.healthTickTimer;
            if (this.healthRegenerationDelayTimer <= this.healthregenerationoverhaul$getHealthRegenerationDelayThreshold()) {
                ++this.healthRegenerationDelayTimer;
                this.healthTickTimer = 0;
            }
            if (this.healthTickTimer >= this.healthregenerationoverhaul$getHealthTickThreshold() && this.healthRegenerationDelayTimer > this.healthregenerationoverhaul$getHealthRegenerationDelayThreshold()) {
                if (this.method_6032() < this.healthregenerationoverhaul$getUnreservedHealth()) {
                    this.method_6025(this.healthregenerationoverhaul$getRegeneratedHealth());
                } else if (this.method_6032() > this.healthregenerationoverhaul$getUnreservedHealth()) {
                    this.method_6033(this.healthregenerationoverhaul$getUnreservedHealth());
                }
                this.healthTickTimer = 0;
            }
            if (this.applyOldHealth) {
                if (this.applyMaxHealth) {
                    this.oldHealth = Float.valueOf(this.healthregenerationoverhaul$getUnreservedHealth());
                    this.applyMaxHealth = false;
                }
                if (this.oldHealth != null) {
                    this.method_6033(this.oldHealth.floatValue());
                    this.oldHealth = null;
                }
            } else {
                this.applyOldHealth = true;
            }
        }
    }

    @Override
    public int healthregenerationoverhaul$getHealthRegenerationDelayThreshold() {
        return (int)this.method_45325(HealthRegenerationOverhaul.HEALTH_REGENERATION_DELAY_THRESHOLD);
    }

    @Override
    public int healthregenerationoverhaul$getHealthTickThreshold() {
        return (int)this.method_45325(HealthRegenerationOverhaul.HEALTH_TICK_THRESHOLD);
    }

    @Override
    public float healthregenerationoverhaul$getRegeneratedHealth() {
        return this.healthregenerationoverhaul$getHealthRegeneration();
    }

    @Override
    public float healthregenerationoverhaul$getHealthRegeneration() {
        return (float)this.method_45325(HealthRegenerationOverhaul.HEALTH_REGENERATION);
    }

    @Override
    public float healthregenerationoverhaul$getUnreservedHealth() {
        return this.method_6063() - this.method_6063() * this.healthregenerationoverhaul$getReservedHealth() / 100.0f;
    }

    @Override
    public float healthregenerationoverhaul$getReservedHealth() {
        return (float)this.method_45325(HealthRegenerationOverhaul.RESERVED_HEALTH);
    }

    @Override
    public void healthregenerationoverhaul$resetTickCounters() {
        this.healthRegenerationDelayTimer = 0;
        this.healthTickTimer = 0;
    }

    @Override
    public void healthregenerationoverhaul$setApplyOldHealth(boolean applyOldHealth) {
        this.applyOldHealth = applyOldHealth;
    }

    @Override
    public void healthregenerationoverhaul$setApplyMaxHealth(boolean applyMaxHealth) {
        this.applyMaxHealth = applyMaxHealth;
    }
}

