/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.healthregenerationoverhaul.registry;

import com.github.theredbrain.healthregenerationoverhaul.HealthRegenerationOverhaulClient;
import com.github.theredbrain.healthregenerationoverhaul.config.ClientConfig;
import com.github.theredbrain.healthregenerationoverhaul.entity.HealthRegeneratingEntity;
import com.github.theredbrain.resourcebarapi.ResourceBarAPI;
import com.github.theredbrain.resourcebarapi.ResourceBarAPIClient;
import java.util.ArrayList;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1294;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class ClientEventsRegistry {
    private static final String RESOURCE_BAR_IDENTIFIER_STRING = "healthregenerationoverhaul:health";
    private static final class_2960 ICON_HEALTH_CONTAINER = class_2960.method_60656((String)"hud/heart/container");
    private static final class_2960 ICON_HEALTH_CONTAINER_HARDCORE = class_2960.method_60656((String)"hud/heart/container_hardcore");
    private static final class_2960 ICON_HEALTH_FULL = class_2960.method_60656((String)"hud/heart/full");
    private static final class_2960 ICON_HEALTH_HALF = class_2960.method_60656((String)"hud/heart/half");
    private static final class_2960 ICON_HEALTH_FULL_POISONED = class_2960.method_60656((String)"hud/heart/poisoned_full");
    private static final class_2960 ICON_HEALTH_HALF_POISONED = class_2960.method_60656((String)"hud/heart/poisoned_half");
    private static final class_2960 ICON_HEALTH_FULL_WITHERED = class_2960.method_60656((String)"hud/heart/withered_full");
    private static final class_2960 ICON_HEALTH_HALF_WITHERED = class_2960.method_60656((String)"hud/heart/withered_half");
    private static final class_2960 ICON_HEALTH_FULL_FROZEN = class_2960.method_60656((String)"hud/heart/frozen_full");
    private static final class_2960 ICON_HEALTH_HALF_FROZEN = class_2960.method_60656((String)"hud/heart/frozen_half");
    private static final class_2960 ICON_HEALTH_FULL_HARDCORE = class_2960.method_60656((String)"hud/heart/hardcore_full");
    private static final class_2960 ICON_HEALTH_HALF_HARDCORE = class_2960.method_60656((String)"hud/heart/hardcore_half");
    private static final class_2960 ICON_HEALTH_FULL_POISONED_HARDCORE = class_2960.method_60656((String)"hud/heart/poisoned_hardcore_full");
    private static final class_2960 ICON_HEALTH_HALF_POISONED_HARDCORE = class_2960.method_60656((String)"hud/heart/poisoned_hardcore_half");
    private static final class_2960 ICON_HEALTH_FULL_WITHERED_HARDCORE = class_2960.method_60656((String)"hud/heart/withered_hardcore_full");
    private static final class_2960 ICON_HEALTH_HALF_WITHERED_HARDCORE = class_2960.method_60656((String)"hud/heart/withered_hardcore_half");
    private static final class_2960 ICON_HEALTH_FULL_FROZEN_HARDCORE = class_2960.method_60656((String)"hud/heart/frozen_hardcore_full");
    private static final class_2960 ICON_HEALTH_HALF_FROZEN_HARDCORE = class_2960.method_60656((String)"hud/heart/frozen_hardcore_half");

    public static void initializeClientEvents() {
        HudRenderCallback.EVENT.register((matrixStack, delta) -> {
            class_310 minecraftClient = class_310.method_1551();
            class_746 playerEntity = minecraftClient.field_1724;
            ClientConfig clientConfig = HealthRegenerationOverhaulClient.CLIENT_CONFIG;
            if (playerEntity != null && !minecraftClient.field_1690.field_1842 && clientConfig.enable_alternative_health_bar) {
                double health = playerEntity.method_6032();
                double maxHealth = playerEntity.method_6063();
                double unreservedHealth = class_3532.method_15386((float)((HealthRegeneratingEntity)playerEntity).healthregenerationoverhaul$getUnreservedHealth());
                if (!playerEntity.method_7337() && maxHealth > 0.0) {
                    MutablePair originPos = ResourceBarAPIClient.getOriginPos((class_332)matrixStack, (ResourceBarAPI.ResourceBarOrigin)clientConfig.origin);
                    if (clientConfig.health_bar_display == ResourceBarAPI.ResourceBarDisplay.ICON && (health < maxHealth || clientConfig.show_full_health_bar)) {
                        class_2960 halfId;
                        class_2960 fullId;
                        class_2960 containerId;
                        if (playerEntity.method_37908().method_8401().method_152()) {
                            containerId = ICON_HEALTH_CONTAINER_HARDCORE;
                            if (playerEntity.method_6059(class_1294.field_5899)) {
                                fullId = ICON_HEALTH_FULL_POISONED_HARDCORE;
                                halfId = ICON_HEALTH_HALF_POISONED_HARDCORE;
                            } else if (playerEntity.method_6059(class_1294.field_5920)) {
                                fullId = ICON_HEALTH_FULL_WITHERED_HARDCORE;
                                halfId = ICON_HEALTH_HALF_WITHERED_HARDCORE;
                            } else if (playerEntity.method_32314()) {
                                fullId = ICON_HEALTH_FULL_FROZEN_HARDCORE;
                                halfId = ICON_HEALTH_HALF_FROZEN_HARDCORE;
                            } else {
                                fullId = ICON_HEALTH_FULL_HARDCORE;
                                halfId = ICON_HEALTH_HALF_HARDCORE;
                            }
                        } else {
                            containerId = ICON_HEALTH_CONTAINER;
                            if (playerEntity.method_6059(class_1294.field_5899)) {
                                fullId = ICON_HEALTH_FULL_POISONED;
                                halfId = ICON_HEALTH_HALF_POISONED;
                            } else if (playerEntity.method_6059(class_1294.field_5920)) {
                                fullId = ICON_HEALTH_FULL_WITHERED;
                                halfId = ICON_HEALTH_HALF_WITHERED;
                            } else if (playerEntity.method_32314()) {
                                fullId = ICON_HEALTH_FULL_FROZEN;
                                halfId = ICON_HEALTH_HALF_FROZEN;
                            } else {
                                fullId = ICON_HEALTH_FULL;
                                halfId = ICON_HEALTH_HALF;
                            }
                        }
                        ResourceBarAPIClient.drawIconResourceBar((class_310)minecraftClient, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double)health, (double)maxHealth, (class_2960)containerId, (class_2960)fullId, (class_2960)halfId, new ArrayList(), new ArrayList(), (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), (int)((Integer)clientConfig.iconBarSettings.offset_x.get()), (int)((Integer)clientConfig.iconBarSettings.offset_y.get()), (ResourceBarAPI.ResourceBarFillDirection)clientConfig.fill_direction, (boolean)((Boolean)clientConfig.iconBarSettings.reverse_stack_direction.get()), (int)((Integer)clientConfig.iconBarSettings.max_icon_amount_per_bar.get()));
                    } else if (clientConfig.health_bar_display == ResourceBarAPI.ResourceBarDisplay.SMOOTH && (health < maxHealth || clientConfig.show_full_health_bar)) {
                        ResourceBarAPIClient.drawSmoothResourceBar((class_310)minecraftClient, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double[])new double[]{-1.0, -1.0, 0.0, -91.0, -45.0, 5.0, 182.0, 5.0, 182.0, 5.0, 182.0, 5.0, 5.0, 0.0, 0.0}, (class_2960[])new class_2960[]{class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_background.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_decrease_animation.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_increase_animation.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_increase_value.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_reserved.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_overlay.png"), null}, (double)health, (double)maxHealth, (int)class_3532.method_15386((float)((HealthRegeneratingEntity)playerEntity).healthregenerationoverhaul$getRegeneratedHealth()), (double)unreservedHealth, (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), clientConfig.smoothBarSettings.positionSettings.offsets_x, clientConfig.smoothBarSettings.positionSettings.offsets_y, (int)0, (int)0, (ResourceBarAPI.ResourceBarFillDirection)clientConfig.fill_direction, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.backgroundTextureSettings.texture_ids, (int)clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_decrease_animation_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_increase_animation_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_increase_value_texture_ids, clientConfig.smoothBarSettings.textureSettings.progressTextureSettings.progress_texture_ids, (int)clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.reservedTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.show_current_value_overlay, (int)clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.offset_y, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_heights, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_widths, clientConfig.smoothBarSettings.textureSettings.overlayTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.show_icon, (int)clientConfig.smoothBarSettings.iconTextureSettings.offset_x, (int)clientConfig.smoothBarSettings.iconTextureSettings.offset_y, clientConfig.smoothBarSettings.iconTextureSettings.texture_heights, clientConfig.smoothBarSettings.iconTextureSettings.texture_widths, clientConfig.smoothBarSettings.iconTextureSettings.texture_ids, (boolean)clientConfig.smoothBarSettings.enable_smooth_animation, (int)clientConfig.smoothBarSettings.animationSettings.animation_interval, (boolean)clientConfig.smoothBarSettings.animationSettings.max_value_change_is_animated);
                    }
                    if (clientConfig.numberSettings.show_number && (health < maxHealth || clientConfig.show_full_health_bar)) {
                        ResourceBarAPIClient.drawResourceNumber((class_310)minecraftClient, (class_327)minecraftClient.field_1772, (class_332)matrixStack, (String)RESOURCE_BAR_IDENTIFIER_STRING, (double)health, (double)maxHealth, (double)unreservedHealth, (int)((Integer)originPos.getLeft()), (int)((Integer)originPos.getRight()), (boolean)clientConfig.numberSettings.show_max_value, (int)clientConfig.numberSettings.offset_x, (int)clientConfig.numberSettings.offset_y, (int)clientConfig.numberSettings.color.toInt());
                    }
                }
            }
        });
        ConfigApi.event().onUpdateClient((identifier, config) -> {
            if (identifier.equals((Object)class_2960.method_60655((String)"healthregenerationoverhaul", (String)"client"))) {
                ResourceBarAPIClient.clearCache((String)RESOURCE_BAR_IDENTIFIER_STRING, (double[])new double[]{-1.0, -1.0, 0.0, -91.0, -45.0, 5.0, 182.0, 5.0, 182.0, 5.0, 182.0, 5.0, 5.0, 0.0, 0.0}, (class_2960[])new class_2960[]{class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_background.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_decrease_animation.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_increase_animation.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress_increase_value.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_progress.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_reserved.png"), class_2960.method_60655((String)"healthregenerationoverhaul", (String)"textures/gui/sprites/hud/horizontal_health_overlay.png"), null});
            }
        });
    }
}

