/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.config.ConfigType;
import de.cristelknight.cristellib.config.serialize.ed.EDConfig;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.data.codec.StructureSetData;
import de.cristelknight.cristellib.registry.ReadStructureSets;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.RuntimePackUtil;
import de.cristelknight.cristellib.util.Util;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public class StructureConfig {
    public static final Codec<StructureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(config -> Util.fileName(config.getPath())), (App)Codec.STRING.fieldOf("path").forGetter(config -> String.valueOf(config.path.getParent())), (App)Codec.STRING.optionalFieldOf("header", (Object)"").forGetter(config -> config.header), (App)ConfigType.CODEC.fieldOf("config_type").forGetter(config -> config.type), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("comments", new HashMap()).forGetter(config -> config.comments), (App)Codec.list(StructureSetData.CODEC).fieldOf("structure_sets").forGetter(config -> config.structureSetHolders)).apply((Applicative)builder, StructureConfig::new));
    private final Path path;
    private String header = "";
    private Map<String, String> comments;
    private final ConfigType type;
    private String defaultNamespace = "";
    private final List<StructureSetData> structureSetHolders;
    private final Supplier<Map<ResourceLocation, List<ResourceLocation>>> structuresForED;
    private final Supplier<Map<ResourceLocation, PlacementConfig>> structurePlacement;
    public Map<ResourceLocation, EDConfig> enableDisableConfig = null;
    public Map<ResourceLocation, PlacementConfig> placementConfig = null;
    public boolean isAutoGenerated = false;

    private StructureConfig(Path path, ConfigType type) {
        this(path, null, new HashMap<String, String>(), type, new ArrayList<StructureSetData>());
    }

    private StructureConfig(String name, String path, String header, ConfigType type, Map<String, String> comments, List<StructureSetData> structureSetHolders) {
        this(Util.janksonPathFromString(path, name), header, (Map<String, String>)ImmutableMap.copyOf(comments), type, (List<StructureSetData>)ImmutableList.copyOf(structureSetHolders));
    }

    private StructureConfig(Path path, String header, Map<String, String> comments, ConfigType type, List<StructureSetData> structureSetHolders) {
        this.path = path;
        if (header != null && !header.isEmpty()) {
            this.setHeader(header);
        }
        this.comments = comments;
        this.type = type;
        this.structureSetHolders = structureSetHolders;
        if (!this.structureSetHolders.isEmpty()) {
            this.getDefaultNamespace();
        }
        this.structuresForED = Suppliers.memoize(() -> ReadStructureSets.readSetsAndAddStructures(structureSetHolders));
        this.structurePlacement = Suppliers.memoize(() -> ReadStructureSets.readSetsAndAddPlacements(structureSetHolders));
    }

    void addSet(StructureSetData set) {
        this.structureSetHolders.add(set);
    }

    public void addSetsToRuntimePack() {
        if (this.type.equals((Object)ConfigType.ENABLE_DISABLE) && this.enableDisableConfig == null) {
            this.enableDisableConfig = ConfigManager.readEDConfig(this);
        } else if (this.type.equals((Object)ConfigType.PLACEMENT) && this.placementConfig == null) {
            this.placementConfig = ConfigManager.readPlacementConfig(this);
        }
        this.structureSetHolders.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement structureSetElement = this.getStructureSet((ResourceLocation)setLocation, modID);
            if (!(structureSetElement instanceof JsonObject)) {
                CristelLib.LOGGER.warn("Set for {} {} is not a JsonObject, skipping...", (Object)modID, setLocation);
                return;
            }
            JsonObject structureSet = (JsonObject)structureSetElement;
            JsonObject originalSet = structureSet.deepCopy();
            if (this.type.equals((Object)ConfigType.ENABLE_DISABLE)) {
                this.removeStructureInSets(structureSet, (ResourceLocation)setLocation);
            } else if (this.type.equals((Object)ConfigType.PLACEMENT)) {
                this.updatePlacementsInSet(structureSet, (ResourceLocation)setLocation);
            }
            if (!structureSet.equals((Object)originalSet)) {
                CristelLib.RUNTIME_PACK.addStructureSet((ResourceLocation)setLocation, structureSet);
            }
        }));
    }

    private void removeStructureInSets(JsonObject structureSet, ResourceLocation setLocation) {
        if (!this.enableDisableConfig.containsKey(setLocation)) {
            CristelLib.LOGGER.error("{} {}", (Object)setLocation, (Object)this.enableDisableConfig.toString());
            return;
        }
        EDConfig setConfig = this.enableDisableConfig.get(setLocation);
        JsonArray array = structureSet.get("structures").getAsJsonArray();
        Iterator structureIterator = array.iterator();
        while (structureIterator.hasNext()) {
            JsonElement structure = (JsonElement)structureIterator.next();
            String structureName = this.toDefaultString(Objects.requireNonNull(ResourceLocation.tryParse((String)structure.getAsJsonObject().get("structure").getAsString())));
            if (setConfig.containsStructure(structureName)) {
                if (!setConfig.isStructureDisabled(structureName)) continue;
                structureIterator.remove();
                continue;
            }
            CristelLib.LOGGER.error("{} is not included in: {} for mod with path: {} ", (Object)structureName, (Object)setLocation, (Object)this.path);
        }
    }

    private void updatePlacementsInSet(JsonObject structureSet, ResourceLocation setLocation) {
        if (!this.placementConfig.containsKey(setLocation)) {
            CristelLib.LOGGER.error("{} {}", (Object)setLocation, (Object)this.placementConfig.toString());
            return;
        }
        JsonObject o = structureSet.get("placement").getAsJsonObject();
        PlacementConfig p = this.placementConfig.get(setLocation);
        o.addProperty("salt", (Number)p.salt());
        o.addProperty("spacing", (Number)p.spacing());
        o.addProperty("separation", (Number)p.separation());
        double newF = p.frequency();
        if (!o.has("frequency") && newF == 1.0 || o.has("frequency") && newF == (double)o.get("frequency").getAsFloat()) {
            return;
        }
        o.addProperty("frequency", (Number)newF);
    }

    private JsonElement getStructureSet(ResourceLocation location, String modID) {
        ResourceLocation structureLocation = RuntimePackUtil.getLocationForStructureSet(location);
        if (CristelLib.RUNTIME_PACK.hasResource(structureLocation)) {
            return CristelLib.RUNTIME_PACK.getResource(structureLocation);
        }
        return JanksonUtil.getSetElement(modID, location);
    }

    public void writeConfig(boolean override) {
        if (this.type.equals((Object)ConfigType.ENABLE_DISABLE)) {
            ConfigManager.createEDConfig(this, override);
        } else if (this.type.equals((Object)ConfigType.PLACEMENT)) {
            ConfigManager.createPlacementConfig(this, override);
        }
    }

    public static StructureConfig create(Path path, String name, ConfigType type) {
        return new StructureConfig(path.resolve(name + ".json5"), type);
    }

    public static StructureConfig createWithDefaultConfigPath(String subPath, String name, ConfigType type) {
        return new StructureConfig(CristelLibExpectPlatform.getConfigDirectory().resolve(subPath).resolve(name + ".json5"), type);
    }

    public static StructureConfig createWithDefaultConfigPath(String name, ConfigType type) {
        return new StructureConfig(CristelLibExpectPlatform.getConfigDirectory().resolve(name + ".json5"), type);
    }

    public void setComments(Map<String, String> comments) {
        this.comments = comments;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public Map<String, String> getComments() {
        return this.comments;
    }

    public Map<ResourceLocation, List<ResourceLocation>> getDefaultStructures() {
        return (Map)this.structuresForED.get();
    }

    public Map<ResourceLocation, PlacementConfig> getDefaultStructurePlacement() {
        return (Map)this.structurePlacement.get();
    }

    public Path getPath() {
        return this.path;
    }

    public ConfigType getType() {
        return this.type;
    }

    public ResourceLocation toDefaultRL(String location) {
        if (location.contains(":")) {
            return ResourceLocation.parse((String)location);
        }
        if (this.defaultNamespace.equals("minecraft")) {
            return ResourceLocation.withDefaultNamespace((String)location);
        }
        return ResourceLocation.fromNamespaceAndPath((String)this.defaultNamespace, (String)location);
    }

    public String toDefaultString(ResourceLocation location) {
        return location.getNamespace().equals(this.defaultNamespace) ? location.getPath() : location.toString();
    }

    public void getDefaultNamespace() {
        HashMap<String, Integer> namespaceCounts = new HashMap<String, Integer>();
        for (StructureSetData data : this.structureSetHolders) {
            for (ResourceLocation set : data.sets()) {
                namespaceCounts.merge(set.getNamespace(), 1, Integer::sum);
            }
        }
        if (namespaceCounts.isEmpty()) {
            throw new RuntimeException("No namespaces found in config with path: " + String.valueOf(this.getPath()) + " :(((");
        }
        this.defaultNamespace = namespaceCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new RuntimeException("Could not determine default namespace :((("));
    }

    public boolean isSetsEmpty() {
        return this.structureSetHolders.isEmpty();
    }
}

