/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.serialize.ed;

import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.config.serialize.ed.EDConfig;
import de.cristelknight.cristellib.config.serialize.ed.NestedEDConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class EDConfigTransformer {
    public static Map<String, Boolean> stringBooleanMap(NestedEDConfig edConfig, String parent) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (Map.Entry<String, NestedEDConfig.Entry> entry : edConfig.entries().entrySet()) {
            String finalKey;
            String key = entry.getKey();
            NestedEDConfig.Entry object = entry.getValue();
            String string = finalKey = parent.isEmpty() ? key : parent + "/" + key;
            if (object.isBoolean()) {
                map.put(finalKey, object.value());
                continue;
            }
            map.putAll(EDConfigTransformer.stringBooleanMap(object.nested(), finalKey));
        }
        return map;
    }

    public static Map<String, NestedEDConfig> mapToNestedStructures(Map<class_2960, List<class_2960>> sets, StructureConfig structureConfig) {
        HashMap<String, NestedEDConfig> nestedStructures = new HashMap<String, NestedEDConfig>();
        for (Map.Entry<class_2960, List<class_2960>> mapEntry : sets.entrySet()) {
            class_2960 location = mapEntry.getKey();
            List<class_2960> stringList = mapEntry.getValue();
            HashMap<String, NestedEDConfig.Entry> entries = new HashMap<String, NestedEDConfig.Entry>();
            for (class_2960 structure : stringList) {
                String structureName = structureConfig.toDefaultString(structure);
                EDConfigTransformer.putStructureName(structureName, true, entries);
            }
            NestedEDConfig nestedStructure = new NestedEDConfig(entries);
            nestedStructures.put(structureConfig.toDefaultString(location), nestedStructure);
        }
        return nestedStructures;
    }

    public static Map<String, NestedEDConfig> mapToNestedStructuresWithValues(Map<class_2960, EDConfig> sets, StructureConfig structureConfig) {
        HashMap<String, NestedEDConfig> nestedStructures = new HashMap<String, NestedEDConfig>();
        for (Map.Entry<class_2960, EDConfig> mapEntry : sets.entrySet()) {
            class_2960 location = mapEntry.getKey();
            EDConfig stringList = mapEntry.getValue();
            HashMap<String, NestedEDConfig.Entry> entries = new HashMap<String, NestedEDConfig.Entry>();
            for (Map.Entry<String, Boolean> entry : stringList.setStructureInfo().entrySet()) {
                String structure = entry.getKey();
                boolean value = entry.getValue();
                EDConfigTransformer.putStructureName(structure, value, entries);
            }
            NestedEDConfig nestedStructure = new NestedEDConfig(entries);
            nestedStructures.put(structureConfig.toDefaultString(location), nestedStructure);
        }
        return nestedStructures;
    }

    public static void putStructureName(String structureName, boolean value, Map<String, NestedEDConfig.Entry> entries) {
        if (structureName.contains("/")) {
            String[] parts = structureName.split("/", 2);
            String key = parts[0];
            String restOfStructureName = parts[1];
            boolean containsNestedStructure = entries.containsKey(key);
            Map<Object, Object> nestedEntries = containsNestedStructure ? entries.get(key).nested().entries() : new HashMap();
            EDConfigTransformer.putStructureName(restOfStructureName, value, nestedEntries);
            if (!containsNestedStructure) {
                entries.put(key, NestedEDConfig.Entry.ofNested(new NestedEDConfig(nestedEntries)));
            }
        } else {
            entries.put(structureName, NestedEDConfig.Entry.ofBoolean(value));
        }
    }
}

