/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.fabric;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.api.CristelLibAPI;
import de.cristelknight.cristellib.data.PathFinder;
import de.cristelknight.cristellib.util.Platform;
import de.cristelknight.cristellib.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.resource.v1.pack.PackActivationType;
import net.fabricmc.fabric.impl.resource.pack.ModNioPackResources;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class CristelLibExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static class_3262 registerBuiltinResourcePack(class_2960 id, class_2561 displayName) {
        String modID = id.method_12836();
        ModContainer container = FabricLoader.getInstance().getModContainer(modID).orElse(null);
        if (container != null) {
            return ModNioPackResources.create((String)id.toString(), (ModContainer)container, (String)id.method_12832(), (class_3264)class_3264.field_14190, (PackActivationType)PackActivationType.ALWAYS_ENABLED, (boolean)false);
        }
        CristelLib.LOGGER.warn("Couldn't get mod container for modID: {}", (Object)modID);
        return null;
    }

    public static void findInModFiles(String modId, String startingFolder, Predicate<Path> fileFilter, Consumer<String> consumer) {
        for (Path root : CristelLibExpectPlatformImpl.getRootPaths(modId)) {
            try {
                PathFinder.walk(root.resolve(startingFolder), fileFilter, consumer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Map<String, Set<StructureConfig>> getConfigs(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> configs = new HashMap<String, Set<StructureConfig>>();
        FabricLoader.getInstance().getEntrypointContainers("cristellib", CristelLibAPI.class).forEach(entrypoint -> {
            String modId = entrypoint.getProvider().getMetadata().getId();
            CristelLibAPI api = (CristelLibAPI)entrypoint.getEntrypoint();
            CristelLib.readAPI(registry, modId, api, configs);
        });
        Util.readData(configs, registry);
        return configs;
    }

    public static List<String> getModIds() {
        return FabricLoader.getInstance().getAllMods().stream().filter(m -> {
            Iterator it = m.getMetadata().getAuthors().iterator();
            return !it.hasNext() || !((Person)it.next()).getName().equals("FabricMC");
        }).map(mod -> mod.getMetadata().getId()).toList();
    }

    public static Platform getPlatform() {
        return Platform.FABRIC;
    }

    public static String getModDisplayName(String modID) {
        return FabricLoader.getInstance().getModContainer(modID).map(container -> container.getMetadata().getName()).orElse(modID);
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static InputStream getResourceStream(String modId, String subPath) {
        InputStream inputStream;
        Path pathC = CristelLibExpectPlatformImpl.getResourceDirectory(modId, subPath);
        if (pathC == null) {
            return null;
        }
        try {
            inputStream = Files.newInputStream(pathC, new OpenOption[0]);
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't create Input Stream for Path {}", (Object)pathC, (Object)e);
            return null;
        }
        return inputStream;
    }

    @Nullable
    private static Path getResourceDirectory(String modId, String subPath) {
        ModContainer container = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (container != null) {
            Path path = container.findPath(subPath).orElse(null);
            if (path == null) {
                CristelLib.LOGGER.debug("Path for subPath: {} in modId: {} is null", (Object)subPath, (Object)modId);
            }
            return path;
        }
        CristelLib.LOGGER.debug("Mod container for modId: {} is null", (Object)modId);
        return null;
    }

    public static List<Path> getRootPaths(String modId) {
        ModContainer container = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        List<Path> paths = new ArrayList<Path>();
        if (container != null) {
            paths = container.getRootPaths();
        }
        return paths;
    }
}

