/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.fabric.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.cristellib.ModLoadingUtil;
import de.cristelknight.cristellib.autoconfig.ACConfig;
import de.cristelknight.cristellib.config.client.ScreenBuilder;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.util.Util;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class CristelLibClient
implements ClientModInitializer {
    public static boolean shouldOpenScreen = false;
    public static class_437 pending = null;

    public void onInitializeClient() {
        CristelLibClient.registerClient();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (shouldOpenScreen) {
                shouldOpenScreen = false;
                if (pending != null) {
                    client.method_1507(pending);
                }
                pending = null;
            }
        });
    }

    public static void registerClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CristelLibClient.registerScreen((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private static void registerScreen(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cristellib_screen").then(ClientCommandManager.argument((String)"mod_id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ScreenSuggestionProvider()).executes(ctx -> CristelLibClient.showScreen((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"mod_id")))));
    }

    private static int showScreen(CommandContext<FabricClientCommandSource> ctx, String modID) {
        FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
        if (!Util.isClothConfigLoaded()) {
            source.sendError((class_2561)class_2561.method_43470((String)"Cloth Config is not installed!"));
            return 0;
        }
        if (!ModLoadingUtil.isModLoaded(modID)) {
            source.sendError((class_2561)class_2561.method_43470((String)("Mod: " + modID + " is not installed!")));
            return 0;
        }
        ACConfig acConfig = ConfigRegistry.get(ACConfig.class);
        boolean structureEnabled = !acConfig.disableAutoConfigScreens();
        Set<String> allScreens = ScreenBuilder.allConfigMods(structureEnabled);
        if (!allScreens.contains(modID)) {
            source.sendError((class_2561)class_2561.method_43470((String)("Mod: " + modID + " has no (enabled) screen!")));
            return 0;
        }
        Pair structureSimple = modID.equals("cristellib") ? new Pair((Object)true, (Object)true) : ScreenBuilder.shouldCreateScreen(modID, structureEnabled);
        boolean structure = (Boolean)structureSimple.getFirst();
        boolean simple = (Boolean)structureSimple.getSecond();
        if (!structure && !simple) {
            source.sendError((class_2561)class_2561.method_43470((String)("Mod: " + modID + " has no (enabled) screen!")));
            return 0;
        }
        shouldOpenScreen = true;
        class_310.method_1551().execute(() -> {
            pending = new ScreenBuilder(modID).create(null, structure, simple);
        });
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Opened screen for " + modID)));
        return 1;
    }

    public static class ScreenSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            ACConfig acConfig = ConfigRegistry.get(ACConfig.class);
            boolean structureEnabled = !acConfig.disableAutoConfigScreens();
            Set<String> allScreens = ScreenBuilder.allConfigMods(structureEnabled);
            for (String screen : allScreens) {
                builder.suggest(screen);
            }
            return builder.buildFuture();
        }
    }
}

