/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.autoconfig.ModFinder;
import de.cristelknight.cristellib.config.ConfigManager;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PathFinder {
    public static PathFinderData getSubPathsInMod(String modId, Set<String> modsWithConfig) {
        HashSet<String> autoConfig = new HashSet<String>();
        HashSet<String> structureConfig = new HashSet<String>();
        HashSet<String> dataPack = new HashSet<String>();
        HashSet structureSets = ModFinder.shouldSkipModForACPre(modId, modsWithConfig) ? null : new HashSet();
        try {
            if (modId.equals("minecraft")) {
                PathFinder.walk(ConfigManager.CONFIG_LIB, path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".json"), p -> PathFinder.categorizePath(p, autoConfig, structureConfig, dataPack, null));
            } else {
                CristelLibExpectPlatform.findInModFiles(modId, "data", path -> path.toString().endsWith(".json"), p -> PathFinder.categorizePath(p, autoConfig, structureConfig, dataPack, structureSets));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new PathFinderData(autoConfig, structureConfig, dataPack, structureSets == null ? Set.of() : structureSets);
    }

    private static void categorizePath(String path, Set<String> autoConfig, Set<String> structureConfig, Set<String> dataPack, Set<String> structureSets) {
        Object normalized = path.replace('\\', '/');
        path = normalized;
        if (!((String)normalized).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        if (!((String)normalized).startsWith("/data/")) {
            return;
        }
        if (structureSets != null && ((String)normalized).matches("^/data/[^/]+/worldgen/structure_set/.*")) {
            structureSets.add((String)normalized);
            return;
        }
        if (!((String)normalized).startsWith("/data/cristellib/")) {
            return;
        }
        if (((String)normalized).startsWith("/data/cristellib/structure_config/")) {
            structureConfig.add(path);
        } else if (((String)normalized).startsWith("/data/cristellib/data_pack/")) {
            dataPack.add(path);
        } else if (((String)normalized).startsWith("/data/cristellib/auto_config/")) {
            autoConfig.add(path);
        }
    }

    public static void walk(Path root, Predicate<Path> fileFilter, Consumer<String> consumer) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(root, Integer.MAX_VALUE, new FileVisitOption[0]);){
            for (Path subPath : stream::iterator) {
                if (!fileFilter.test(subPath)) continue;
                consumer.accept(subPath.toString());
            }
        }
    }

    public record PathFinderData(Set<String> autoConfig, Set<String> structureConfig, Set<String> dataPack, Set<String> structureSets) {
    }
}

