/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.builtinpacks.RuntimePack;
import de.cristelknight.cristellib.util.UnsafeByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RuntimePackUtil {
    public static byte @Nullable [] extractImageBytes(InputStream imageStream) {
        try {
            byte[] bytes = imageStream.readAllBytes();
            imageStream.close();
            return bytes;
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't get image for a RuntimePack");
            return null;
        }
    }

    public static byte[] serializeJson(JsonObject object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        RuntimePack.GSON.toJson((JsonElement)object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public static ResourceLocation getLocationForStructureSet(ResourceLocation location) {
        return RuntimePackUtil.createJsonLocation("worldgen/structure_set", location);
    }

    public static ResourceLocation createJsonLocation(String prefix, ResourceLocation identifier) {
        return RuntimePackUtil.createResourceLocation(prefix, "json", identifier);
    }

    public static ResourceLocation createResourceLocation(String prefix, String end, ResourceLocation identifier) {
        return ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)(prefix + "/" + identifier.getPath() + "." + end));
    }
}

