/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.autoconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.autoconfig.ACConfig;
import de.cristelknight.cristellib.autoconfig.ACInfoData;
import de.cristelknight.cristellib.config.ConfigType;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.data.PathFinder;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ModFinder {
    public static final Set<String> supportedPlacements = Set.of("minecraft:random_spread", "mes:advanced_random_spread", "mns:advanced_random_spread", "mss:advanced_random_spread", "mvs:advanced_random_spread", "repurposed_structures:advanced_random_spread");

    public static void addConfigs(Map<String, Set<StructureConfig>> configs, CristelLibRegistry registry) {
        ModFinder.find(configs.keySet()).forEach((modID, structureSets) -> {
            HashSet<StructureConfig> configSet = new HashSet<StructureConfig>();
            boolean customPath = ACInfoData.currentData.containsKey(modID) && !ACInfoData.currentData.get(modID).autoConfigPath().isEmpty();
            String customSubPath = ConfigRegistry.get(ACConfig.class).autoConfigSubPath();
            StructureConfig edConfig = StructureConfig.createWithDefaultConfigPath((String)(customPath ? ACInfoData.currentData.get(modID).autoConfigPath() : customSubPath + modID), "structure_toggle_config", ConfigType.ENABLE_DISABLE);
            StructureConfig placementConfig = StructureConfig.createWithDefaultConfigPath((String)(customPath ? ACInfoData.currentData.get(modID).autoConfigPath() : customSubPath + modID), "structure_placement_config", ConfigType.PLACEMENT);
            structureSets.forEach(path -> {
                JsonElement e = JanksonUtil.getElement(modID, path.toString());
                if (e != null) {
                    JsonObject object = class_3518.method_15295((JsonElement)e, (String)("Set at: " + String.valueOf(path))).getAsJsonObject("placement");
                    class_2960 location = ModFinder.getLocation(path);
                    if (supportedPlacements.contains(class_3518.method_15265((JsonObject)object, (String)"type"))) {
                        registry.registerSetToConfig((String)modID, location, edConfig, placementConfig);
                    } else {
                        registry.registerSetToConfig((String)modID, location, edConfig);
                    }
                }
            });
            if (!placementConfig.isSetsEmpty()) {
                configSet.add(placementConfig);
            }
            if (!edConfig.isSetsEmpty()) {
                configSet.add(edConfig);
            }
            if (!configSet.isEmpty()) {
                configSet.forEach(config -> {
                    config.getDefaultNamespace();
                    config.isAutoGenerated = true;
                    config.setHeader("Automatically generated by Cristel Lib");
                });
                configs.put((String)modID, (Set<StructureConfig>)configSet);
            }
        });
    }

    private static class_2960 getLocation(Path rootPath) {
        String namespace = rootPath.getName(1).toString();
        String path = Util.cutFileType(rootPath.subpath(4, rootPath.getNameCount()));
        if (namespace.equals("minecraft")) {
            return class_2960.method_60656((String)path);
        }
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static Map<String, List<Path>> find(Set<String> modsWithConfig) {
        ACConfig acConfig = ConfigRegistry.get(ACConfig.class);
        if (acConfig.disableAutoConfig()) {
            return Map.of();
        }
        HashMap<String, List<Path>> structureSets = new HashMap<String, List<Path>>();
        for (String modID : CristelLibExpectPlatform.getModIds()) {
            if (modsWithConfig.contains(modID) || modID.equals("minecraft") || acConfig.blacklistedMods().contains(modID)) continue;
            CristelLibExpectPlatform.getRootPaths(modID).forEach(rootPath -> structureSets.put(modID, ModFinder.findSets(rootPath)));
        }
        return structureSets;
    }

    private static List<Path> findSets(Path rootPath) {
        ArrayList<Path> structureSets = new ArrayList<Path>();
        Path dataDir = rootPath.resolve("data");
        if (!Files.exists(dataDir, new LinkOption[0])) {
            return structureSets;
        }
        try (Stream<Path> namespaces = Files.list(dataDir);){
            namespaces.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(namespace -> {
                Path structureSetDir = namespace.resolve("worldgen").resolve("structure_set");
                try {
                    PathFinder.walk(structureSetDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]), (path, file) -> {
                        if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")) {
                            structureSets.add((Path)file);
                        }
                        return true;
                    }, true, Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return structureSets;
    }
}

