/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.client.simple;

import de.cristelknight.cristellib.config.client.simple.SimpleConfigScreen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientConfigRegistry {
    private static final Map<String, Set<SimpleConfigScreen>> CONFIGS_WITH_SCREEN = new HashMap<String, Set<SimpleConfigScreen>>();

    public static Map<String, Set<SimpleConfigScreen>> getAllConfigsWithScreen() {
        return CONFIGS_WITH_SCREEN;
    }

    public static boolean hasScreens(String modID) {
        return CONFIGS_WITH_SCREEN.containsKey(modID);
    }

    public static Set<SimpleConfigScreen> getScreens(String modID) {
        if (ClientConfigRegistry.hasScreens(modID)) {
            return CONFIGS_WITH_SCREEN.get(modID);
        }
        return Set.of();
    }

    public static <T> void registerScreen(String modIdForScreen, String screenName, Runnable onScreenSave, Class<T> simpleConfig) {
        CONFIGS_WITH_SCREEN.computeIfAbsent(modIdForScreen, k -> new HashSet()).add(new SimpleConfigScreen(simpleConfig, screenName, onScreenSave));
    }

    @Nullable
    public static SimpleConfigScreen getScreen(String modID, Class<?> simpleConfig) {
        for (SimpleConfigScreen screen : ClientConfigRegistry.getScreens(modID)) {
            if (screen.simpleConfig() != simpleConfig) continue;
            return screen;
        }
        return null;
    }
}

