/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.fabric.client;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import de.cristelknight.cristellib.autoconfig.ACConfig;
import de.cristelknight.cristellib.config.client.ScreenBuilder;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.util.Util;
import java.util.HashMap;
import java.util.Map;

public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return screenFactory -> Util.isClothConfigLoaded() ? new ScreenBuilder("cristellib").create(screenFactory, true, true) : null;
    }

    public Map<String, ConfigScreenFactory<?>> getProvidedConfigScreenFactories() {
        if (!Util.isClothConfigLoaded()) {
            return Map.of();
        }
        ACConfig acConfig = ConfigRegistry.get(ACConfig.class);
        boolean structureEnabled = !acConfig.disableAutoConfigScreens();
        HashMap screens = new HashMap();
        for (String modID : ScreenBuilder.allConfigMods(structureEnabled)) {
            Pair<Boolean, Boolean> structureSimple = ScreenBuilder.shouldCreateScreen(modID, structureEnabled);
            boolean structure = (Boolean)structureSimple.getFirst();
            boolean simple = (Boolean)structureSimple.getSecond();
            if (!structure && !simple) continue;
            screens.put(modID, providedConfigScreenFactories -> new ScreenBuilder(modID).create(providedConfigScreenFactories, structure, simple));
        }
        return screens;
    }
}

