/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib;

import com.google.common.collect.ImmutableMap;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.api.CristelLibAPI;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.builtinpacks.BuiltInPackConfig;
import de.cristelknight.cristellib.builtinpacks.RuntimePack;
import de.cristelknight.cristellib.config.simple.datafixer.DataFixer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CristelLib {
    public static final String MOD_ID = "cristellib";
    public static final String MC_ID = "minecraft";
    public static final Logger LOGGER = LogManager.getLogger((String)"Cristel Lib");
    public static final class_2960 CRISTEL_LIB_PACK_RL = class_2960.method_60655((String)"cristellib", (String)"runtime_pack");
    public static final RuntimePack RUNTIME_PACK = new RuntimePack(CRISTEL_LIB_PACK_RL, class_155.method_16673().method_70592(class_3264.field_14190).comp_4416(), "Runtime Pack for built-in features", CristelLibExpectPlatform.getResourceStream("cristellib", "pack.png"));
    private static final CristelLibRegistry REGISTRY = new CristelLibRegistry();

    public static String getWithPrefix(String message) {
        return String.format("[%s] %s", MOD_ID, message);
    }

    public static void init() {
    }

    public static void preInit() {
        DataFixer.registerFixer();
        CristelLibRegistry.configs = ImmutableMap.copyOf(CristelLibExpectPlatform.getConfigs(REGISTRY));
        BuiltInDataPackLoader.freeze();
        BuiltInPackConfig.updateConfig();
        for (Set pack : CristelLibRegistry.getConfigs().values()) {
            for (StructureConfig structureConfig : pack) {
                structureConfig.writeConfig(false);
                structureConfig.addSetsToRuntimePack();
            }
        }
    }

    public static void readAPI(CristelLibRegistry registry, String modID, CristelLibAPI api, Map<String, Set<StructureConfig>> configs) {
        try {
            api.registerBuiltInPacks();
            HashSet<StructureConfig> set = new HashSet<StructureConfig>();
            api.registerConfigs(set);
            configs.put(modID, set);
            api.registerStructureSets(registry);
            set.forEach(StructureConfig::getDefaultNamespace);
        }
        catch (Throwable e) {
            LOGGER.error("Mod: {} provides a broken implementation of CristelLibAPI", (Object)modID, (Object)e);
        }
    }
}

