/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.builtinpacks.BuiltinResourcePackSource;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.RuntimePackUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimePack
implements PackResources {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final Lock waiting = new ReentrantLock();
    private final Map<Identifier, Supplier<byte[]>> data = new ConcurrentHashMap<Identifier, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    public final int packVersion;
    private final String id;
    private final PackLocationInfo metadata;

    public RuntimePack(Identifier id, int version, String description, @Nullable InputStream imageStream) {
        byte[] image;
        this.packVersion = version;
        this.id = id.toString();
        this.metadata = new PackLocationInfo(this.id, (Component)Component.literal((String)description), (PackSource)new BuiltinResourcePackSource(), Optional.of(new KnownPack("cristellib", this.id, String.valueOf(version))));
        if (imageStream != null && (image = RuntimePackUtil.extractImageBytes(imageStream)) != null) {
            this.addRootResource("pack.png", image);
        }
        if (!this.hasRootResource("pack.mcmeta")) {
            JsonObject object = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)this.packVersion);
            pack.addProperty("min_format", (Number)this.packVersion);
            pack.addProperty("max_format", (Number)this.packVersion);
            pack.addProperty("description", description);
            object.add("pack", (JsonElement)pack);
            this.addRootResource("pack.mcmeta", RuntimePackUtil.serializeJson(object));
        }
    }

    public byte[] addStructureSet(Identifier identifier, JsonObject set) {
        return this.addDataForJsonLocation("worldgen/structure_set", identifier, set);
    }

    public byte[] addBiome(Identifier identifier, JsonObject biome) {
        return this.addDataForJsonLocation("worldgen/biome", identifier, biome);
    }

    public byte[] addStructure(Identifier identifier, JsonObject structure) {
        return this.addDataForJsonLocation("worldgen/structure", identifier, structure);
    }

    public byte[] addLootTable(Identifier identifier, JsonObject table) {
        return this.addDataForJsonLocation("loot_tables", identifier, table);
    }

    public byte @Nullable [] addDataForJsonLocationFromPath(String prefix, Identifier identifier, String fromSubPath, String fromModID) {
        JsonElement jsonElement = JanksonUtil.getElement(fromModID, fromSubPath);
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.addDataForJsonLocation(prefix, identifier, object);
        }
        return null;
    }

    public byte[] addDataForJsonLocation(String prefix, Identifier identifier, JsonObject object) {
        return this.addAndSerializeDataForLocation(prefix, "json", identifier, object);
    }

    public byte[] addAndSerializeDataForLocation(String prefix, String end, Identifier identifier, JsonObject object) {
        return this.addData(Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)(prefix + "/" + identifier.getPath() + "." + end)), RuntimePackUtil.serializeJson(object));
    }

    public byte[] addData(Identifier path, byte[] data) {
        this.data.put(path, () -> data);
        return data;
    }

    public void removeData(Identifier path) {
        this.data.remove(path);
    }

    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(strings));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public boolean hasRootResource(String ... strings) {
        return this.root.containsKey(Arrays.asList(strings));
    }

    @Nullable
    public IoSupplier<InputStream> getResource(@NotNull PackType packType, @NotNull Identifier id) {
        this.lock();
        Supplier<byte[]> supplier = this.data.get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public boolean hasResource(Identifier location) {
        return this.data.containsKey(location);
    }

    public void listResources(@NotNull PackType packType, @NotNull String namespace, @NotNull String prefix, @NotNull PackResources.ResourceOutput resourceOutput) {
        this.lock();
        for (Identifier identifier : this.data.keySet()) {
            Supplier<byte[]> supplier = this.data.get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            if (!identifier.getNamespace().equals(namespace) || !identifier.getPath().contains(prefix + "/")) continue;
            IoSupplier inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            resourceOutput.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    @NotNull
    public Set<String> getNamespaces(@NotNull PackType packType) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (Identifier identifier : this.data.keySet()) {
            namespaces.add(identifier.getNamespace());
        }
        this.waiting.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> metadataSectionType) {
        InputStream stream = null;
        try {
            IoSupplier<InputStream> supplier = this.getRootResource("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.get();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream == null) {
            CristelLib.LOGGER.error("Couldn't find pack.mcmeta of the Runtime Pack: {}", (Object)this.id);
        }
        return (T)FilePackResources.getMetadataFromStream(metadataSectionType, (InputStream)stream, (PackLocationInfo)this.metadata);
    }

    @NotNull
    public PackLocationInfo location() {
        return this.metadata;
    }

    @NotNull
    public String packId() {
        return this.id;
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            this.waiting.lock();
        }
    }

    public void close() {
        CristelLib.LOGGER.debug("Closing Runtime Data Pack: {}", (Object)this.id);
    }

    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String s = file.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = Files.readAllBytes(file);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String s = entry.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<Identifier, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(Identifier.fromNamespaceAndPath((String)namespace, (String)path), () -> data);
    }

    @Nullable
    public JsonObject getResource(Identifier location) {
        JsonObject jsonObject;
        IoSupplier<InputStream> stream = this.getResource(PackType.SERVER_DATA, location);
        try {
            jsonObject = GsonHelper.parse((Reader)new BufferedReader(new InputStreamReader((InputStream)stream.get(), StandardCharsets.UTF_8)));
        }
        catch (IOException | NullPointerException ex) {
            CristelLib.LOGGER.error("Couldn't get JsonObject from location: {}", (Object)location, (Object)ex);
            return null;
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpToFolder(Path output) throws IOException {
        this.lock();
        try {
            Path filePath;
            for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
                List<String> pathParts = entry.getKey();
                filePath = output.resolve(Paths.get("", pathParts.toArray(new String[0])));
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, entry.getValue().get(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
                Identifier rl = (Identifier)entry.getKey();
                filePath = output.resolve(Paths.get("data", rl.getNamespace(), rl.getPath()));
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, entry.getValue().get(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        finally {
            this.waiting.unlock();
        }
    }
}

